import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 121到140关数据
 */
export const Chapters7: ChapterData[] = [
    //121 褐色毛球  引导代加
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 37,
        passTarget: { type: 1, elements: [{ type: 9, count: 38 }] },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 0, 0, 0,
                0, 3, 3, 3, 3, 3, 3, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 3, 3, 3, 3, 3, 3, 0, 0,
                0, 0, 3, 3, 3, 3, 0, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 3, 3, 3, 3, 3, 3, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                9, 4, 1, 1, 1, 1, 4, 9, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                9, 1, 1, 1, 1, 1, 1, 9, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 20, 10, 10, 20, 0, 0, 0,
                0, 10, 30, 30, 40, 40, 50, 0, 0,
                0, 13, 40, 10, 20, 20, 13, 0, 0,
                0, 50, 40, 10, 50, 30, 50, 0, 0,
                0, 0, 10, 20, 20, 40, 30, 0, 0,
                0, 11, 20, 20, 30, 30, 40, 40, 0,
                0, 0, 10, 40, 40, 50, 50, 10, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 11, type: null },
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },

                { index: 19, type: null },
                { index: 24, type: null },
                { index: 27, type: null },
                { index: 34, type: null },

                { index: 54, type: null },
                { index: 61, type: null },
            ]
        }
    },
    //122
    {
        baseElementTypes: [0, 1, 3, 2, 4],
        bubbleProbability: 0.1,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 6, count: 2 }] },
        starScores: [5000, 12000, 21000],
        map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [[20, 38], [22, 40], [24, 42]], elements: [1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 1, 9, 1, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }] }
    },
    //123
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 17, passTarget: { type: 1, elements: [{ type: 9, count: 41 }] }, starScores: [5000, 15000, 22000], map: { lattices: [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0], connectedLats: [], elements: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 1, 1, 4, 5, 4, 1, 1, 0, 1, 1, 4, 5, 5, 5, 4, 1, 1, 0, 1, 1, 4, 5, 4, 1, 1, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 4, type: 0 }, { index: 12, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 36, type: 0 }, { index: 44, type: 0 }] }
    },
    //124
    {
        baseElementTypes: [1, 0, 2, 3, 4], bubbleProbability: 0, stepCount: 33, passTarget: { type: 1, elements: [{ type: 9, count: 13 }] }, starScores: [6000, 13000, 20000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 3, 3, 3, 3, 3, 1, 0, 1, 1, 3, 0, 0, 0, 3, 1, 1, 1, 1, 3, 0, 0, 0, 3, 1, 1, 1, 1, 3, 1, 0, 1, 3, 1, 1, 1, 1, 3, 0, 0, 1, 3, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [[76, 4]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1, 1, 1, 1, 1, 8, 9, 1, 1, 1, 1, 1, 1, 1, 9, 8, 1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }] }
    },
    //125
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 33,
        passTarget: {
            type: 1,
            elements: [{ type: 10, count: 12 }, { type: 5, count: 26 }]
        },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 0, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 0, 1, 0, 1, 0,
                1, 1, 1, 1, 1, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 0, 1, 0,
                1, 1, 1, 1, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 0, 1, 0, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 2, 2, 1, 2, 1, 9, 1, 1,
                1, 2, 2, 2, 1, 9, 1, 9, 1,
                1, 2, 2, 2, 2, 1, 9, 1, 1,
                1, 2, 2, 2, 1, 9, 1, 9, 1,
                1, 2, 2, 2, 2, 1, 9, 1, 1,
                1, 2, 2, 2, 1, 9, 1, 9, 1,
                1, 2, 2, 2, 2, 1, 9, 1, 1,
                1, 2, 2, 1, 1, 9, 1, 9, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                14, 0, 0, 0, 0, 0, 0, 0, 0,
                14, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 6, type: null }
            ]
        }
    },
    //126
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0.5,
        stepCount: 25,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 1, 3, 1, 3, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
            recycles: [54, 62, 73, 74, 75, 76, 77, 78, 79],
            connectedLats: [[29, 47], [30, 48], [32, 50], [33, 51]]
        },
    },
    //127
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 5, count: 24 }, { type: 2, count: 35 }, { type: 3, count: 35 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 8, 1, 1, 2, 2, 2, 1, 1, 8], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 4, type: null }, { index: 6, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 12, type: null }, { index: 14, type: null }, { index: 16, type: null }] }
    },
    //128
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 27,
        passTarget: {
            type: 1,
            elements: [
                { type: 5, count: 10 },
                { type: 1, count: 30 },
                { type: 2, count: 40 },
            ]
        },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 6, 1, 1, 1, 6, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                8, 1, 2, 1, 1, 1, 2, 1, 8,
                1, 1, 2, 1, 1, 1, 2, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },

                { index: 10, type: null },
                { index: 16, type: null },
                { index: 27, type: null },
                { index: 35, type: null }
            ]
        }
    },
    //129
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.8,
        stepCount: 23,
        passTarget: { type: 1, elements: [{ type: 5, count: 39 }] },
        starScores: [6000, 14000, 24000],
        map: {
            lattices: [1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            connectedLats: [],
            elements: [4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2],
            baseElements: [
                40, 0, 0, 0, 0, 0, 0, 0, 40,
                0, 40, 0, 0, 0, 0, 0, 40, 0,
                0, 0, 40, 0, 0, 0, 40, 0, 0,
                0, 0, 0, 40, 0, 40, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 0, 0, 0, 0, 43,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 40, 0, 0, 0, 43,
                0, 0, 0, 0, 24, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 8, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 48, type: 0 },
                { index: 49, type: 0 },
                { index: 50, type: 0 },
                { index: 57, type: 0 },
                { index: 58, type: 0, cus: [40, 44] },
                { index: 59, type: 0 }
            ]
        }
    },
    //130
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 9, count: 38 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [2, 0, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 2, 2, 2, 0, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 0, 2, 3, 3, 3, 3, 3, 2, 0],
            // connectedLats: [[74, 2], [75, 3], [76, 4], [77, 5], [78, 6]],
            elements: [1, 1, 0, 0, 5, 0, 0, 1, 1, 1, 4, 0, 0, 0, 0, 0, 4, 1, 1, 1, 4, 0, 4, 0, 4, 1, 1, 1, 1, 1, 4, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 7, 7, 7, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            recycles: [], 
            generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 16, type: null }]
        }
    },
    //131
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0.1, stepCount: 26, passTarget: { type: 1, elements: [{ type: 1, count: 60 }, { type: 5, count: 11 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1], connectedLats: [[27, 63], [37, 55], [43, 61], [35, 71]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 6, 2, 6, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20, 0, 0, 0, 0, 0, 20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 13, type: null }, { index: 17, type: null }, { index: 21, type: null }, { index: 23, type: null }] }
    },
    //132
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0.45,
        stepCount: 25,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 33
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    //133
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 9, count: 47 }] },
        starScores: [5000, 12000, 21000],
        map: { lattices: [1, 0, 2, 2, 2, 2, 2, 0, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 1, 0, 0, 3, 0, 0, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 2, 2, 2, 3, 1, 1, 1, 1, 3, 2, 2, 2, 3, 1, 1, 0, 1, 3, 2, 2, 2, 3, 1, 0], connectedLats: [[29, 47], [30, 48], [32, 50], [33, 51]], elements: [1, 1, 2, 4, 4, 4, 2, 1, 1, 2, 7, 2, 4, 4, 4, 2, 7, 2, 2, 7, 2, 4, 4, 4, 2, 7, 2, 2, 7, 2, 2, 2, 2, 2, 7, 2, 7, 7, 1, 1, 1, 1, 1, 7, 7, 7, 7, 1, 1, 1, 1, 1, 7, 7, 7, 7, 1, 4, 4, 4, 1, 7, 7, 7, 7, 1, 4, 4, 4, 1, 7, 7, 1, 7, 1, 4, 4, 4, 1, 7, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 16, type: null }] }
    },
    //134
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 27, passTarget: { type: 1, elements: [{ type: 6, count: 3 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[18, 36], [28, 46], [34, 52], [26, 44]], elements: [3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1, 0, 1, 2, 2, 2, 2, 2, 1, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 0, 5, 5, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [72, 73, 74, 75, 76, 77, 78, 79, 80], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //135
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.7, stepCount: 28, passTarget: { type: 1, elements: [{ type: 9, count: 50 }] }, starScores: [6000, 14000, 25000], map: { lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1], connectedLats: [], elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 0, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 4, 4, 4, 4, 4, 2, 1, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 12, type: 0 }, { index: 13, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 45, type: 0 }, { index: 53, type: 0 }] }
    },
    //136
    {
        baseElementTypes: [0, 2, 1, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 54 }] }, starScores: [5000, 12000, 21000], map: { lattices: [2, 2, 1, 0, 0, 0, 1, 2, 2, 3, 2, 1, 1, 0, 1, 1, 2, 3, 3, 2, 1, 1, 1, 1, 1, 2, 3, 0, 2, 2, 1, 1, 1, 2, 2, 0, 2, 3, 2, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 2, 3, 3, 3, 2, 3, 3, 3, 2, 2, 0, 0, 3, 3, 3, 0, 0, 2], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [12, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 42], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 12, type: null }, { index: 14, type: null }, { index: 22, type: null }] }
    },
    //137
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 9, count: 61 }] },
        starScores: [5000, 12000, 21000], map: { lattices: [2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 0, 2, 2, 2, 1, 2, 2, 2, 0, 1, 2, 2, 2, 1, 2, 2, 2, 1, 0, 1, 2, 2, 2, 2, 2, 1, 0, 1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 1, 2, 2, 2, 2, 2, 0, 0], connectedLats: [], elements: [1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 1, 1, 4, 1, 4, 1, 4, 1, 4, 7, 4, 1, 4, 1, 4, 1, 4, 1, 1, 1, 4, 1, 4, 1, 4, 1, 2, 7, 2, 1, 4, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 22, type: null }] }
    },
    //138
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0.3,
        stepCount: 26,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ROCK,
                    count: 40
                },
                {
                    type: ElementType.CHICKEN,
                    count: 50
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                2, 2, 1, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 1, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 1, 2, 2
            ],
            baseElements: [
                0, 0, 31, 0, 24, 0, 31, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 31, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
                2, 2, 30, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 30, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 30, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 30, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 30, 2, 2
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[2, 21], [4, 22], [6, 23]]
        },
    },
    //139
    {
        baseElementTypes: [0, 1, 3, 2, 4],
        bubbleProbability: 0.2,
        stepCount: 27,
        passTarget: { type: 1, elements: [{ type: 9, count: 31 }] }, starScores: [5000, 12000, 21000], map: { lattices: [2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 1, 2, 0, 2, 3, 1, 2, 1, 3, 2, 0, 0, 0, 3, 1, 1, 1, 3, 0, 0, 0, 2, 3, 3, 3, 3, 3, 2, 0, 2, 1, 1, 3, 0, 3, 1, 1, 2, 2, 1, 1, 3, 3, 3, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2], connectedLats: [[18, 54], [28, 46], [13, 31], [49, 67], [34, 52], [26, 62]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //140
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 31,
        passTarget: { type: 1, elements: [{ type: 9, count: 54 }] }, starScores: [5000, 12000, 21000], map: { lattices: [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2], connectedLats: [], elements: [4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 5, 4, 5, 4, 5, 4, 5, 4], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
]