import { Ani } from "../class/Ani";

//已是中心原点
export class MagicLionAni extends Ani {
    downImage: egret.DisplayObjectContainer;
    upImage: egret.Bitmap;
    constructor() {
        super()
        this.aniName = "MagicLionAni";

        this.downImage = new egret.DisplayObjectContainer();
        // this.downImage.scaleX = this.downImage.scaleY = 0.7;
        this.addChild(this.downImage)
        var texture: egret.Texture = RES.getRes("magicLionBg_png")
        let one = new egret.Bitmap(texture);
        one.anchorOffsetX = texture.textureWidth / 2;
        one.anchorOffsetY = texture.textureHeight / 2;
        this.downImage.addChild(one);
        this.addEventListener(egret.Event.ENTER_FRAME, () => {
            one.rotation -= 5;
        }, this);

        let other = new egret.Bitmap(texture);
        other.anchorOffsetX = texture.textureWidth / 2;
        other.anchorOffsetY = texture.textureHeight / 2;
        this.downImage.addChild(other);
        this.addEventListener(egret.Event.ENTER_FRAME, () => {
            other.rotation -= 5;
        }, this);

        //上图
        var texture: egret.Texture = RES.getRes("magicLion_png")
        this.upImage = new egret.Bitmap(texture);
        this.upImage.anchorOffsetX = texture.textureWidth / 2;
        this.upImage.anchorOffsetY = texture.textureHeight / 2;
        // this.upImage.scaleX = this.upImage.scaleY = 0.7
        this.addChild(this.upImage);
        this.addEventListener(egret.Event.ENTER_FRAME, () => {
            this.upImage.rotation += 2;
        }, this)
    }
    private onEnterFrame() {
        this.downImage.rotation += 5;
    }


    play() {
        this.downImage.scaleX = this.downImage.scaleY = 1;
        this.downImage.alpha = 1;
        this.upImage.scaleX = this.upImage.scaleY = 1;
        this.upImage.alpha = 1;
        egret.Tween.get(this.downImage)
            .to({ scaleX: 2, scaleY: 2 }, 300)
            .to({ scaleX: 1.2, scaleY: 1.2 }, 200)
            .wait(150)//和所有元素旋转时间一致，反正到时调整
            .to({ alpha: 0, scaleX: 0.2, scaleY: 0.2 }, 100)
            .call(() => {
                this.recover();
            })
        egret.Tween.get(this.upImage)
            .to({ scaleX: 1, scaleY: 1 }, 300)
            .to({ scaleX: 0, scaleY: 0, alpha: 0 }, 200)
    }

}