import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PropType from "../PropType";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import setGlow from "../setGlow";
import getHomeData from "../getHomeData";
import { showToast2 } from "../../libs/new_wx/ctrls/toastCtrl2";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import MainScene from "../mainScene/MainScene";

export default class Buy3Panel extends Panel {
    onTouchTap_closeBtn(){
        super.onTouchTap_closeBtn();
        PanelCtrl.instance.show('bagquit','Buy3')
    }
    start(data) {
        super.start();

        this['buyBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap, this);
        
        this['priceTxt'].text = '-'+window['price4'];
        setGlow(this['priceTxt'], 0x0083e8, 1);
        this['moneyTxt'].text = getHomeData().wealth;
    }

    buyBtn: eui.Button
    get skinKey() { return 'Buy3' }
    ontap() {
        this.buyBtn.enabled = false;
        NetManager.ins.hc_exchange((success) => {
            this.buyBtn.enabled = true;
            if (success) {
                if(SceneCtrl.instance.currentScene instanceof MainScene){
                    showToast('兑换成功');
                }else {
                    showToast2();
                }
                this.hidePanel();
                NetManager.ins.hc_home(() => {
                    SceneCtrl.instance.updateScene();
                }, window['collectRuleId']);
            }else{
                showToast('元宝不足哦~\n快去玩游戏赢元宝吧');
            }
        }, PropType.CHANCE_NUM);//兑换道具
    }
}