import Panel from "../../libs/new_wx/components/Panel";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { createEffect1MovieClip } from "../effect/createEffect1";
import RedBombRule from "./RedBombRule";

export default class BombTipsPanel extends Panel {
    async start(data) {
        super.start();
        this.showlog();
        egret.Tween.get(this['light'], { loop: true }).to({ rotation: 360 }, 8000);

        egret.Tween.get(this['ele2'], { loop: true }).to({ x: this['ele2'].x + 30, y: this['ele2'].y - 30 }, 1000)
            .to({ x: this['ele2'].x, y: this['ele2'].y }, 1000);

        egret.Tween.get(this['ele1'], { loop: true }).to({ x: this['ele1'].x + 30, y: this['ele1'].y - 30 }, 1000)
            .to({ x: this['ele1'].x, y: this['ele1'].y }, 1000);

        egret.Tween.get(this['ele3'], { loop: true }).to({ x: this['ele3'].x - 30, y: this['ele3'].y - 30 }, 1000)
            .to({ x: this['ele3'].x, y: this['ele3'].y }, 1000);

        egret.Tween.get(this['ele4'], { loop: true }).to({ x: this['ele4'].x - 30, y: this['ele4'].y + 30 }, 1000)
            .to({ x: this['ele4'].x, y: this['ele4'].y }, 1000);

        this.touchChildren = this.touchEnabled = false;
        await RES.getResAsync('effect1_json');
        await RES.getResAsync('effect2_json');
        this.touchChildren = this.touchEnabled = true;
    }

    showlog() {
    }

    initEvents() {
        super.initEvents();
        this['btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTapInvite, this);
        this['rulebtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTapInvite2, this);
    }

    onTapInvite2() {
        const rule = new RedBombRule();
        rule.loadSkin();
        rule.start();
        this.addChild(rule);
    }
    
    onTapInvite() {
        this['btn'].touchEnabled=false;
        const eles = ['btn', 'rulebtn', 'bg', 'ele1', 'ele2', 'ele3', 'ele4', 'light'];
        const dur = 100;
        eles.forEach((e, index) => {
            egret.Tween.get(this[e]).to({ alpha: 0 }, dur);
        });
        const mask = PanelCtrl.instance._mask;
        egret.Tween.get(mask).to({ alpha: 0 }, dur);
        egret.Tween.get(this['redbag']).to({ scaleX: 0.7, scaleY: 0.7 }, 100)
            .to({ scaleX: 1.5, scaleY: 1.5, alpha: 0 }, 300);

        setTimeout(() => {
            const mc = createEffect1MovieClip();
            this.addChild(mc);
        }, 200);

        setTimeout(() => {
            SceneCtrl.instance.currentScene['showRedBagAni']();
        }, 400);

        setTimeout(() => {
            this.hidePanel();
        }, 1000);
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'RedBombTips' }
}