
class EventEmitter {
  _events: {};
  constructor() {
    this._events = {};
  }

  on(event, callback) {
    const callbacks = this._events[event] || [];
    callbacks.push(callback);
    this._events[event] = callbacks;
    return this;
  }

  off(event, callback) {
    const callbacks = this._events[event];
    this._events[event] = callbacks && callbacks.filter(fn => fn !== callback);
    return this;
  }

  emit(...args) {
    const event = args[0];
    const params = [].slice.call(args, 1);
    const callbacks = this._events[event];
    if (callbacks) {
      callbacks.forEach(fn => fn.apply(this, params));
    }
    return this;
  }

  once(event, callback) {
    const wrapFunc = (...args) => {
      callback.apply(this, args);
      this.off(event, wrapFunc);
    };
    this.on(event, wrapFunc);
    return this;
  }

  removeAll() {
    this._events = {};
  }
}

export default EventEmitter;
