

import { State } from "../class/State";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { ElementType } from "../enum/ElementType";

/**
 * 变色气泡状态
 * 变色动画放外面
 */
export class BubbleState extends State {
    /**
     * 显示图片
     */
    private showImage: egret.Bitmap;

    constructor(type: ElementType) {
        super();
        this.showImage = new egret.Bitmap();
        this.changeSource("bubleEle" + type + "_png");
        this.addChild(this.showImage);
    }

    //重置为指定的类型，直接设置。没有过度动效
    reset(type: ElementType) {
        this.changeSource("bubleEle" + type + "_png");
    }
    //直接回收
    recover() {
        if (this.parent) this.parent.removeChild(this);
        Pool.recover(RecoverName.BUBBLE_STATE, this);
    }

    private changeSource(source: string) {
        var texture: egret.Texture = RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.x = -texture.textureWidth / 2;
        this.showImage.y = -texture.textureHeight / 2
    }
}