import { ImageAni } from "../class/ImageAni";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { playSound, SoundType } from "../../soundCtrl";
import { Element } from "../class/Element";
import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";


export const stepPosition: number[] = [125, 115];
/**
 * 需要回调的
 * 手动修改this.shoot.rotation=
 */
export class FesRedShootAni extends egret.DisplayObjectContainer {
    light: LightingAni;
    imageAni: ImageAni;
    imageAniCon: egret.DisplayObjectContainer
    constructor() {
        super()
        this.light = new LightingAni();
        this.addChild(this.light);
        var arr = []
        for (var i = 1; i <= 10; i++) {
            arr.push("fesEleSmallDis" + i + "_png");
        }
        this.imageAniCon = new egret.DisplayObjectContainer();
        this.imageAni = new ImageAni(arr);
        this.imageAniCon.addChild(this.imageAni);
        this.addChild(this.imageAniCon);
        this.imageAni.visible = false
    }
    reset() {
        this.light.visible = true;
        this.imageAni.visible = false;
        this.light.scaleX = 0.2;
    }

    play(startP: number[], ele: Element, callback: Function) {
        this.reset()
        //算角度 
        var r = Tool.getForwardRotation(startP, [ele.x, ele.y])
        this.light.rotation = r * 180 / Math.PI;
        this.light.x = startP[0];
        this.light.y = startP[1];
        this.imageAniCon.x = ele.x;
        this.imageAniCon.y = ele.y;
        //247
        var dis = Math.sqrt(
            (startP[0] - ele.x) * (startP[0] - ele.x) +
            (startP[1] - ele.y) * (startP[1] - ele.y)
        )
        var scaleX = dis / 247;
        egret.Tween.get(this.light)
            .to({ scaleX: scaleX, }, 400)
            .call(() => {
                ele.reset(ElementType.FESTIVALELE_SMALL);
                ele.scaleX = ele.scaleY = 0.1
                egret.Tween.get(ele)
                    .to({ scaleX: 1, scaleY: 1 }, 500, egret.Ease.backOut)

                //回调
                callback();

                this.imageAni.visible = true;
                this.imageAni.play(() => {
                    if (this.$parent) {
                        this.$parent.removeChild(this)
                    };
                    Pool.recover(RecoverName.FESREDSHOOT_ANI, this)
                })
                setTimeout(() => {
                    this.light.visible = false;
                }, 200)

            })
    }
}



class LightingAni extends egret.Bitmap {
    sourceAll: string[];
    currentFrame: number;
    totalFrames: number;
    isPlay: boolean;

    startTime: number
    /**
     * 所有时间，帧数按每秒30
     */
    allTime: number
    /**
     * 播放完的回调
     */
    constructor() {
        super();
        var arr = [];
        for (var i = 1; i <= 13; i++) {
            arr.push("lineLight" + i + "_png")
        }
        this.anchorOffsetX = 23;
        this.anchorOffsetY = 27;
        this.sourceAll = arr;
        this.texture = RES.getRes(this.sourceAll[0])
        this.currentFrame = 0;
        this.totalFrames = arr.length;
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)

        this.startTime = Date.now()
        this.allTime = this.sourceAll.length / 30 * 1000;

    }
    onEnterFrame() {
        if (!this.stage) return
        var dataNow = Date.now();
        var deltaTime = dataNow - this.startTime;
        var scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.startTime = Date.now()
            this.currentFrame = 0;
        } else {
            this.currentFrame = (scale * this.sourceAll.length) >> 0;
        }
        this.texture = RES.getRes(this.sourceAll[this.currentFrame])
    }
}

