

export class Pool {
    private static pool = {};

    /**
     * 取出
     * @param name 
     */
    public static takeOut(name: string) {
        if (this.pool[name] && this.pool[name].length) {
            return this.pool[name].shift();
        }
        return null;
    }

    /**
     * 回收
     * @param name 
     * @param obj 
     */
    public static recover(name: string, obj) {
        if (!this.pool[name]) {
            this.pool[name] = [];
        }
        this.pool[name].push(obj);
    }
}