export default (img: egret.DisplayObject, color: number,alpha:number) => {
    // const color = 0x33CCFF;        /// 光晕的颜色，十六进制，不包含透明度
    // const alpha = 0.8;             /// 光晕的颜色透明度，是对 color 参数的透明度设定。有效值为 0.0 到 1.0。例如，0.8 设置透明度值为 80%。
    const blurX = 1;              /// 水平模糊量。有效值为 0 到 255.0（浮点）
    const blurY = 1;              /// 垂直模糊量。有效值为 0 到 255.0（浮点）
    const strength = 4;            /// 压印的强度，值越大，压印的颜色越深，而且发光与背景之间的对比度也越强。有效值为 0 到 255。暂未实现
    const quality: number = egret.BitmapFilterQuality.HIGH;        /// 应用滤镜的次数，建议用 BitmapFilterQuality 类的常量来体现
    const inner = false;            /// 指定发光是否为内侧发光，暂未实现
    const knockout = false;            /// 指定对象是否具有挖空效果，暂未实现
    const glowFilter: egret.GlowFilter = new egret.GlowFilter(color, alpha, blurX, blurY,
        strength, quality, inner, knockout);
    img.filters = [glowFilter];

}