import getResPath from "../../libs/new_tc/getResPath";
import Panel from "../../libs/new_wx/components/Panel";
import { getRedBombTimes } from "../getRedBombAward";
import { loadSvga } from "../loadSvga";
import { DataManager } from "../../libs/tw/manager/DataManager";

export default class RedBombAlertPanel extends Panel {
    async start(data) {
        super.start();
        this.showlog();

        const times = getRedBombTimes();
        this['tips'].text = `今日还有${times}个红包在其他关卡等你哦~`;
        if (times <= 0) {
            this['tips'].text = `当日红包任务达成，明日再来~`;
        }
        this['group'].alpha = 0;
        egret.Tween.get(this['group']).wait(1500).to({ alpha: 1 }, 300);
        loadSvga(getResPath() + 'resource/assets/svgas/redbomb.svga').then(async (mv: any) => {
            this.addChild(mv);
            mv.once(egret.Event.COMPLETE, () => {
                mv.stop();
                this.removeChild(mv);
                //条件再修改，根据后端数据
                const data = DataManager.ins.getData('hc_redBombAward').data;
                if(data&&data.option){
                    this.playPrizeAni();
                }else{
                    this.playNoPrizeAni();
                }
            }, this);
        });
    }

    playNoPrizeAni() {
        loadSvga(getResPath() + 'resource/assets/svgas/redbomb_noprize.svga').then(async (mv: any) => {
            //去掉文案
            egret.Tween.get(this['group']).to({alpha:0},300);
            this.addChild(mv);
            mv.once(egret.Event.COMPLETE, () => {
                mv.stop();
                this.once(egret.TouchEvent.TOUCH_TAP,()=>{this.hidePanel()},this);
            }, this);
        });
    }

    playPrizeAni(){
        loadSvga(getResPath() + 'resource/assets/svgas/redbomb_prize.svga').then(async (mv: any) => {
            //去掉文案
            egret.Tween.get(this['group']).to({alpha:0},300);
            this.addChild(mv);
            mv.once(egret.Event.COMPLETE, () => {
                mv.stop();
                this.once(egret.TouchEvent.TOUCH_TAP,()=>{this.hidePanel()},this);
            }, this);
            setTimeout(()=>{
                mv.setImage("img_2349",DataManager.ins.getData('hc_redBombAward').data.option.img)
            },100)
            
        });
    }

    showlog() {
    }

    initEvents() {
        super.initEvents();
        // this['btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTapInvite, this);

    }

    onTapInvite() {

    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'RedBombAlert' }
}