import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PropType from "../PropType";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { getlogItem } from "../Main";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import setGlow from "../setGlow";
import getHomeData from "../getHomeData";
import { showToast2 } from "../../libs/new_wx/ctrls/toastCtrl2";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";

export default class ExchangePanel extends Panel {
    onTouchTap_closeBtn(){
        super.onTouchTap_closeBtn();
        PanelCtrl.instance.show('bagquit','ExchangePanel')
    }
    start(data) {
        super.start();

        this['buyBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap, this);
        this.showlog();
        this['priceTxt'].text = '-'+window['price5'];
        setGlow(this['priceTxt'], 0x0083e8, 1);
        this['moneyTxt'].text = getHomeData().wealth;
    }
    showlog() {
        NetManager.ins.showLog(getlogItem(41));
    }
    buyBtn: eui.Button
    get skinKey() { return 'Exchange' }
    ontap() {
        NetManager.ins.clickLog(getlogItem(41));
        this.buyBtn.enabled = false;
        NetManager.ins.hc_exchange((success) => {
            this.buyBtn.enabled = true;
            if (success) {
                showToast2();
                this.hidePanel();
                NetManager.ins.hc_home(() => {
                    SceneCtrl.instance.updateScene();
                }, window['collectRuleId']);
            }else{
                showToast('元宝不足哦~\n快去玩游戏赢元宝吧');
            }
        }, PropType.CASH_NUM);//兑换道具
    }
}