import Panel from "./Panel";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import RankItem from "./RankItem";

export default class RankPanel extends Panel {
    public ruleBg: eui.Image;
    public closeBtn: eui.Button;
    public scroller: eui.Scroller;
    public group: eui.Group;
    public list: eui.List;
    public title: eui.Image;
    public dog: eui.Image;
    public rankNum: eui.Label;
    public userIdtxt: eui.Label;
    public scoretxt: eui.Label;
    public userItemBg: eui.Image;
    public userRankNum: eui.Label;
    public userId: eui.Label;
    public userScore: eui.Label;
    public num3: eui.Image;
    public num2: eui.Image;
    public num1: eui.Image;


    async start() {
        super.start();
        NetManager.ins.recentRankListNew((success: boolean) => {
            if (success) {
                this.updatePanel();
            }
        }, window['rankId'] || 30);
    }

    updatePanel() {
        const { data } = DataManager.ins.getData('recentRankListNew');
        if (data.currentRankList && data.currentRankList.currentUserRankInfo) {
            this.userId.text = `我`;
            this.userRankNum.text = data.currentRankList.currentUserRankInfo.rank ? `${data.currentRankList.currentUserRankInfo.rank}` : '未上榜';
            this.userScore.text = data.currentRankList.currentUserRankInfo.rank ? `${data.currentRankList.currentUserRankInfo.rank}` : '暂无分数';
        } else {
            this.userId.text = `我`;
            this.userRankNum.text = `未上榜`;
            this.userScore.text = `暂无分数`;
        }

        if (data.currentRankList && data.currentRankList.userRankList) {
            this.list.useVirtualLayout = false;
            this.list.itemRenderer = RankItem;
            const ac = new eui.ArrayCollection(data.currentRankList.userRankList);
            this.list.dataProvider = ac;
        }
    }


    get skinKey() { return 'Rank' }
}