let soundOn = true;
if (localStorage.getItem('soundOn') == null) {
    soundOn = true;
    localStorage.setItem('soundOn', "1");
}
else
    soundOn = localStorage.getItem('soundOn') == '1';

let bgOn = true;
if (localStorage.getItem('bgOn') == null) {
    bgOn = true;
    localStorage.setItem('bgOn', "1");
}
else
    bgOn = localStorage.getItem('bgOn') == '1';

let bgChannel: egret.SoundChannel;
let loading = false;
export const getSoundOn = () => {
    return soundOn
}
export const getBgOn = () => {
    return bgOn
}

export const toggleSound = () => {
    soundOn = !soundOn;
    localStorage.setItem('soundOn', soundOn ? "1" : "0")
}

export const toggleBgStatus = () => {
    bgOn = !bgOn;
    localStorage.setItem('bgOn', bgOn ? "1" : "0")
}

export const toggleBg = () => {
    bgOn = !bgOn;
    localStorage.setItem('bgOn', bgOn ? "1" : "0")
    if (bgChannel) {
        if (!bgOn) {
            bgChannel.stop();
            bgChannel = null;
        }
    } else {
        if (bgOn) {
            playBg();
        }
    }
}

export const stopBg = () => {
    if (bgChannel) {
        bgChannel.stop();
        bgChannel = null;
    }
};

export const playBg = async () => {
    if (bgChannel) return;
    if (loading) return;
    loading = true;
    const bg = await RES.getResAsync('mapBg_mp3');
    bgChannel = bg.play();
    loading = false;
}

export enum SoundType {
    click = 'click',
    bounce = 'bounce',
    good = 'good',
    recover = 'recover',
    shoot = 'shoot',

    fall = 'fall',
    magic = 'magic',
    boom = 'boom',
    sucess = 'sucess',
    mapBg = 'mapBg',
    eliminate = 'eliminate',
    toast = 'toast',
    fail = 'fail',
    playBg = 'playBg',
    line = 'line',
    bonusShoot = 'bonusShoot',
}

export const playSound = (type: SoundType) => {
    if (!soundOn) return;
    const sound: egret.Sound = RES.getRes(type + "_mp3");
    if (sound)
        sound.play(0, 1);
    else
        RES.getResAsync(type + "_mp3")
}