import { Element } from "../class/Element";

/**
 * 掉落动画数据
 */
export interface FallAniData {
    /**
     * 掉落元素，设为null的时候要生成，并且通过遮罩，生成动画
     */
    ele: Element;
    /**
     * 等待时间，一般用于一个生成口有多个元素排列着的情况
     * ele为null才需要wait
     */
    wait?: number;
    /**
     * 起点、中间点及终点的索引，穿过记录下格子，不可能为空
     * 索引加类型
     */
    indexs: { index: number, type: FallType }[]
    // indexs:number[];
}

export enum FallType {
    STRIGHT = 0, //垂直
    THROUGH, //连通穿过
}