import Panel from "../../libs/new_wx/components/Panel";
import SignItem from "./SignItem";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { updateMainTimer } from "../../libs/new_wx/MainBase";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import wait from "../../libs/new_tc/wait";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import { getlogItem } from "../Main";

export default class SignPanel extends Panel {
   
    list: eui.List;
    scroll: eui.Scroller;
    async start(data) {
        super.start();

        const { signInfoVO } = DataManager.ins.getData('getSignInfo');

        let todayIndex = signInfoVO.continueDay - 1;
        if (!signInfoVO.todaySigned) {
            todayIndex = signInfoVO.continueDay;
        }

        this.scroll.viewport.scrollV = todayIndex * 162;
        if(todayIndex >=4) {
            this.scroll.viewport.scrollV = 4 * 162;
        }

        const tomorrowIndex = todayIndex + 1;

        this.list.itemRenderer = SignItem;
        const configs = window['signconfigs'];
        const func = (data,item:SignItem) => {
            try {
                if (window['getRST']) window['getRST']();
            } catch (error) {
                console.warn(error)
            }
            item['btn1'].enabled=false;
            NetManager.ins.doSign((s)=>{
                NetManager.ins.showLog(getlogItem(22));
                item['btn1'].enabled=true;
                wait(300).then(()=>{
                    NetManager.ins.getSignInfo(() => {
                        SceneCtrl.instance.updateScene();
                    }, window['signActivityId']);
                });
                
                if(s) {
                    const {customInfo,success} =DataManager.ins.getData('dosign');
                    if(!success  || !customInfo.success || customInfo.prizeType =='none') {
                        if(customInfo.code==100004) {
                            showToast('哎呀，奖励擦肩而过！明天再来试试吧！');   
                        }else {
                            showToast('哎呀，奖励擦肩而过！');
                        }
                        return;
                    }

                    item.setSinged();
                    // showToast('签到成功！快去闯关吧~');
                    // PanelCtrl.instance.show('signPrize');
                    PanelCtrl.instance.addToShowPanels('signPrize');
                    wait(200).then(()=>{
                        NetManager.ins.hc_home(() => {
                            updateMainTimer();
                            SceneCtrl.instance.updateScene();
                            
                        }, window['collectRuleId']);
                    });
                }else {
                    showToast('哎呀，奖励擦肩而过！');
                }

                this.hidePanel();
            }, window['signActivityId'])
            console.log(data);
        };
        const list: any[] = [{}, {}, {}, {}, {}, {}, {}];
        list.forEach((ele, index) => {
            ele.index = index;
            ele.config = configs[index];
            ele.func = func;

            ele.signed = signInfoVO.continueDay > index;

            if (index < todayIndex) {//以前
                ele.btn = 2;
            } else if (index == todayIndex) {//现在 
                if (signInfoVO.todaySigned)
                    ele.btn = 2;
                else
                    ele.btn = 1;
            } else if (index == tomorrowIndex) {
                ele.btn = 3;
            } else
                ele.btn = 4;
        });
        this.list.dataProvider = new eui.ArrayCollection(list);
        this.list.useVirtualLayout = false;

        //要更新元宝数量



        // this['close2Btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => { 
        //     NetManager.ins.clickLog(getlogItem(17));

        // }, this);
        // this.showlog();
        // this.data.img = DataManager.ins.getData('getPlugOrderStatus').lottery.imgurl;
    }
    // showlog() {
    //     NetManager.ins.showLog(getlogItem(17));
    // }
    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['close2Btn']] }
    get skinKey() { return 'Sign' }
}