import getSkinPath from "../../libs/new_wx/utils/getSkinPath";
import { getNick } from "../mapScene/MapScene";

export default class FriendItemRenderer extends eui.ItemRenderer {
    constructor() {
        super();
        this.skinName = getSkinPath('FriendItem');
    }
    progress: eui.Label;
    score: eui.Label;
    dataChanged() {
        const rank = this.data.rank;
        this['avatar'].mask = this['avatarMask'];

        this['rank1'].visible = this['rank2'].visible = this['rank3'].visible = this['rankTxt'].visible = false;
        this['rankTxt'].text = rank + '';
        if (rank == 1) {
            this['rank1'].visible = true;
        } else if (rank == 2) {
            this['rank2'].visible = true;
        } else if (rank == 3) {
            this['rank3'].visible = true;
        } else {
            this['rankTxt'].visible = true;
        }

        this['nameTxt'].text = getNick(this.data.nickName,10) ;
        this['avatar'].source = this.data.avatar||"http://yun.duiba.com.cn/db_games/default_avatar.png";
        this['star'].text = `X${this.data.stars}`;
        this.progress.textFlow = (new egret.HtmlTextParser).parser(
            `第<font color=0xff4501><b>${this.data.levelNum}</b></font>关`);
        this.score.textFlow = (new egret.HtmlTextParser).parser(
            `<font color=0xff4501><b>${this.data.maxScore}</b></font>分`);
    }
}