import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import getHomeData from "../getHomeData";
import { getlogItem } from "../Main";
import AdSmallComp from "../mapScene/AdSmallComp";
import { handleVideo } from "../myVideo/videoCtrl";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import Loading from "../../libs/new_wx/components/Loading";
import { updateMainTimer } from "../../libs/new_wx/MainBase";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";

export default class BoxPanel extends Panel {
    start(data) {
        super.start();
        this['close2Btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {

        }, this);

        addAdComp(84, 824.52, this, 27);

        const hc_openTreasureBox = DataManager.ins.getData('hc_openTreasureBox');
        const boxdata = hc_openTreasureBox.data;
        this.updateOption(boxdata.option);

        const homedata = getHomeData();

        let num = homedata.nextRangeStarsNum - homedata.totalStars;
        if (num < 0) {
            num = 0;
            this['tips'].text = ``;
        }
        else {
            this['tips'].text = `再收集${num}颗星星就可开启下个宝箱咯`;
        }

        //曝光
        NetManager.ins.showLog(getlogItem(11))
        //新增看视频双倍
        this['close2Btn'].visible = false;
        this["doubleBtn"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            NetManager.ins.clickLog(getlogItem(12))
            handleVideo(
                (s) => {
                    if (s) {
                        this['close2Btn'].visible = true;
                        this['doubleBtn'].visible = false;
                        Loading.instace.show()
                        NetManager.ins.getIncentiveAward(
                            (s) => {
                                Loading.instace.hide()
                                if (s) {
                                    // showToast("成功加倍");
                                    NetManager.ins.hc_home(() => {
                                        updateMainTimer();
                                        SceneCtrl.instance.updateScene();
                                    }, window['collectRuleId']);
                                } else {
                                    showToast("加倍失败");
                                    this.hidePanel();
                                }
                            },
                            22
                        )
                    } else {
                        showToast("广告未成功观看，无法加倍领取");
                    }
                },
                () => {
                    NetManager.ins.getIncentiveAward(
                        () => { },
                        22
                    )
                },
                window["slotid"]
            )
        }, this)

    }

    updateOption(option: any) {
        const { categoryType, img, num, propType, realValue } = option;// 2次数  3道具 4元宝 5实物 6优惠券 7虚拟商品

        this['propnums'].text = 'x1';
        this['propnums2'].text = 'x1';
        if (num) {
            this['propnums'].text = 'x' + num;
            this['propnums2'].text = 'x' + num;
        }
        switch (categoryType) {
            case 2:
                this['blood'].visible = true;
                this['numsgroup'].visible = true;
                break;
            case 3:
                this['numsgroup'].visible = true;
                this['img2'].visible = true;
                this.data.url2 = `common_prop${propType}_png`;
                break;
            case 4:
                this['numsgroup'].visible = false;
                this['propnums2'].visible = true;
                this['money'].visible = true;
                this['propnums2'].text = realValue;
                break;
            default:
                this['img'].visible = true;
                this.data.url = img;
                break;
        }
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['close2Btn']] }
    get skinKey() { return 'Box' }
}

export const addAdComp = (x, y, parent: egret.DisplayObjectContainer, logid?) => {
    //调用地方很多，直接这里置空，广告去掉
    // const comp = new AdSmallComp();
    // comp.loadSkin();
    // comp.start({ logid: logid });
    // parent.addChildAt(comp, 0);
    // comp.x = x;
    // comp.y = y;
}
