import wait from "../../libs/new_tc/wait";
import Panel from "../../libs/new_wx/components/Panel";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { updateMainTimer } from "../../libs/new_wx/MainBase";
import { NetManager } from "../../libs/tw/manager/NetManager";
import getHomeData, { BLOOD_NUMS_MAX } from "../getHomeData";
// import { getShareUrl } from "../getSharePic";
import { iswx } from "../iswx";
import CountDown from "../mapScene/CountDown";
// import { showShare } from "../shareCtrl";
import BloodPanel from "./BloodPanel";

export default class BloodPanel2 extends Panel {
    start(data) {
        super.start();
        this.updateData();
        this['price1Txt'].text = `${window['price1']}个元宝=1个体力值`;


    }



    private _countDown: CountDown;
    private updateData() {
        if (this._countDown == null) {
            this._countDown = new CountDown(this['countdownTxt'], (str) => `距离下一次体力补给时间:${str}`);
        }
        const homeData = getHomeData();
        this['bloodTxt'].text = `你的可用体力值为：${homeData.remainEnargy}`;
        const data = getHomeData();
        if (data.remainEnargy >= BLOOD_NUMS_MAX) { //满了
            this['bloodTxt'].text = `你的可用体力值为：${homeData.remainEnargy}`;
            this._countDown.stop();
            this['countdownTxt'].visible = false;
        } else {
            this['countdownTxt'].visible = true;
            const left = data.refectionCountdown - Math.floor(new Date().getTime() / 1000);
            this._countDown.reset(left);
        }
    }

    updateTimerView() {
        this.updateData();
    }

    initEvents() {
        super.initEvents();
        this['buyBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTapBuy, this)
    }

    onTapBuy() {
        this['buyBtn'].enabled = false;
        NetManager.ins.hc_exchange((success, res) => {
            this['buyBtn'].enabled = true;
            if (success) {
                showToast('兑换成功');
                NetManager.ins.hc_home(() => {
                    this.updateData();
                    updateMainTimer();
                    SceneCtrl.instance.updateScene();

                }, window['collectRuleId']);
            }
            else if (res) {
                showToast(res.desc || "网络异常")
            } else {
                showToast("网络异常，请重试")
            }
        }, 1);
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'Blood2' }
}