import { MobileDetect } from "./mobile-detect";

const getUrlParameter = (name, path = window.location.href) => {
    const result =
        decodeURIComponent(
            (new RegExp('[?|&]' + name + '=([^&;]+?)(&|#|;|$)').exec(path) || [undefined, ''])[1].replace(/\+/g, '%20')
        ) || null;
    return result;
};

function getCookie(key) {
    var arr1 = document.cookie.split("; ");//由于cookie是通过一个分号+空格的形式串联起来的，所以这里需要先按分号空格截断,变成[name=Jack,pwd=123456,age=22]数组类型；
    for (var i = 0; i < arr1.length; i++) {
        var arr2 = arr1[i].split("=");//通过=截断，把name=Jack截断成[name,Jack]数组；
        if (arr2[0] == key) {
            return decodeURIComponent(arr2[1]);
        }
    }
    return null
}
export const getUrl = (name) => {
    var str = getCookie("dcustom");
    if (str) {
        //&分割
        var arr = str.split("&");
        for (var i = 0; i < arr.length; i++) {
            if (arr[i].indexOf(name + "=") == 0) {
                return arr[i].replace(name + "=", "");
            }
        }
    }
    return null
};

// const getUrl = (name) => {
//     return getUrlParameter('_ext_' + name);
// };

export function replaceUrl(url, replaceConfig) {
    for (const i in replaceConfig) {
        if (replaceConfig[i]) {
            url = url.replace(i, replaceConfig[i]);
        }
    }
    return url;
}
export function replaceMacro1(url, mouseE) {
    const x = mouseE.screenX;
    const y = mouseE.screenY;
    const point = JSON.stringify({
        down_x: x,
        down_y: y,
        up_x: x,
        up_y: y
    });
    const encodeP = encodeURI(point);
    return replaceUrl(url, {
        __ABSOLUTE_COORD__: point,
        __RELATIVE_COORD__: point,
        '{ABSOLUTE_COORD}': encodeP,
        '{RELATIVE_COORD}': encodeP,
        '{UUID}': defaultConfig.imei || defaultConfig.idfa,
    });
}

export function replaceMacro2(url, mouseE,
    { responseTime = '', readyTime = '', showTime = '', clickTime = '' }) {
    const x = mouseE.screenX;
    const y = mouseE.screenY;
    return replaceUrl(url, {
        __RESPONSE_TIME__: responseTime,
        __READY_TIME__: readyTime,
        __SHOW_TIME__: showTime,
        __CLICK_TIME__: clickTime,
        __DOWN_X__: x,
        __DOWN_Y__: y,
        __UP_X__: x,
        __UP_Y__: y,
        __WIDTH__: x,
        __HEIGHT__: y
    });
}

const reflectObj = {
    wifi: 1,
    '2g': 2,
    '3g': 3,
    '4g': 4,
    '5g': 5,
    other: 6
};

function getNetworkType(obj = reflectObj) {
    const ua = navigator.userAgent;
    let networkStr = ua.match(/NetType\/\w+/) ? ua.match(/NetType\/\w+/)[0] : 'NetType/other';
    networkStr = networkStr.toLowerCase().replace('nettype/', '');
    let networkType;
    switch (networkStr) {
        case 'wifi':
            networkType = 'wifi';
            break;
        case '4g':
            networkType = '4g';
            break;
        case '3g':
            networkType = '3g';
            break;
        case '3gnet':
            networkType = '3g';
            break;
        case '2g':
            networkType = '2g';
            break;
        default:
            networkType = 'other';
    }
    if (obj[networkType]) {
        return obj[networkType];
    }
    return networkType;
}

let defaultConfig;
export function getDefaultConfig(slotid: string) {
    if (window["tryWuhanVideo"]) return {
        "slotid": "1007",
        "ost": 1,
        "osv": "9.5.6",
        "bundle": "om.mechat.api", "appv": "1.0",
        "devt": 1,
        "vendor": "vivo",
        "model": "x27",
        "idfa": "",
        "imei": "866171035641358", "androidid": "866171035641358", "imsi": "13723456671",
        "mac": "00:03:5B:08:A6:16",
        "sw": 720,
        "sh": 1280,
        "ppi": 400,
        "ipv4": "221.12.7.235", "opert": 1,
        "connt": 1,
        "adw": 580,
        "adh": 90
    };
    if (defaultConfig) return defaultConfig;
    defaultConfig = {};
    // defaultConfig = {
    //     "slotid":"12345",
    //     "ost":1,
    //     "osv":"9.5.6",
    //     "bundle":"om.mechat.api",
    //     "appv":"1.0",
    //     "devt":1,
    //     "vendor":"vivo",
    //     "model":"x27",
    //     "idfa":"",
    //     "imei":"xxxxxxxxxxxxxx",
    //     "androidid":"xxxxxxxxxxxxxxxx",
    //     "imsi":"13723456671",
    //     "mac":"00:03:5B:08:A6:16",
    //     "sw":375,
    //     "sh":667,
    //     "ppi":400,
    //     "ipv4":"xxx.xxx.xxx.xxx",
    //     "opert":1,
    //     "connt":1,
    //     "adw":580,
    //     "adh":90
    // }
    const md = new MobileDetect(window.navigator.userAgent);
    if (md.os() === 'iOS') {
        defaultConfig.ost = 2;
        defaultConfig.idfa = getUrl('idfa');
        defaultConfig.ppi = Math.min(window.devicePixelRatio, 3);
        defaultConfig.model = getUrl('model') || md.versionStr('Version');
        defaultConfig.osv = getUrl('osv') || md.version('Ios');
        // defaultConfig.idfa = '';
    } else {
        defaultConfig.ost = 1;
        defaultConfig.imei = getUrl('imei') || getUrl('deviceId')//getUrlParameter('deviceId');
        defaultConfig.ppi = 1;
        defaultConfig.model = getUrl('model') || md.versionStr('Build');
        defaultConfig.osv = getUrl('osv') || md.version('Android').toString();
        defaultConfig.androidid = getUrl('androidid') || '';
        defaultConfig.imsi = getUrl('imsi') || '';
    }
    defaultConfig.mac = getUrl('mac') || '02:00:00:00:00:00';
    defaultConfig.sw = document.body.clientWidth;
    defaultConfig.sh = document.body.clientHeight;
    defaultConfig.opert = getUrl('opert') || 0;
    defaultConfig.connt = getUrl('connt') || getNetworkType();
    defaultConfig.vendor = getUrl('vendor') || md.phone();
    defaultConfig.devt = 1;
    defaultConfig.bundle = /*getUrl('bundle') ||*/ "com.ttyouqu.app";//到时修改
    defaultConfig.appv = getUrl('appv');
    defaultConfig.adw = 580;
    defaultConfig.adh = 90;
    defaultConfig.ipv4 = getUrl('ipv4');
    defaultConfig.slotid = slotid || "1007" //需要修改
    return defaultConfig;
}