import { INetData } from "../../libs/tc/interface/INetData";
import { getDefaultConfig, replaceUrl, replaceMacro1, replaceMacro2 } from "./getDefaultConfig";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { a } from '../../libs/tc/index';

//事件，到时放到Event里,Event里的事件名也需要重理
export enum MediaEvent {

    // ENDED = "ended",
    // TIME_UPDATE = "timeupdate",//这三个基本内部用，是media上绑定的，先不放了
    // PLAY = "play",

    PLAY_START = "onPlayStart",
    PLAY_END = "onPlayEnd",
    PLAY_UPDATE = "onPlayUpdate",

}

/**
 * tuia消消乐
 * 获取武汉激励广告信息
 * @param callback 
 */
export function getWuhanAds(callback: Function, slotid: string): void {
    // var domain = window['development'] ? "182.92.53.46:8090"/*测试*/ : "39.97.201.131"; //正式
    const net: INetData = {
        name: "getWuhanAds",
        uri: "/customActivity/tuia/happyclear/getAds",
        type: 'post',
        dataType: 'json',
        param: JSON.stringify(getDefaultConfig(slotid)),
        callback: callback,
        hideMsg: true
    };
    NetManager.ins.send(net);
}

const reportGet = (e) => {
    const img = new Image();
    img.src = e;
};

interface Ad {
    "adw": number,
    "adh": number,
    macro: number //是否需要在终端做宏替换 0:不需要处理 1:需要处理，逻辑见下⽂，2: 需要处理，逻辑见下⽂ 
    shownotice: string[]
    clicknotice: string[]
    rewardvideo: {
        "video": string,
        "duration": number,
        "endcardhtml": string,//尾帧信息未处理
        "endcardimage": string,
        "endcardicon": string,
        "endcardtitle": string,
        "endcarddesc": string,
        "endcardshownotice": string[],
        "endcardclosenotice": string[],
        "playstart": string[],
        "firstquartile"?: string[],
        "midpoint"?: string[],
        "thirdquartile"?: string[],
        "playend": string[],
        "playclosemid": string[],
        "playagain": string[],
        "mute": string[],
    }
}

let videoIns: Video;

export function getVideoIns(ad: Ad) {
    if (videoIns) {
        videoIns.reset(ad);
        return videoIns
    } else {
        videoIns = new Video(ad)
        return videoIns
    }
}

class Video extends eui.Component/*egret.DisplayObjectContainer*/ {
    /**
     * 是否添加到舞台过
     */
    private _isAdded: boolean
    /**
     * html 标签 video
     * @property media
     * @type {Video}
     * @public
     * @since 1.0.0
     */
    public media: HTMLVideoElement = null;
    /**
     * @property isPlaying
     * @type {boolean}
     * @since 2.0.0
     * @default true
     */
    public isPlaying: boolean = true;
    /**
     * @property id
     * @type {string}
     */
    public id: string = "";
    private _loop: number = 1;

    public returnCallback: Function;

    public completeCallback: Function;

    private appUi: HTMLDivElement //eui.Image//egret.DisplayObjectContainer;

    macro: number;
    showReport: any;
    videoRaw: Ad;
    _responseTime: any;
    _readyTime: any;
    _showTime: any;
    appContent: {};
    isFirstClick: boolean;
    process25: boolean;
    process50: boolean;
    process75: boolean;
    process100: boolean;
    landpage: any;
    playReport: { playStart: any; playEnd: any; process25: any; process50: any; porcess75: any; playclosemid: any; };
    /**
     * 构造函数
     * @method Media
     * @param {string|HtmlElement} src
     * @since 1.0.0
     * @example 
     *      var media = new Video('http://test.annie2x.com/biglong/apiDemo/video.mp4', 'a1');
     *          media.play();//媒体播放
     *          //media.pause();//暂停播放
     *          //media.stop();//停止播放
     */
    constructor(ad: Ad) {
        super();
        this.videoRaw = ad;

        this.initUi();

        this.macro = ad.macro;
        this._responseTime = +new Date();
        this.initAppContent(this.videoRaw);
        this.initVideoPlayReport(this.videoRaw);
        //视频居中放置
        let s: Video = this;
        s.media = document.createElement(/*"VIDEO""Video"*/"video");
        s.media.src = ad.rewardvideo.video;
        s.media.addEventListener('ended', s._endEvent = function () {
            if (s._loop == -1) {
                s.play(0);
            } else {
                s._loop--;
                if (s._loop > 0) {
                    s.play(0, s._loop);
                } else {
                    s.stop();
                }
            }
            s.dispatchEvent(new egret.Event(MediaEvent.PLAY_END));
        });
        s.media.addEventListener("timeupdate", s._updateEvent = function (e) {
            s.dispatchEvent(new egret.Event(
                MediaEvent.PLAY_UPDATE,
                false,
                false,
                {
                    per: Math.floor(s.media.currentTime / s.videoRaw.rewardvideo.duration * 100),
                    currentTime: s.media.currentTime
                }
            ));
        });
        s.media.addEventListener("play", s._playEvent = function () {
            s.dispatchEvent(new egret.Event(MediaEvent.PLAY_START));
        });

        //标签处理
        s.media.setAttribute("playsinline", "true");
        s.media.setAttribute("webkit-playsinline", "true");
        s.media.setAttribute("x-webkit-airplay", "true");
        s.media.setAttribute("x5-video-player-fullscreen", "true");
        s.media.setAttribute("x5-video-player-type", "h5");
        s.media.poster = "";
        s.media.preload = "auto";
        s.media.controls = false;
        //置顶
        s.media.style.position = "absolute";
        s.media.style.zIndex = "999";
        //宽度
        s.media.style.width = "100%";
        // s.media.style.height = "450px";
        s.media.style.top = "50%";
        s.media.style.transform = "translateY(-50%)";

        // var w = this.videoRaw.adw;
        // var h = this.videoRaw.adh;
        // var cw = document.body.clientWidth;
        // var ch = document.body.clientHeight;
        // s.media.style.top = (ch - h / (w / cw)) / 2 + "px";
        //宽高怎么处理，看适配
        // if(width&&height){
        //     s.media.width = width;
        //     s.media.height = height;
        // }
        //显示
        s.addEventListener(egret.Event.ADDED_TO_STAGE, () => {
            if (!s._isAdded) {
                s._isAdded = true;
                document.body.appendChild(s.media)
                if (s.element1) document.body.appendChild(s.element1);
                if (s.appUi) document.body.appendChild(s.appUi);
            } else {
                if (s.media && s.visible) {
                    s.media.style.display = "block";
                }

                // if (s.appUi && s.visible) s.appUi.style.display = "block";
            }
            s.play()
        }, s)
        s.addEventListener(egret.Event.REMOVED_FROM_STAGE, () => {
            s.media.pause();
            if (s.media) {
                s.media.style.display = "none";
            }
            if (s.element1) s.element1.style.display = "none";
            if (s.appUi) s.appUi.style.display = "none";
        }, s)

        s.initListener();
    }
    /**
     * 
     */
    public reset(ad: Ad) {
        // 响应完成时间
        this._responseTime = null;
        // 素材load时间
        this._readyTime = null;
        // 展示时间
        this._showTime = null;
        // 曝光地址
        this.showReport = [];
        // 下载包名信息
        this.appContent = {};
        // 第一次点击
        this.isFirstClick = true;
        // 播放 25%;
        this.process25 = false;
        // 播放 50%;
        this.process50 = false;
        // 播放 75%;
        this.process75 = false;
        // 播放 100%;
        this.process100 = false;

        this.landpage = null;

        this.returnCallback = null;
        this.completeCallback = null;

        //显示视频页
        this.element1.style.display = "block";
        //隐藏
        this.appUi.style.display = "none";

        this.macro = ad.macro;
        this._responseTime = +new Date();
        this.videoRaw = ad;
        this.initAppContent(this.videoRaw);
        this.initVideoPlayReport(this.videoRaw);

        //视频修改
        this.media.style.display = "block";
        this.media.src = ad.rewardvideo.video;
        // var w = this.videoRaw.adw;
        // var h = this.videoRaw.adh;
        // var cw = document.body.clientWidth;
        // var ch = document.body.clientHeight;
        // this.media.style.top = (ch - h / (w / cw)) / 2 + "px";
        this.play();
        this.volume = 1;
        this.volumeBtn.src = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/voice.png"
    }
    private element1: HTMLDivElement;
    private volumeBtn: HTMLImageElement
    private initUi() {
        //ui放置，背景图按钮文案等
        //黑色背景
        var bg = new egret.Shape();
        bg.graphics.beginFill(0x000000, 1);
        bg.graphics.drawRect(0, 0, 750, 1624);
        bg.graphics.endFill();
        bg.touchEnabled = true;
        this.addChild(bg);
        //关闭按钮，作用关闭自己，且回调
        // var closeBtn = new CusButton("videoCloseBtn_png");
        // closeBtn.x = 680;
        // closeBtn.y = 100;
        // this.addChild(closeBtn);
        // closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
        //     if (this.parent) this.parent.removeChild(this);
        //     //关闭上报,
        //     if (!this.process100) {
        //         //中途关闭
        //         this.playReport.playclosemid.forEach(e => {
        //             reportGet(e);
        //         });
        //         this.returnCallback && this.returnCallback(false);
        //     }
        //     //观看完成回调
        //     else {
        //         this.returnCallback && this.returnCallback(true);
        //     }
        // }, this)
        //静音按钮
        // var volumeBtn = new CusButton("volumeBtn_png");
        // volumeBtn.x = 80;
        // volumeBtn.y = 100;
        // this.addChild(volumeBtn);
        // volumeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, (e: egret.TouchEvent) => {
        //     if (this.volume) {
        //         this.volume = 0;
        //     } else {
        //         this.volume = 1;
        //     }

        // }, this)
        //下载按钮
        // var downloadBtn = new CusButton("downloadBtn_png");
        // downloadBtn.x = 375;
        // var stageHeight = document.body.clientHeight / document.body.clientWidth * 750;
        // downloadBtn.y = stageHeight - 100;
        // this.addChild(downloadBtn);
        // //如果执行了，可能就跳转了，所以就一次吧
        // downloadBtn.once(egret.TouchEvent.TOUCH_TAP, (e) => {
        //     this.reportClick({
        //         screenX: e.stageX * document.body.clientWidth / this.stage.stageWidth,
        //         screenY: e.stageY * document.body.clientHeight / this.stage.stageHeight,
        //     });
        // }, this)

        //播放时的ui
        var element1: HTMLDivElement = document.createElement("div");
        element1.style.margin = "auto";
        element1.style.width = "100%";
        element1.style.height = "100%";
        element1.style.overflow = "hidden";
        element1.style.position = "absolute";
        //静音按钮
        var volumeBtn = new Image()
        volumeBtn.src = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/voice.png";
        volumeBtn.style.position = "absolute";
        volumeBtn.style.right = "10px"
        volumeBtn.style.top = "50%"
        volumeBtn.style.transform = "translateY(-50%)";
        volumeBtn.style.width = "10vw"
        volumeBtn.style.height = "10vw";
        volumeBtn.style.zIndex = "9999"
        element1.appendChild(volumeBtn)
        volumeBtn.addEventListener("click", (e) => {
            if (this.volume) {
                this.volume = 0;
                this.volumeBtn.src = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/muted.png"
            } else {
                this.volume = 1;
                this.volumeBtn.src = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/voice.png"
            }
        })
        this.volumeBtn = volumeBtn;

        //关闭按钮
        var closeBtn = new Image()
        closeBtn.src = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/videoCloseBtn.png";
        closeBtn.style.position = "absolute";
        closeBtn.style.top = "10vw";
        closeBtn.style.right = "10px";
        closeBtn.style.width = "10vw";
        closeBtn.style.height = "10vw"
        closeBtn.style.zIndex = "9999"
        element1.appendChild(closeBtn)
        closeBtn.addEventListener("click", (e) => {
            this.closeEvent();
        })

        //下载按钮
        var downloadBtn = new CusButton("downloadBtn_png");
        downloadBtn.x = 375;
        var stageHeight = document.body.clientHeight / document.body.clientWidth * 750;
        downloadBtn.y = stageHeight - 100;
        this.addChild(downloadBtn);
        //如果执行了，可能就跳转了，所以就一次吧
        downloadBtn.once(egret.TouchEvent.TOUCH_TAP, (e) => {
            this.reportClick({
                screenX: e.stageX * document.body.clientWidth / this.stage.stageWidth,
                screenY: e.stageY * document.body.clientHeight / this.stage.stageHeight,
            });
        }, this)

        //appUi
        var downloadBtn = new Image()
        downloadBtn.src = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/downloadBtn.png";
        downloadBtn.style.position = "absolute";
        downloadBtn.style.margin = "0 auto";
        downloadBtn.style.bottom = "10px";
        downloadBtn.style.zIndex = "9999";
        downloadBtn.style.width = "50vw";
        downloadBtn.style.left = "50%"
        downloadBtn.style.transform = "translateX(-50%)"
        element1.appendChild(downloadBtn)
        downloadBtn.addEventListener("click", (e) => {
            this.downloadEvent(e);
        })
        this.element1 = element1;
        this.element1.style.display = "block";


        //appUi,待修改
        this.appUi = document.createElement('div');
        this.appUi.style.display = "none";
    }
    private initAppUi(content: { appIcon: String, name: String, slogen: String }) {
        const { appIcon, name, slogen } = content;
        this.appUi.innerHTML = `
            <div class="video-land-page-content">
                <img class="app-close"
                    src="data:image/png;base64,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">
                </img>
                <div class="app-info-wrap">
                    <div class="app-logo" style="backgroundImage:url(${appIcon})"></div>
                    <div class="app-name">${name}</div>
                    <div class="app-button">${slogen}</div>
                </div>
            </div>
        `;
        document.body.appendChild(this.appUi);
        this.appUiEvent();
    }
    private appUiEvent() {
        let appUiChild = document.querySelector('.video-land-page-content');
        let appClose = document.querySelector('.app-close');
        let appButton = document.querySelector('.app-button');
        appUiChild.addEventListener('click', (e) => {
            if (e.target === appClose) {
                this.appUi.style.display = "none";
            } else if (e.target === appButton) {
                console.log('点击事件');
            }
        })
    }
    //初始化监听，只执行一次
    private initListener() {
        //监听开始播放
        this.addEventListener(MediaEvent.PLAY_START, () => {
            this._readyTime = +new Date();
            if (this.media.currentTime === 0) {
                this._showTime = +new Date();
                this.initShowReport();
                this.reportShow();
                // console.log(this.playReport);
                if (this.playReport["playStart"]) {
                    this.playReport["playStart"].forEach(e => {
                        reportGet(e);
                    });
                };
            }
        }, this);

        //视频播放时间上报
        this.addEventListener(MediaEvent.PLAY_UPDATE, (e: egret.Event) => {
            if (e.data.per > 25 && this.playReport["process25"] && !this.process25) {
                this.playReport["process25"].forEach(e => {
                    reportGet(e);
                });
                this.process25 = true;
            };
            if (e.data.per > 50 && this.playReport["process50"] && !this.process50) {
                this.playReport["process50"].forEach(e => {
                    reportGet(e);
                });
                this.process50 = true;
            }
            if (e.data.per > 75 && this.playReport["process75"] && !this.process75) {
                this.playReport["process75"].forEach(e => {
                    reportGet(e);
                });
                this.process75 = true;
            }
            if (e.data.per >= 100 && !this.process100) {
                this.process100 = true;
            }
        }, this);
        //播放结束时上报
        this.addEventListener(MediaEvent.PLAY_END, () => {
            this.playReport["playEnd"].forEach(e => {
                reportGet(e);
            });
            // this.playResolve();
            //放置图片
            this.appUi.style.display = "block";
            // this.media.style.display = "none";
        }, this);
        // this.player.on('$videoClose', () => {
        //     this.hide();
        // });
    }

    // 初始化曝光上报
    private initShowReport() {
        if (this.macro === 0 || this.macro === 1) {
            this.showReport = this.videoRaw["shownotice"] || [];
        } else if (this.macro === 2) {
            this.showReport = (this.videoRaw["shownotice"] || []).map(e => {
                return replaceUrl(e, {
                    __RESPONSE_TIME__: this._responseTime,
                    ____READY_TIME__: this._readyTime,
                    __SHOW_TIME__: this._showTime,
                    __WIDTH__: document.body.clientWidth,
                    __HEIGHT__: document.body.clientHeight
                });
            });
        }
    }

    // 曝光上报
    private reportShow() {
        this.showReport.forEach(e => {
            reportGet(e);
        });
    }

    //点击下载曝光
    async reportClick(event) {
        if (this.macro === 0) {
            (this.videoRaw["clicknotice"] || []).forEach(e => {
                reportGet(e);
            });
            this.landpage = this.videoRaw["landingpage"];
        } else if (this.macro === 1) {
            const clicknotice = (this.videoRaw["clicknotice"] || []).map(e => {
                return replaceMacro1(e, event);
            });
            this.landpage = replaceMacro1(this.videoRaw["landingpage"], event);
            clicknotice.forEach(e => {
                reportGet(e);
            });
            //
        } else if (this.macro === 2) {
            this.landpage = replaceMacro2(this.videoRaw["landingpage"], event, {
                responseTime: this._responseTime + "",
                readyTime: this._readyTime + "",
                clickTime: +new Date() + "",
                showTime: this._showTime,
            });
            const clicknotice = (this.videoRaw["clicknotice"] || []).map(e => {
                return replaceMacro2(e, event, {
                    responseTime: this._responseTime + "",
                    readyTime: this._readyTime + "",
                    clickTime: +new Date() + "",
                    showTime: this._showTime
                });
            });
            clicknotice.forEach(e => {
                reportGet(e);
            });
        }
        console.log(this.landpage);
        //如果观看完成了，先发奖励再跳转
        if (this.process100) {
            this.completeCallback && this.completeCallback();
            setTimeout(() => {
                this.linkToThird(this.landpage);
            }, 1000)
        } else {
            // 跳转链接;
            this.linkToThird(this.landpage);
        }
    };

    //初始化播放上报
    private initVideoPlayReport(ad: Ad) {
        const v = ad.rewardvideo;
        this.playReport = {
            playStart: v.playstart || [],
            playEnd: v.playend || [],
            process25: v.firstquartile || [],
            process50: v.midpoint || [],
            porcess75: v.thirdquartile || [],
            playclosemid: v.playclosemid || [],
        };
    }

    // 跳转三方链接
    private linkToThird(url) {
        // window.location.href = url;
        window["helpbridge"].jumpToOtherWeb(url)
    };


    initAppContent(ad: Ad) {
        const v = ad.rewardvideo;
        console.log('iconicon', v.endcardicon);
        if (!v.endcardicon) {
            this.appContent = null;
            return;
        }
        this.appContent = {
            appIcon: v.endcardicon || '',
            name: v.endcardtitle || '',
            slogen: v.endcarddesc || ''
        };
        this.initAppUi({ appIcon: 'aaaa', name: 'bbbb', slogen: 'ccccc' });
    }

    /**
     * 关闭事件
     */
    private closeEvent() {
        if (this.parent) this.parent.removeChild(this);
        //关闭上报,
        if (!this.process100) {
            //中途关闭
            this.playReport.playclosemid.forEach(e => {
                reportGet(e);
            });
            this.returnCallback && this.returnCallback(false);
        }
        //观看完成回调
        else {
            this.returnCallback && this.returnCallback(true);
        }
    }

    /**
     * 下载事件
     * @param e 
     */
    private downloadEvent(e) {
        // this.reportClick({
        //     screenX: e.stageX * document.body.clientWidth / this.stage.stageWidth,
        //     screenY: e.stageY * document.body.clientHeight / this.stage.stageHeight,
        // });
        this.reportClick(e);
    }




    //这三个事件在media上，为了引用出来移除监听
    private _playEvent: any;
    private _updateEvent: any;
    private _endEvent: any;
    /**
     * @property _repeate
     * @type {number}
     * @private
     * @default 1
     */
    private _repeate: number = 1;
    /**
     * 开始播放媒体
     * @method play
     * @param {number} start 开始点 默认为0
     * @param {number} loop 循环次数 默认为1
     * @public
     * @since 1.0.0
     */
    public play(start: number = 0, loop: number = 1): void {
        let s = this;
        if (loop == 0) {
            s._loop = s._repeate;
        } else {
            s._loop = loop;
            s._repeate = loop;
        }
        if (s.media.currentTime != start) {
            s.media.currentTime = start;
        }
        s.media.play();
        s.isPlaying = true;
    }

    /**
     * 停止播放
     * @method stop
     * @public
     * @since 1.0.0
     */
    public stop(): void {
        let s = this;
        s.media.pause();
        s.media.currentTime = 0;
        s.isPlaying = false;
    }

    /**
     * 暂停播放,或者恢复播放
     * @method pause
     * @public
     * @param isPause  默认为true;是否要暂停，如果要暂停，则暂停；否则则播放
     * @since 1.0.4
     */
    public pause(isPause: boolean = true): void {
        let s = this;
        if (isPause) {
            s.media.pause();
            s.isPlaying = false;
        } else {
            s.media.play();
            s.isPlaying = true;
        }
    }
    /**
     * 设置或者获取音量 从0-1
     * @since 1.1.0
     * @property volume
     * @return {number}
     */
    public get volume(): number {
        return this.media.volume
    }

    public set volume(value: number) {
        let s = this;
        s.media.volume = value;
        if (value == 0) {
            s.media.muted = true;
        } else {
            s.media.muted = false;
        }
    }

    public destroy() {
        this.media.pause();
        this.media.removeAttribute('src');
        this.media.removeEventListener("ended", this._endEvent);
        this.media.removeEventListener("onPlayStart", this._playEvent);
        this.media.removeEventListener("timeupdate", this._updateEvent);
        this.media.remove()
        this.media = null;
    }
}


class CusButton extends eui.Component {
    constructor(source: string) {
        super();
        this.touchChildren = false;
        var texture: egret.Texture = RES.getRes(source)
        var image = new eui.Image(texture);
        image.x = -texture.textureWidth / 2;
        image.y = -texture.textureHeight / 2;
        this.addChild(image);
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, () => {
            egret.Tween.removeTweens(this);
            egret.Tween.get(this).to({ scaleX: 0.9, scaleY: 0.9 }, 50);
        }, this)
        this.addEventListener(egret.TouchEvent.TOUCH_END, () => {
            egret.Tween.removeTweens(this);
            egret.Tween.get(this).to({ scaleX: 1, scaleY: 1 }, 50);
        }, this)
        this.addEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, () => {
            egret.Tween.removeTweens(this);
            egret.Tween.get(this).to({ scaleX: 1, scaleY: 1 }, 50);
        }, this)
    }
}

//播放时的ui
var element1: HTMLDivElement = document.createElement("div");
element1.style.margin = "auto";
element1.style.width = "100%";
element1.style.height = "100%";
element1.style.overflow = "hidden";
element1.style.position = "absolute";
//静音按钮
var volumeBtn: HTMLDivElement = document.createElement("div");
volumeBtn.style.backgroundImage = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/volumeBtn.png";
volumeBtn.style.position = "absolute";
volumeBtn.style.right = "10px"
volumeBtn.style.top = "10px"
volumeBtn.style.transform = "translateY(-50%)";
element1.appendChild(volumeBtn)

//关闭按钮
var closeBtn: HTMLDivElement = document.createElement("div");
closeBtn.style.backgroundImage = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/volumeBtn.png";
closeBtn.style.position = "absolute";
closeBtn.style.top = "10px";
closeBtn.style.right = "10px";
element1.appendChild(closeBtn)

//下载按钮
var downloadBtn: HTMLDivElement = document.createElement("div");
downloadBtn.style.backgroundImage = "https://yun.duiba.com.cn/db_games/activity/xiaoxiaoleTuia/cssImage/downloadBtn.png";
downloadBtn.style.position = "absolute";
downloadBtn.style.margin = "0 auto";
downloadBtn.style.bottom = "10px";
element1.appendChild(downloadBtn)