import ComponentBase from "../../libs/new_wx/components/ComponentBase";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { getlogItem } from "../Main";
import wait from "../../libs/new_tc/wait";

export default class AdSmallComp extends ComponentBase {

    start(data?) {
        this.visible=false;
        let result;
        // this.touchEnabled = this.touchChildren = false;
        super.start(data);
        NetManager.ins.hc_advert(() => {
            const { data } = DataManager.ins.getData('hc_advert');
            let {  popupAdvert } = data;
            if (popupAdvert == null)
                popupAdvert = { enable: false, advertList: [] }
            this.visible = popupAdvert.enable;
            if (popupAdvert.enable) {
                result = popupAdvert.advertList;
                if (Array.isArray(popupAdvert.advertList)) {
                    const index = Math.floor(popupAdvert.advertList.length * Math.random());
                    result = popupAdvert.advertList[index];
                }
                this.data.img = result.img;
            }
        });

        this['img'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            if(data.logid)
                NetManager.ins.clickLog(getlogItem(data.logid));
            wait(50).then(()=>{
                window.location.href = result.url;
            });
        }, this);
    }

    get skinKey(): string { return 'ADSmall' }
}