import { IDynamicData } from "../../tw/data/game/datapash/IDynamicData";
import { NetManager } from "../../tw/manager/NetManager";
import { DataManager } from "../../tw/manager/DataManager";
import { NetName } from "../../tw/enum/NetName";

/**
 * 提交游戏成绩
 * @param callback 
 * @param score 得分
 * @param checkScore  是否校验得分
 * @param customizedType 定制类型 1推币机    
 */
const submit = (callback: Function, score: number, checkScore?: boolean, customizedType?: number) => {
    const allDynamics = [];
    gameSubmitData(callback, score, allDynamics, checkScore, customizedType);
}

/**
* 提交游戏成绩
* @param callback 
* @param score 得分
* @param allDynamics 防作弊数据
* @param checkScore  是否校验得分
* @param customizedType 定制类型 1推币机    
*/
const gameSubmitData = (callback: Function, score: number, allDynamics: IDynamicData[][], checkScore?: boolean, customizedType?: number) => {
    NetManager.ins.ngameSubmit(
        (success: boolean) => {
            if (success) {
                getOrderStatus(callback, DataManager.ins.getData('dojoin').data);
            } else {
                callback(success);
            }
        },
        DataManager.ins.getData('dojoin').data,
        score,
        '[]',
        '[]',
        DataManager.ins.getData('getNgameStartStatus').data.submitToken,
        window['rankId']);
}

/**
 * 查询提交结果
 * @param callback 
 * @param orderId 
 */
const getOrderStatus = (callback: Function, orderId: number) => {
    NetManager.ins.getPlugOrderStatus(() => { }, orderId,
        () => { DataManager.ins.getData(NetName.PLUG_ORDER_STATUS).result == 0 });
    // NetManager.ins.getOrderStatus(callback, orderId, () => {
    //     return DataManager.ins.getCustomOrderStatusData.code == 'C000000001';
    // });
}

export default submit;