import * as FYGE from "fyge-tbmini";
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/Main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./module/RES.ts":
/*!***********************!*\
  !*** ./module/RES.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RES;
(function (RES) {
    var resData;
    var videoEntityHash = {};
    var soundHash = {};
    var groupsCompleteHash = {};
    var groupsPromiseHash = {};
    var singleResPromiseHash = {};
    function loadConfig(res) {
        resData = res;
        RES.resPath = res.path;
    }
    RES.loadConfig = loadConfig;
    function loadGroup(name) {
        if (groupsCompleteHash[name]) {
            return new Promise(function (resolve) {
                resolve();
            });
        }
        if (groupsPromiseHash[name]) {
            return groupsPromiseHash[name];
        }
        var arr = getGroupResByName(name);
        if (!arr || !arr.length) {
            groupsCompleteHash[name] = true;
            return new Promise(function (resolve) {
                resolve();
            });
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                delete groupsPromiseHash[name];
                if (s) {
                    groupsCompleteHash[name] = true;
                    resolve();
                }
                else {
                    reject();
                }
            }, arr);
        });
        groupsPromiseHash[name] = p;
        return p;
    }
    RES.loadGroup = loadGroup;
    function getResAsync(str, comFun, thisObj) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            if (FYGE.TextureCache[str]) {
                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                new Promise(function (r) {
                    r(FYGE.TextureCache[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                if (groupName && type != "jpg") {
                    var group = getGroupByName(groupName);
                    if (group && group.atlas) {
                        var json = groupName + ".json";
                        if (singleResPromiseHash[json]) {
                            return singleResPromiseHash[json].then(function (r) {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                        else {
                            return getResAsync(json)
                                .then(function () {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                    }
                }
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadImage(function (s, image) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            FYGE.Texture.addToCache(FYGE.Texture.from(image), str);
                            comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                            resolve(FYGE.TextureCache[str]);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "svga") {
            if (videoEntityHash[str]) {
                comFun && comFun.call(thisObj, videoEntityHash[str], str);
                return new Promise(function (r) {
                    r(videoEntityHash[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadSvga(function (s, v) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            if (s)
                                videoEntityHash[str] = v;
                            comFun && comFun.call(thisObj, v, str);
                            resolve(v);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "json") {
            if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    var jsonData = getGroupByName(groupName).atlas;
                    FYGE.GlobalLoader.loadImage(function (s, data) {
                        if (s) {
                            var t = FYGE.createTextureSheet(new FYGE.BaseTexture(data), jsonData);
                            comFun && comFun.call(thisObj, t, str);
                            resolve(t);
                        }
                        else {
                            delete singleResPromiseHash[str];
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src.replace("json", "png"));
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
    }
    RES.getResAsync = getResAsync;
    function getResByUrl() {
    }
    RES.getResByUrl = getResByUrl;
    function getRes(str) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            return FYGE.TextureCache[str] || null;
        }
        else if (type == "svga") {
            return videoEntityHash[str] || null;
        }
        else if (type == "mp3") {
            return soundHash[str] || null;
        }
    }
    RES.getRes = getRes;
    function hasRes(str) {
        for (var i = 0; i < resData.groups.length; i++) {
            var group = resData.groups[i];
            var keys = group.keys;
            if (keys && keys.split(",").indexOf(str) > -1) {
                return group.name;
            }
            if (group.atlas && group.name + ".json" == str) {
                return group.name;
            }
        }
        return null;
    }
    function getGroupResByName(name) {
        var group = getGroupByName(name);
        if (!group)
            return null;
        if (group.atlas) {
            var arr = [name + ".json"];
            if (group.keys) {
                arr = arr.concat(group.keys.split(",").filter(function (k) {
                    return k.substr(-4) != ".png";
                }));
            }
            return arr;
        }
        else if (group.keys) {
            return group.keys.split(",");
        }
        else {
            return null;
        }
    }
    function getGroupByName(name) {
        var groups = resData.groups;
        var group;
        for (var i = 0; i < groups.length; i++) {
            if (groups[i].name === name) {
                group = groups[i];
                break;
            }
        }
        return group;
    }
    function loadResList(callback, arr) {
        var count = 0;
        var countAll = arr.length;
        if (!countAll)
            callback(true);
        var mark = true;
        for (var i = 0; i < countAll; i++) {
            var resName = arr[i];
            getResAsync(resName, function (res, str) {
                if (!res)
                    mark = false;
                if (++count == countAll)
                    callback(mark);
            }, this);
        }
    }
    function returnSingleResPromise(str, comFun, thisObj) {
        singleResPromiseHash[str].then(function (r) {
            comFun && comFun.call(thisObj, r, str);
        }, function () {
            comFun && comFun.call(thisObj, null, str);
        });
        return singleResPromiseHash[str];
    }
    function destroyRES() {
    }
})(RES = exports.RES || (exports.RES = {}));


/***/ }),

/***/ "./module/ctrls/index.ts":
/*!*******************************!*\
  !*** ./module/ctrls/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var panelCtrl_1 = __webpack_require__(/*! ./panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ./sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var toastCtrl_2 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
exports.showToast = toastCtrl_2.showToast;
__export(__webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts"));
exports.showPanel = function (panel, data) {
    panelCtrl_1.default.instance.show(panel, data);
};
exports.closeAllPanels = function () {
    panelCtrl_1.default.instance.closeAll();
};
exports.closeCurrentPanel = function () {
    panelCtrl_1.default.instance.closeCurrent();
};
exports.changeScene = function (scene, data) {
    sceneCtrl_1.default.instance.change(scene, data);
};
function getCurrentScene() {
    return sceneCtrl_1.default.instance.currentScene;
}
exports.getCurrentScene = getCurrentScene;
exports.showAlert = function (title, content) {
    if (my) {
        my.alert({
            title: title || "",
            content: content || ""
        });
    }
    else {
        console.log(title, content);
    }
};
function wait(callback, time) {
    var obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback);
    return obj;
}
exports.wait = wait;
function clearWait(obj) {
    FYGE.Tween.removeTweens(obj);
}
exports.clearWait = clearWait;
function destroyAllCtrls() {
    toastCtrl_1.destroyToast();
    waitingCtrl_1.destroyWaiting();
    panelCtrl_1.default.instance.destroy();
    sceneCtrl_1.default.instance.destroy();
}
exports.destroyAllCtrls = destroyAllCtrls;


/***/ }),

/***/ "./module/ctrls/panelCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/panelCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.stacks = [];
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
        var bg = new FYGE.Graphics();
        bg.beginFill(0, 1);
        bg.drawRect(layers_1.layers.stageOffsetX - parent.x, layers_1.layers.stageOffsetY - parent.y, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        bg.endFill();
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    };
    PanelCtrl.prototype.closeAll = function () {
        this.stacks.forEach(function (e) { return e.hidePanel(); });
    };
    PanelCtrl.prototype.show = function (cls, data) {
        var _this = this;
        waitingCtrl_1.showWaiting();
        var panel = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            _this.updateView();
            panel.start(data);
        };
        panel.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            panel.removeEventListener('onDestroy', _this.onPanelHide, _this);
            _this.remove(panel);
        };
        return panel;
    };
    PanelCtrl.prototype.updateView = function () {
        var _this = this;
        if (!this.stacks.length) {
            if (this._bg.visible) {
                this.bgAni = "hide";
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(function () {
                    _this._bg.visible = false;
                    _this._current = null;
                    _this._parent.visible = false;
                });
            }
        }
        else {
            this._parent.visible = true;
            if (this.bgAni == "hide") {
                this.bgAni = "show";
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut);
            }
        }
        for (var i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            }
            else {
                this.stacks[i].visible = true;
                this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(function (e) { return e != panel; });
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current) {
            this._current.hidePanel();
        }
    };
    PanelCtrl.prototype.destroy = function () {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        this._bg = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;


/***/ }),

/***/ "./module/ctrls/sceneCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/sceneCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (cls, data) {
        var _this = this;
        if (this._currentScene && this._currentScene instanceof cls)
            return;
        var scene = new cls(data);
        scene.visible = false;
        waitingCtrl_1.showWaiting();
        var preScene = this._currentScene;
        scene.onLoaded = function () {
            console.log(1231666);
            waitingCtrl_1.hideWaiting();
            scene.showAni(function () {
                if (preScene)
                    preScene.destroy();
            });
            scene.visible = true;
            scene.start();
        };
        scene.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            _this._currentScene = preScene || null;
            _this._parent.removeChild(scene);
        };
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    Object.defineProperty(SceneCtrl.prototype, "currentScene", {
        get: function () {
            return this._currentScene;
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.destroy = function () {
        SceneCtrl._instance = null;
        this._currentScene = null;
        this._parent = null;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;


/***/ }),

/***/ "./module/ctrls/toastCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/toastCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var inited = false;
var _toast;
var _parent;
var startY;
var endY;
var initToast = function () {
    if (!inited) {
        inited = true;
        _toast = new Toast();
        _parent = layers_1.layers.toastLayer;
        _toast.alpha = 0;
        _toast.x = layers_1.layers.stageOffsetX - _parent.x + (layers_1.layers.stageWidth - _toast.width) / 2;
        var h = _toast.height;
        var y = layers_1.layers.stageOffsetY - _parent.y;
        startY = y - h;
        endY = y + (layers_1.layers.stageHeight - h) / 2;
    }
};
exports.showToast = function (msg) {
    initToast();
    _toast.show(msg);
    _parent.addChild(_toast);
    FYGE.Tween.removeTweens(_toast);
    FYGE.Tween.get(_toast)
        .set({ y: startY, alpha: 1 })
        .to({ y: endY }, 500, FYGE.Ease.quartOut)
        .wait(800)
        .to({ alpha: 0 }, 300)
        .call(function () {
        _parent.removeChild(_toast);
    });
};
exports.destroyToast = function () {
    if (inited && _toast && !_toast.destroyed) {
        _toast.destroy();
        _toast = null;
        _parent = null;
        inited = false;
    }
};
var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super.call(this) || this;
        _this.PADDING = 40;
        _this.mouseChildren = false;
        _this.mouseEnable = false;
        var toastBgTexture = RES_1.RES.getRes("toastBg.png");
        _this.bg = new FYGE.Sprite(toastBgTexture);
        _this.addChild(_this.bg);
        _this.msg = new FYGE.TextField();
        _this.msg.size = 28;
        _this.msg.fillColor = "0xffffff";
        _this.msg.text = "";
        _this.msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this.msg.textHeight = toastBgTexture.height;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.addChild(_this.msg);
        return _this;
    }
    Toast.prototype.show = function (msg) {
        this.msg.text = msg;
        this.msg.x = (this.bg.width - this.msg.textWidth) / 2;
    };
    Toast.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
        this.bg = null;
    };
    return Toast;
}(FYGE.Container));


/***/ }),

/***/ "./module/ctrls/waitingCtrl.ts":
/*!*************************************!*\
  !*** ./module/ctrls/waitingCtrl.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var inited = false;
var _waiting;
var _parent;
var initWaiting = function () {
    if (!inited) {
        inited = true;
        var waiting = new Waiting();
        _parent = layers_1.layers.topLayer;
        _waiting = waiting;
        var offX = (layers_1.layers.stageWidth - 160) / 2;
        var offY = (layers_1.layers.stageHeight - _waiting.height) / 2;
        _waiting.x = layers_1.layers.stageOffsetX - _parent.x + offX;
        _waiting.y = layers_1.layers.stageOffsetY - _parent.y + offY;
        var bg = new FYGE.Graphics()
            .beginFill(0x000000)
            .drawRect(-offX, -offY, layers_1.layers.stageWidth, layers_1.layers.stageHeight)
            .endFill();
        bg.alpha = 0;
        _waiting.addChildAt(bg, 0);
    }
};
exports.showWaiting = function (msg) {
    initWaiting();
    _waiting.show(msg);
    _parent.addChild(_waiting);
};
exports.hideWaiting = function () {
    _parent.removeChild(_waiting);
};
exports.destroyWaiting = function () {
    if (inited && _waiting && !_waiting.destroyed) {
        _waiting.destroy();
        _waiting = null;
        _parent = null;
        inited = false;
    }
};
var Waiting = (function (_super) {
    __extends(Waiting, _super);
    function Waiting() {
        var _this = _super.call(this) || this;
        var rectBgTexture = RES_1.RES.getRes("waitingBg.png");
        var rectBg = new FYGE.Sprite(rectBgTexture);
        _this.addChild(rectBg);
        var rotTexture = RES_1.RES.getRes("waitingRot.png");
        var rot = new FYGE.Sprite(rotTexture);
        rot.x = (rectBgTexture.width - rotTexture.width) / 2;
        rot.y = 47;
        rot.anchorX = rotTexture.width / 2;
        rot.anchorY = rotTexture.height / 2;
        _this.addChild(rot);
        var count = 0;
        rot.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            count++;
            if (count % 30 == 0)
                rot.rotation += 45;
        }, _this);
        _this.msg = new FYGE.TextField();
        _this.msg.y = 125;
        _this.msg.textWidth = rectBgTexture.width;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.msg.size = 26;
        _this.msg.fillColor = "#ffffff";
        _this.addChild(_this.msg);
        return _this;
    }
    Waiting.prototype.show = function (msg) {
        if (msg === void 0) { msg = "加载中"; }
        this.msg.text = msg;
    };
    Waiting.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
    };
    return Waiting;
}(FYGE.Container));


/***/ }),

/***/ "./module/views/Module.ts":
/*!********************************!*\
  !*** ./module/views/Module.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var Module = (function (_super) {
    __extends(Module, _super);
    function Module(data) {
        var _this = _super.call(this) || this;
        _this.data = data;
        _this.init();
        return _this;
    }
    Module.prototype.init = function () {
        var _this = this;
        this.preLoadRes().then(function () {
            _this.initUi();
            _this.onLoaded && _this.onLoaded();
        }, function () {
            _this.onLoadError && _this.onLoadError();
        });
    };
    Module.prototype.preLoadRes = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.groupNames && _this.groupNames.length) {
                var arr = [];
                for (var i = 0; i < _this.groupNames.length; i++) {
                    arr.push(RES_1.RES.loadGroup(_this.groupNames[i]));
                }
                Promise.all(arr).then(resolve, reject);
            }
            else {
                resolve();
            }
        });
    };
    Module.prototype.initUi = function () {
    };
    Object.defineProperty(Module.prototype, "groupNames", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    Module.prototype.start = function (data) {
        this.initEvents();
    };
    Module.prototype.initEvents = function () {
    };
    Module.prototype.removeEvents = function () {
    };
    Module.prototype.enableMouseEvt = function (enable) {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    };
    Module.prototype.destroy = function () {
        this.data = null;
        this.removeEvents();
        this.dispatchEvent("onDestroy");
        _super.prototype.destroy.call(this);
    };
    return Module;
}(FYGE.Container));
exports.Module = Module;


/***/ }),

/***/ "./module/views/Panel.ts":
/*!*******************************!*\
  !*** ./module/views/Panel.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Panel = (function (_super) {
    __extends(Panel, _super);
    function Panel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Panel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        var oriY = this.y || 0;
        this.y = -200;
        FYGE.Tween.get(this)
            .to({ y: oriY }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) { if (btn)
            btn.addEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this); });
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) { if (btn)
            btn.removeEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this); });
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () { return [this['closeBtn']]; },
        enumerable: true,
        configurable: true
    });
    Panel.prototype.hidePanel = function () {
        this.destroy();
    };
    return Panel;
}(Module_1.Module));
exports.Panel = Panel;


/***/ }),

/***/ "./module/views/Scene.ts":
/*!*******************************!*\
  !*** ./module/views/Scene.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Scene = (function (_super) {
    __extends(Scene, _super);
    function Scene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene.prototype.showAni = function (callback) {
        callback();
    };
    Scene.prototype.updateScene = function () {
    };
    return Scene;
}(Module_1.Module));
exports.Scene = Scene;


/***/ }),

/***/ "./module/views/layers.ts":
/*!********************************!*\
  !*** ./module/views/layers.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var panelCtrl_1 = __webpack_require__(/*! ../ctrls/panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ../ctrls/sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var Layers = (function (_super) {
    __extends(Layers, _super);
    function Layers() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Layers.prototype.init = function (stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new FYGE.Container();
            this.addChild(this[arr[i]]);
        }
        this._sceneLayer.y = this.stageOffsetY;
        sceneCtrl_1.default.instance.init(this.sceneLayer);
        panelCtrl_1.default.instance.init(this.popupLayer);
    };
    Object.defineProperty(Layers.prototype, "bottomLayer", {
        get: function () { return this._bottomLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "sceneLayer", {
        get: function () { return this._sceneLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "popupLayer", {
        get: function () { return this._popupLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "toastLayer", {
        get: function () { return this._toastLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "topLayer", {
        get: function () { return this._topLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "shareLayer", {
        get: function () { return this._shareLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageHeight", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageWidth", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetX", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.x;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetY", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.y;
        },
        enumerable: true,
        configurable: true
    });
    return Layers;
}(FYGE.Container));
exports.layers = new Layers();
function destroyLayers() {
    exports.layers.removeChildren();
    if (exports.layers.parent)
        exports.layers.parent.removeChild(exports.layers);
}
exports.destroyLayers = destroyLayers;


/***/ }),

/***/ "./src/Component/MEvent.ts":
/*!*********************************!*\
  !*** ./src/Component/MEvent.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MEvent = (function () {
    function MEvent() {
        this.list = [];
        this.isTraversing = false;
        this.deleteList = [];
    }
    MEvent.prototype.add = function (callback, thisObj) {
        this.list.push({
            callback: callback,
            thisObj: thisObj,
            bindFunc: thisObj ? callback.bind(thisObj) : undefined
        });
    };
    MEvent.prototype.clear = function () {
        if (this.isTraversing) {
            this.deleteList.concat(this.list);
        }
        else {
            this.list = [];
        }
    };
    MEvent.prototype.remove = function (callback, thisObj) {
        if (this.isTraversing) {
            this.deleteList.push({
                callback: callback,
                thisObj: thisObj
            });
        }
        else {
            this.list = this.list.filter(function (e) { return e.callback !== callback || e.thisObj !== thisObj; });
        }
    };
    MEvent.prototype.call = function () {
        var _this = this;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this.isTraversing = true;
        var item = null;
        for (var i = 0; i < this.list.length; i++) {
            item = this.list[i];
            if (item.bindFunc) {
                item.bindFunc.apply(item, args);
            }
            else {
                item.callback.apply(item, args);
            }
        }
        var _loop_1 = function (i) {
            this_1.list = this_1.list.filter(function (e) { return e.callback !== _this.deleteList[i].callback || e.thisObj !== _this.deleteList[i].thisObj; });
        };
        var this_1 = this;
        for (var i = 0; i < this.deleteList.length; i++) {
            _loop_1(i);
        }
        this.deleteList = [];
        this.isTraversing = false;
    };
    return MEvent;
}());
exports.default = MEvent;


/***/ }),

/***/ "./src/Component/Pool.ts":
/*!*******************************!*\
  !*** ./src/Component/Pool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var PoolGroup = (function () {
    function PoolGroup(layer) {
        this.layer = layer;
        this.data = {};
    }
    PoolGroup.prototype.recycle = function (key, element) {
        this.data[key].recycle(element);
    };
    return PoolGroup;
}());
exports.PoolGroup = PoolGroup;
var Pool = (function () {
    function Pool(layer) {
        this.layer = layer;
        this.data = [];
    }
    Pool.prototype.recycle = function (element) {
        element.onElementRecycle();
        this.data.push(element);
    };
    return Pool;
}());
exports.Pool = Pool;


/***/ }),

/***/ "./src/Component/UILayer.ts":
/*!**********************************!*\
  !*** ./src/Component/UILayer.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MConst_1 = __webpack_require__(/*! ../Global/MConst */ "./src/Global/MConst.ts");
var UILayer = (function (_super) {
    __extends(UILayer, _super);
    function UILayer() {
        var _this = _super.call(this) || this;
        _this.width = MConst_1.MConst.DesignResolution.width;
        _this.height = MConst_1.MConst.DesignResolution.height;
        return _this;
    }
    return UILayer;
}(FYGE.Container));
exports.default = UILayer;


/***/ }),

/***/ "./src/Game/GameComponent.ts":
/*!***********************************!*\
  !*** ./src/Game/GameComponent.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var GameComponent = (function () {
    function GameComponent(owner) {
        this._enabled = false;
        this._owner = null;
        this._owner = owner;
    }
    Object.defineProperty(GameComponent.prototype, "enabled", {
        get: function () {
            return this._enabled;
        },
        set: function (v) {
            if (v == true && this._enabled == false) {
                this.onEnabled();
                this._enabled = v;
            }
            else if (v == false && this._enabled == true) {
                this.onDisabled();
                this._enabled = v;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GameComponent.prototype, "owner", {
        get: function () {
            return this._owner;
        },
        enumerable: true,
        configurable: true
    });
    return GameComponent;
}());
exports.default = GameComponent;


/***/ }),

/***/ "./src/Global/GUtils.ts":
/*!******************************!*\
  !*** ./src/Global/GUtils.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MUtils_1 = __webpack_require__(/*! ./MUtils */ "./src/Global/MUtils.ts");
function getBallScore(bulletScore, powerScore, colorIndex) {
    var getScoreFromRange = function (_a) {
        var a = _a[0], b = _a[1];
        a = Math.ceil(a * 0.1);
        b = Math.ceil(b * 0.1);
        var n = Math.abs(b - a) + 1;
        n = Math.floor(n / 6);
        var m = [];
        for (var i = 0; i < 5; i++) {
            m.push([a + n * i, a + n * i + n - 1]);
        }
        m.push([a + n * 4 + n, b]);
        var _b = m[colorIndex], a0 = _b[0], b0 = _b[1];
        var result = Math.ceil(Math.random() * (b0 - a0 + 1)) + a0;
        return result;
    };
    if (bulletScore <= 20)
        return getScoreFromRange([0.01 * powerScore, 0.2 * powerScore]);
    if (bulletScore > 20 && bulletScore <= 40) {
        return getScoreFromRange([0.2 * powerScore, 0.6 * powerScore]);
    }
    var getRange = function (list, props) {
        return getScoreFromRange(getProp(list, props)[0]);
    };
    if (bulletScore > 40 && bulletScore <= 60) {
        var list_1 = [
            [0.2 * powerScore, 0.6 * powerScore],
            [0.6 * powerScore, 0.8 * powerScore],
            [0.8 * powerScore, 1.5 * powerScore],
        ];
        return getRange(list_1, [3, 5, 2]);
    }
    if (bulletScore > 60 && bulletScore <= 80) {
        var list_2 = [
            [0.6 * powerScore, 0.8 * powerScore],
            [0.8 * powerScore, 1.5 * powerScore],
            [1.5 * powerScore, 2.2 * powerScore],
        ];
        return getRange(list_2, [2, 5, 2]);
    }
    if (bulletScore > 80 && bulletScore <= 100) {
        var list_3 = [
            [1.5 * powerScore, 2.2 * powerScore],
            [2.2 * powerScore, 3.2 * powerScore],
            [3.2 * powerScore, 4.2 * powerScore],
        ];
        return getRange(list_3, [1, 5, 4]);
    }
    if (bulletScore > 100 && bulletScore <= 120) {
        var list_4 = [
            [2.2 * powerScore, 3.2 * powerScore],
            [3.2 * powerScore, 4.2 * powerScore],
            [4.2 * powerScore, 5.2 * powerScore],
        ];
        return getRange(list_4, [1, 4, 5]);
    }
    var list = [
        [2.2 * powerScore, 3.2 * powerScore],
        [3.2 * powerScore, 4.2 * powerScore],
        [4.2 * powerScore, 5.2 * powerScore],
    ];
    return getRange(list, [1, 3, 6]);
}
exports.getBallScore = getBallScore;
function getProp(items, props, n) {
    if (n === void 0) { n = 1; }
    var pool = [];
    for (var i in items) {
        for (var j = 0; j < props[i]; j++) {
            pool.push(items[i]);
        }
    }
    var result = [];
    for (var i = 0; i < n; i++) {
        result.push(pool[MUtils_1.MUtils.randomInt(0, pool.length)]);
    }
    return result;
}
exports.getProp = getProp;
function arrayRemove(array, target) {
    var newArray = [];
    for (var i = 0; i < array.length; i++) {
        if (array[i] !== target) {
            newArray.push(array[i]);
        }
    }
    return newArray;
}
exports.arrayRemove = arrayRemove;


/***/ }),

/***/ "./src/Global/MConfigs.ts":
/*!********************************!*\
  !*** ./src/Global/MConfigs.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MConfigs;
(function (MConfigs) {
    function updateConfig() {
        var mconfig = window["mconfig"];
        if (typeof mconfig != "object")
            return;
        Object.keys(mconfig).forEach(function (e) {
            MConfigs[e] = mconfig[e];
        });
    }
    MConfigs.updateConfig = updateConfig;
    MConfigs.size = [0.3125, 0.5357, 0.7321, 1];
    MConfigs.drop = [
        {
            type: "bullet",
            value: 1,
            textColor: 0x5dcefa,
            fileIndex: "0"
        },
        {
            type: "bullet",
            value: 2,
            textColor: 0x69e7fc,
            fileIndex: "1"
        },
        {
            type: "power",
            value: 30,
            textColor: 0xe83cf7,
            fileIndex: "2"
        },
        {
            type: "power",
            value: 20,
            textColor: 0xeb3924,
            fileIndex: "1"
        },
        {
            type: "power",
            value: 10,
            textColor: 0xfef552,
            fileIndex: "0"
        }
    ];
    MConfigs.dropPool = {
        0: {
            num: 3,
            factor: {
                0: 40,
                1: 0,
                2: 0,
                3: 15,
                4: 50
            }
        },
        1: {
            num: 2,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        },
        2: {
            num: 1,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        }
    };
    MConfigs.guide = {
        0: {
            mask: "guide_mask_0_png",
            text: {
                str: "左右移动炮车进行射击和躲避",
                offsetToMask: {
                    x: 8,
                    y: 290
                }
            }
        },
        1: {
            mask: "guide_mask_1_png",
            text: {
                str: "拾取金币可获得更多的炮弹输出和得分加成",
                offsetToMask: {
                    x: -65,
                    y: 290
                }
            }
        },
    };
})(MConfigs = exports.MConfigs || (exports.MConfigs = {}));


/***/ }),

/***/ "./src/Global/MConst.ts":
/*!******************************!*\
  !*** ./src/Global/MConst.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MConst;
(function (MConst) {
    MConst.MaxColorIndex = 5;
    MConst.DesignResolution = {
        width: 750,
        height: 1624
    };
    MConst.GroundLine = 1110;
    MConst.BulletFireSpeed = {
        min: 10,
        max: 20
    };
    MConst.Gravity = 0.15;
    MConst.BallVelocityX = 2;
    MConst.BallVelocityY = 11;
    MConst.BallSplitVelocityY = 6.8;
    MConst.DropVelocityX = {
        x: 2,
        offset: 0.5
    };
    MConst.BallRotateSpeed = 0.7;
    MConst.BallInitPosY = 1206 * 0.25;
    MConst.CreateBallInterval = 1000;
    MConst.ReviveCardId = "sp_1";
    MConst.ConstantSubmitScoreNum = 100;
    MConst.DefaultBallWidth = 224;
    MConst.DefaultStarSize = {
        width: 76 * 0.744,
        height: 72 * 0.744
    };
    MConst.captchaId = "a869bfdfb9bd4cdf88e1ff2f8667a114";
    MConst.BallVelocityXRandomFactor = 0.1;
    MConst.BallVelocityYRandomFactor = 0.08;
    MConst.DropRandomFactor = 0.07;
    MConst.ReviveInvincibleDuration = 3;
    MConst.WenzhouLocation = new FYGE.Rectangle(119.37, 27.03, 1.81, 1.33);
    MConst.HangzhouLocation = new FYGE.Rectangle(118.21, 29.11, 2.09, 1.22);
})(MConst = exports.MConst || (exports.MConst = {}));


/***/ }),

/***/ "./src/Global/MTimer.ts":
/*!******************************!*\
  !*** ./src/Global/MTimer.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MEvent_1 = __webpack_require__(/*! ../Component/MEvent */ "./src/Component/MEvent.ts");
var MTimer = (function () {
    function MTimer() {
    }
    MTimer.init = function () {
        startTime = Date.now();
        FYGE.gameStage.addEventListener(FYGE.Event.ENTER_FRAME, onUpdate, MTimer);
    };
    MTimer.destroy = function () {
        _onFrame.clear();
        FYGE.Stage.removeEventListener(FYGE.Event.ENTER_FRAME, onUpdate, MTimer);
    };
    Object.defineProperty(MTimer, "deltaTime", {
        get: function () {
            return _deltaTime;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MTimer, "dtFactor", {
        get: function () {
            return MTimer.deltaTime / DefaultDeltaTime;
        },
        enumerable: true,
        configurable: true
    });
    MTimer.onFrame = function (key, callback, thisObj) {
        if (key) {
            if (onFrameCaches[key]) {
                _onFrame.remove(onFrameCaches[key].callback, onFrameCaches[key].thisObj);
                delete onFrameCaches[key];
            }
            onFrameCaches[key] = {
                callback: callback,
                thisObj: thisObj
            };
        }
        _onFrame.add(callback, thisObj);
    };
    MTimer.removeOnFrame = function (key) {
        if (onFrameCaches[key]) {
            _onFrame.remove(onFrameCaches[key].callback, onFrameCaches[key].thisObj);
            delete onFrameCaches[key];
        }
    };
    MTimer.setFrameTimer = function (frame, onTimeOut) {
        var count = 0;
        var callback = function () {
            if (count >= frame) {
                onTimeOut();
                timerTickEvent.remove(callback);
            }
            else {
                count += MTimer.dtFactor;
            }
        };
        timerTickEvent.add(callback);
    };
    return MTimer;
}());
exports.default = MTimer;
var onFrameCaches = {};
var _onFrame = new MEvent_1.default();
var timerTickEvent = new MEvent_1.default();
var DefaultDeltaTime = 1000 / 60;
var _deltaTime = 0;
var startTime = 0;
var lastTime = 0;
var curTime = 0;
function updateDeltaTime() {
    lastTime = curTime;
    curTime = Date.now() - startTime;
    _deltaTime = curTime - lastTime;
}
function onUpdate() {
    updateDeltaTime();
    _onFrame.call(MTimer.deltaTime);
    timerTickEvent.call();
}


/***/ }),

/***/ "./src/Global/MUtils.ts":
/*!******************************!*\
  !*** ./src/Global/MUtils.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MUtils;
(function (MUtils) {
    function random(min, max) {
        return Math.random() * (max - min) + min;
    }
    MUtils.random = random;
    function randomInt(min, max) {
        return Math.floor(Math.random() * (max - min) + min);
    }
    MUtils.randomInt = randomInt;
    function toRadians(degrees) {
        return degrees / 180 * Math.PI;
    }
    MUtils.toRadians = toRadians;
    function toDegress(radians) {
        return radians / Math.PI * 180;
    }
    MUtils.toDegress = toDegress;
    function degreesAngelAdd(a, b) {
        return (a + b) % 360;
    }
    MUtils.degreesAngelAdd = degreesAngelAdd;
    function dot(vec1, vec2) {
        return vec1.x * vec2.x + vec1.y * vec2.y;
    }
    MUtils.dot = dot;
    function getAngle(point) {
        var radians = Math.acos(point.x / (Math.sqrt(point.x * point.x + point.y * point.y)));
        radians = point.y > 0 ? radians : -radians;
        return toDegress(radians);
    }
    MUtils.getAngle = getAngle;
    function getVector(angle) {
        angle = toRadians(angle);
        return new FYGE.Point(Math.cos(angle), Math.sin(angle));
    }
    MUtils.getVector = getVector;
    function stringOverEllipsis(str, limit) {
        if (str.length > limit) {
            return str.substring(0, limit) + "...";
        }
        else {
            return str;
        }
    }
    MUtils.stringOverEllipsis = stringOverEllipsis;
    function getClassName(cls) {
        return cls["prototype"]["constructor"]["name"];
    }
    MUtils.getClassName = getClassName;
    function getInstanceClassName(instance) {
        return getClassName(instance["constructor"]);
    }
    MUtils.getInstanceClassName = getInstanceClassName;
    function setColorFilter(image, color) {
    }
    MUtils.setColorFilter = setColorFilter;
})(MUtils = exports.MUtils || (exports.MUtils = {}));


/***/ }),

/***/ "./src/Main.ts":
/*!*********************!*\
  !*** ./src/Main.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var StartScene_1 = __webpack_require__(/*! ./scenes/StartScene */ "./src/scenes/StartScene.ts");
var ResJson_1 = __webpack_require__(/*! ./ResJson */ "./src/ResJson.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
exports.GDispatcher = new FYGE.EventDispatcher();
var Main = (function () {
    function Main(canvas) {
        var sysInfo;
        if (my) {
            FYGE.initedByCanvas(canvas);
            sysInfo = my.getSystemInfoSync();
        }
        var stage = new FYGE.Stage(canvas, 750, 1624, sysInfo && sysInfo.windowWidth || document.body.clientWidth, sysInfo && sysInfo.windowHeight || document.body.clientHeight, FYGE.RENDERER_TYPE.CANVAS);
        this.stage = stage;
        FYGE.gameStage = this.stage;
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                FYGE.Tween.flush();
                stage.flush();
            }
            self.requestID = FYGE.getRequestAnimationFrame()(loop);
        }
    }
    Main.prototype.onAddToStage = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        layers_1.layers.init(this.stage);
                        console.log("初始化层级完成");
                        RES_1.RES.loadConfig(ResJson_1.ResJson);
                        console.log("初始化资源配置完成");
                        return [4, RES_1.RES.loadGroup("common")];
                    case 1:
                        _a.sent();
                        console.log("通用资源加载完成");
                        try {
                            ctrls_1.changeScene(StartScene_1.StartScene);
                        }
                        catch (err) {
                            console.log(err);
                        }
                        console.log("恶趣味去");
                        return [2];
                }
            });
        });
    };
    Main.prototype.run = function () {
        this._pause = false;
    };
    Main.prototype.pause = function () {
        this._pause = true;
    };
    Main.prototype.addGlobalEvent = function (name, fun, thisObj, once) {
        if (once === void 0) { once = false; }
        if (once) {
            exports.GDispatcher.once(name, fun, thisObj);
        }
        else {
            exports.GDispatcher.addEventListener(name, fun, thisObj);
        }
    };
    Main.prototype.dispatchGlobalEvent = function (name, data) {
        exports.GDispatcher.dispatchEvent(name, data);
    };
    Main.prototype.removeGlobalEvent = function (name, fun, thisObj) {
        exports.GDispatcher.removeEventListener(name, fun, thisObj);
    };
    Main.prototype.destroy = function () {
        FYGE.Tween.removeAllTweens();
        FYGE.getCancelAnimationFrame()(this.requestID);
        layers_1.destroyLayers();
        ctrls_1.destroyAllCtrls();
        this.stage.destroy();
        exports.GDispatcher.removeAllEventListener();
        TaoBaoNet_1.destroyNetData();
    };
    return Main;
}());
exports.Main = Main;


/***/ }),

/***/ "./src/Mgr/DataMgr.ts":
/*!****************************!*\
  !*** ./src/Mgr/DataMgr.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DataMgr;
(function (DataMgr) {
    DataMgr.game = null;
    DataMgr.minEnableCaptchaScore = null;
})(DataMgr = exports.DataMgr || (exports.DataMgr = {}));


/***/ }),

/***/ "./src/Mgr/DebugMgr.ts":
/*!*****************************!*\
  !*** ./src/Mgr/DebugMgr.ts ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var UILayer_1 = __webpack_require__(/*! ../Component/UILayer */ "./src/Component/UILayer.ts");
var MTimer_1 = __webpack_require__(/*! ../Global/MTimer */ "./src/Global/MTimer.ts");
var DebugMgr = (function (_super) {
    __extends(DebugMgr, _super);
    function DebugMgr() {
        var _this = _super.call(this) || this;
        _this.enabled = true;
        _this.enabledGraphic = true;
        _this.shapeMap = {};
        _this.graphicDebugLayer = null;
        _this.uiLayer = null;
        _this.log = null;
        _this.test = null;
        _this.labelFPS = new FYGE.TextField();
        _this.onClick = function () { };
        _this.lastFrameData = { runTime: 0, frameCount: 0 };
        _this.curFrameData = { runTime: 0, frameCount: 0 };
        _this.resetTimer = 0;
        if (!_this.enabled)
            return _this;
        _this.graphicDebugLayer = new UILayer_1.default();
        _this.addChild(_this.graphicDebugLayer);
        _this.uiLayer = new FYGE.Container();
        _this.addChild(_this.uiLayer);
        _this.labelFPS.size = 30;
        _this.labelFPS.fillColor = "rgba(255,255,255,1)";
        _this.labelFPS.text = "0";
        _this.labelFPS.x = 20;
        _this.labelFPS.y = 20;
        _this.uiLayer.addChild(_this.labelFPS);
        return _this;
    }
    DebugMgr.prototype.setLog = function (msg) {
        if (!this.enabled)
            return;
        this.log.text = msg;
    };
    DebugMgr.prototype.drawRect = function (rect, style) {
        if (style === void 0) { style = { color: 0x00ff00, lineSize: 1 }; }
        if (!this.enabled || !this.enabledGraphic)
            return;
        var shape = new FYGE.Graphics();
        shape.beginFill(style.color);
        shape.drawRect(rect.x, rect.y, rect.width, rect.height);
        shape.endFill();
        this.graphicDebugLayer.addChild(shape);
    };
    DebugMgr.prototype.drawCircle = function (x, y, radius, style) {
        if (style === void 0) { style = { color: 0x00ff00, lineSize: 1 }; }
        if (!this.enabled || !this.enabledGraphic)
            return;
        var shape = new FYGE.Graphics();
        shape.beginFill(style.color);
        shape.drawCircle(x, y, radius);
        shape.endFill();
        this.graphicDebugLayer.addChild(shape);
    };
    DebugMgr.prototype.drawLine = function (line, style) {
        if (style === void 0) { style = { color: 0x00ff00, lineSize: 1 }; }
        if (!this.enabled || !this.enabledGraphic)
            return;
        var shape = new FYGE.Graphics();
        shape.beginFill(style.color);
        shape.moveTo(line.startX, line.startY);
        shape.lineTo(line.endX, line.endY);
        shape.endFill();
        this.graphicDebugLayer.addChild(shape);
    };
    DebugMgr.prototype.updateLine = function (key, line, style) {
        if (style === void 0) { style = { color: 0x00ff00, lineSize: 1 }; }
        if (!this.enabled || !this.enabledGraphic)
            return;
        var shape = this.shapeMap[key];
        if (!shape) {
            shape = new FYGE.Graphics();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }
        shape.clear();
        shape.beginFill(style.color);
        shape.moveTo(line.startX, line.startY);
        shape.lineTo(line.endX, line.endY);
        shape.endFill();
    };
    DebugMgr.prototype.updateRect = function (key, rect, style) {
        if (style === void 0) { style = { color: 0x00ff00, lineSize: 1 }; }
        if (!this.enabled || !this.enabledGraphic)
            return;
        var shape = this.shapeMap[key];
        if (!shape) {
            shape = new FYGE.Graphics();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }
        shape.clear();
        shape.beginFill(style.color);
        shape.drawRect(rect.x, rect.y, rect.width, rect.height);
        shape.endFill();
    };
    DebugMgr.prototype.updateCircle = function (key, x, y, radius, style) {
        if (style === void 0) { style = { color: 0x00ff00, lineSize: 1 }; }
        if (!this.enabled || !this.enabledGraphic)
            return;
        var shape = this.shapeMap[key];
        if (!shape) {
            shape = new FYGE.Graphics();
            this.graphicDebugLayer.addChild(shape);
            this.shapeMap[key] = shape;
        }
        shape.clear();
        shape.beginFill(style.color);
        shape.drawCircle(x, y, radius);
        shape.endFill();
    };
    DebugMgr.prototype.clearShape = function (key) {
        if (!this.enabled || !this.enabledGraphic)
            return;
        var shape = this.shapeMap[key];
        if (!shape) {
            return;
        }
        delete this.shapeMap[key];
        shape.dispose();
    };
    DebugMgr.prototype.init = function (context) {
        context.addChild(this);
        MTimer_1.default.onFrame("DebugMgr", this.onUpdate, this);
    };
    DebugMgr.prototype.onUpdate = function (dt) {
        this.curFrameData.runTime += dt;
        this.curFrameData.frameCount += 1;
        this.resetTimer += dt;
        var average = (this.curFrameData.runTime + this.lastFrameData.runTime) / (this.curFrameData.frameCount + this.lastFrameData.frameCount);
        if (this.resetTimer > 200) {
            this.labelFPS.text = Math.round(1000 / average).toString();
            this.lastFrameData.runTime = this.curFrameData.runTime;
            this.lastFrameData.frameCount = this.curFrameData.frameCount;
            this.curFrameData.runTime = 0;
            this.curFrameData.frameCount = 0;
            this.resetTimer = 0;
        }
    };
    Object.defineProperty(DebugMgr, "instance", {
        get: function () {
            if (!this._instance) {
                this._instance = new DebugMgr();
            }
            return this._instance;
        },
        enumerable: true,
        configurable: true
    });
    DebugMgr._instance = null;
    return DebugMgr;
}(UILayer_1.default));
exports.default = DebugMgr;


/***/ }),

/***/ "./src/Mgr/DropBlinkMgr.ts":
/*!*********************************!*\
  !*** ./src/Mgr/DropBlinkMgr.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameMgr_1 = __webpack_require__(/*! ./GameMgr */ "./src/Mgr/GameMgr.ts");
var DropBlinkMgr = (function (_super) {
    __extends(DropBlinkMgr, _super);
    function DropBlinkMgr() {
        var _this = _super.call(this, "DropBlinkMgr") || this;
        _this.list = [];
        _this.frameTimer = 0;
        return _this;
    }
    DropBlinkMgr.prototype.add = function (drop) {
        this.list.push({
            drop: drop,
            count: 0
        });
    };
    DropBlinkMgr.prototype.remove = function (drop) {
        this.list = this.list.filter(function (e) { return e.drop !== drop; });
    };
    DropBlinkMgr.prototype.onUpdate = function () {
        if (this.pause)
            return;
        if (this.frameTimer % BlinkDuration == 0) {
            var temp = null;
            for (var i in this.list) {
                temp = this.list[i];
                temp.drop.visible = !temp.drop.visible;
                temp.count++;
            }
            this.list = this.list.filter(function (e) {
                if (e.count < 60 / BlinkDuration * 2) {
                    return true;
                }
                else {
                    e.drop.dispose();
                    return false;
                }
            });
        }
        this.frameTimer++;
    };
    return DropBlinkMgr;
}(GameMgr_1.default));
exports.default = DropBlinkMgr;
var BlinkDuration = 3;


/***/ }),

/***/ "./src/Mgr/GameMgr.ts":
/*!****************************!*\
  !*** ./src/Mgr/GameMgr.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var MTimer_1 = __webpack_require__(/*! ../Global/MTimer */ "./src/Global/MTimer.ts");
var GameMgr = (function () {
    function GameMgr(name) {
        this.name = name;
        this.pause = false;
    }
    GameMgr.prototype.onInit = function () {
        MTimer_1.default.onFrame(this.name, this.onUpdate, this);
    };
    GameMgr.prototype.onDestroy = function () {
        MTimer_1.default.removeOnFrame(this.name);
    };
    GameMgr.prototype.onUpdate = function (dt) {
    };
    return GameMgr;
}());
exports.default = GameMgr;


/***/ }),

/***/ "./src/Mgr/GuideMgr.ts":
/*!*****************************!*\
  !*** ./src/Mgr/GuideMgr.ts ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var DataMgr_1 = __webpack_require__(/*! ./DataMgr */ "./src/Mgr/DataMgr.ts");
var MConfigs_1 = __webpack_require__(/*! ../Global/MConfigs */ "./src/Global/MConfigs.ts");
var GuideMask_1 = __webpack_require__(/*! ../game/GuideMask */ "./src/game/GuideMask.ts");
var GuideMgr = (function () {
    function GuideMgr() {
        this.done = [];
        this.currentGuideMask = null;
    }
    Object.defineProperty(GuideMgr, "instance", {
        get: function () {
            if (!GuideMgr._instance) {
                GuideMgr._instance = new GuideMgr();
            }
            return GuideMgr._instance;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GuideMgr.prototype, "guideFlag", {
        get: function () {
            var key = "shoot-planet_" + "props.guideFlagKey";
            return my ? my.getStorageSync({ key: key }) != "false" : localStorage.getItem(key) != "false";
        },
        set: function (v) {
            if (my) {
                my.setStorageSync({
                    key: "shoot-planet_" + "props.guideFlagKey",
                    data: v ? "true" : "false"
                });
            }
            else {
                localStorage.setItem("shoot-planet_" + "props.guideFlagKey", v ? "true" : "false");
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GuideMgr.prototype, "container", {
        set: function (c) {
            this._container = c;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GuideMgr.prototype, "guideDone", {
        get: function () {
            return !this.guideFlag || this.done.length >= Object.keys(MConfigs_1.MConfigs.guide).length;
        },
        enumerable: true,
        configurable: true
    });
    GuideMgr.prototype.runGuide = function (index, x, y, end) {
        var _this = this;
        if (end === void 0) { end = false; }
        if (this.done[index] || this.guideFlag == false)
            return;
        this.done.push(index);
        DataMgr_1.DataMgr.game.pause = true;
        this.currentGuideMask = new GuideMask_1.default(index, x, y);
        this.currentGuideMask.onClick = function (context) {
            context.dispose();
            DataMgr_1.DataMgr.game.pause = false;
            if (_this.done.length >= Object.keys(MConfigs_1.MConfigs.guide).length) {
                DataMgr_1.DataMgr.game.onGuideDone();
            }
            if (end) {
                _this.guideFlag = false;
            }
        };
        this._container.addChild(this.currentGuideMask);
    };
    GuideMgr._instance = null;
    return GuideMgr;
}());
exports.default = GuideMgr;


/***/ }),

/***/ "./src/Pools/AnimationPool.ts":
/*!************************************!*\
  !*** ./src/Pools/AnimationPool.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var FrameAnimation_1 = __webpack_require__(/*! ../component/FrameAnimation */ "./src/component/FrameAnimation.ts");
var Pool_1 = __webpack_require__(/*! ../Component/Pool */ "./src/Component/Pool.ts");
var PoolFrameAnimation = (function (_super) {
    __extends(PoolFrameAnimation, _super);
    function PoolFrameAnimation() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PoolFrameAnimation.prototype.onElementInit = function () {
        this.visible = true;
        this.curPos = 0;
    };
    PoolFrameAnimation.prototype.onElementRecycle = function () {
        this.visible = false;
    };
    return PoolFrameAnimation;
}(FrameAnimation_1.default));
exports.PoolFrameAnimation = PoolFrameAnimation;
var AnimationPool = (function (_super) {
    __extends(AnimationPool, _super);
    function AnimationPool() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnimationPool.prototype.spwan = function (key) {
        if (this.data.length > 0) {
            var element = this.data.shift();
            element.onElementInit();
            return element;
        }
        else {
            var anim = new PoolFrameAnimation(key);
            this.layer.addChild(anim);
            return anim;
        }
    };
    return AnimationPool;
}(Pool_1.Pool));
var AnimationPoolGroup = (function (_super) {
    __extends(AnimationPoolGroup, _super);
    function AnimationPoolGroup() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnimationPoolGroup.prototype.spwan = function (key) {
        if (!this.data[key]) {
            this.data[key] = new AnimationPool(this.layer);
        }
        var element = this.data[key].spwan(key);
        return element;
    };
    return AnimationPoolGroup;
}(Pool_1.PoolGroup));
exports.default = AnimationPoolGroup;


/***/ }),

/***/ "./src/Pools/BallPool.ts":
/*!*******************************!*\
  !*** ./src/Pools/BallPool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var Ball_1 = __webpack_require__(/*! ../game/Ball */ "./src/game/Ball.ts");
var Pool_1 = __webpack_require__(/*! ../Component/Pool */ "./src/Component/Pool.ts");
var BallPool = (function (_super) {
    __extends(BallPool, _super);
    function BallPool() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BallPool.prototype.spwan = function (sizeIndex) {
        var element = null;
        if (this.data.length > 0) {
            element = this.data.shift();
            element.onElementInit();
        }
        else {
            element = new Ball_1.default(sizeIndex);
            this.layer.addChild(element);
        }
        DataMgr_1.DataMgr.game._ballList.push(element);
        return element;
    };
    BallPool.prototype.recycle = function (element) {
        _super.prototype.recycle.call(this, element);
        DataMgr_1.DataMgr.game._ballList = DataMgr_1.DataMgr.game._ballList.filter(function (e) { return e !== element; });
    };
    return BallPool;
}(Pool_1.Pool));
;
var BallPoolGroup = (function (_super) {
    __extends(BallPoolGroup, _super);
    function BallPoolGroup() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BallPoolGroup.prototype.spwan = function (sizeIndex) {
        var key = sizeIndex.toString();
        if (!this.data[key]) {
            var ball = this.data[key] = new BallPool(this.layer);
        }
        var element = this.data[key].spwan(sizeIndex);
        element.poolKey = key;
        return element;
    };
    return BallPoolGroup;
}(Pool_1.PoolGroup));
exports.BallPoolGroup = BallPoolGroup;


/***/ }),

/***/ "./src/Pools/BulletPool.ts":
/*!*********************************!*\
  !*** ./src/Pools/BulletPool.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Component/Pool */ "./src/Component/Pool.ts");
var Bullet_1 = __webpack_require__(/*! ../game/Bullet */ "./src/game/Bullet.ts");
var BulletPool = (function (_super) {
    __extends(BulletPool, _super);
    function BulletPool() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BulletPool.prototype.spwan = function () {
        if (this.data.length > 0) {
            var element = this.data.shift();
            element.onElementInit();
            return element;
        }
        else {
            var b = new Bullet_1.default();
            this.layer.addChild(b);
            return b;
        }
    };
    return BulletPool;
}(Pool_1.Pool));
exports.BulletPool = BulletPool;


/***/ }),

/***/ "./src/Pools/DropPool.ts":
/*!*******************************!*\
  !*** ./src/Pools/DropPool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Drop_1 = __webpack_require__(/*! ../game/Drop */ "./src/game/Drop.ts");
var Pool_1 = __webpack_require__(/*! ../Component/Pool */ "./src/Component/Pool.ts");
var DropPool = (function (_super) {
    __extends(DropPool, _super);
    function DropPool() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DropPool.prototype.spwan = function (id) {
        if (this.data.length > 0) {
            var element = this.data.shift();
            element.onElementInit();
            return element;
        }
        else {
            var d = new Drop_1.default(id);
            this.layer.addChild(d);
            return d;
        }
    };
    return DropPool;
}(Pool_1.Pool));
var DropPoolGroup = (function (_super) {
    __extends(DropPoolGroup, _super);
    function DropPoolGroup() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DropPoolGroup.prototype.spwan = function (id) {
        if (!this.data[id]) {
            this.data[id] = new DropPool(this.layer);
        }
        return this.data[id].spwan(id);
    };
    return DropPoolGroup;
}(Pool_1.PoolGroup));
exports.default = DropPoolGroup;


/***/ }),

/***/ "./src/ResJson.ts":
/*!************************!*\
  !*** ./src/ResJson.ts ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ResJson = {
    "groups": [
        {
            "keys": "comCloseBtn.png,toastBg.png,waitingBg.png,waitingRot.png",
            "name": "common"
        },
        {
            "keys": "ball_0.png,ball_1.png,ball_2.png,ball_3.png,ball_4.png,ball_5.png,bullet.png,car.png,car_particle.png,drop_1.png,drop_2.png,drop_3.png,drop_4.png,drop_5.png,main_bg.jpg,main_bullet.png,main_power.png,mask.png",
            "name": "dxqPlayScene"
        },
        {
            "keys": "close.png,firstDay.png,fivethDay.png,fourthDay.png,rank_bg.png,rank_content_bg_left.png,rank_content_bg_right.png,ruleBg.png,secondDay.png,seventhDay.png,signAniBtn.png,sign_bg.png,sixthDay.png,thridDay.png",
            "name": "outerPanel"
        },
        {
            "keys": "doHelpIcon.png,propBtn.png,rankBtn.png,recordBtn.png,ruleBtn.png,signInBtn.png,startBg.png,startBtn.png",
            "name": "startScene"
        }
    ],
    "path": "./resource/"
};


/***/ }),

/***/ "./src/TaoBaoNet.ts":
/*!**************************!*\
  !*** ./src/TaoBaoNet.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var TbNetName;
(function (TbNetName) {
    TbNetName["home"] = "duiba.shoot.index";
    TbNetName["doSign"] = "duiba.sign.doJoin";
    TbNetName["signData"] = "duiba.sign.index";
    TbNetName["rankInfo"] = "duiba.rank.list.info";
    TbNetName["rankList"] = "duiba.rank.list";
    TbNetName["start"] = "duiba.shoot.doJoin";
    TbNetName["constantSubmit"] = "duiba.shoot.push";
    TbNetName["finalSubmit"] = "duiba.shoot.submit";
    TbNetName["propList"] = "duiba.prop.list";
    TbNetName["useProp"] = "duiba.prop.use";
    TbNetName["taskComplete"] = "duiba.task.complete";
    TbNetName["lastRankInfo"] = "duiba.rank.lastRankInfo";
    TbNetName["taskList"] = "duiba.task.list";
    TbNetName["prizeList"] = "duiba.prize.list";
    TbNetName["doAssist"] = "duiba.assist.doAssist";
    TbNetName["invite"] = "duiba.assist.createItem";
    TbNetName["prizeTake"] = "duiba.prize.take";
    TbNetName["groupSpeak"] = "duiba.task.sendChatMsg";
    TbNetName["getGoodsList"] = "duiba.task.specialItems";
    TbNetName["getLinkParam"] = "mine.getLinkParam";
    TbNetName["navigateToOutside"] = "mine.navigateToOutside";
    TbNetName["c"] = "";
})(TbNetName = exports.TbNetName || (exports.TbNetName = {}));
var dataRecord = {};
var fc;
function sendTbNet(netName, parameter, callback, hideMsg) {
    if (hideMsg === void 0) { hideMsg = false; }
    var waitObj = ctrls_1.wait(function () {
        if (!hideMsg)
            ctrls_1.showToast("网络超时");
        callback(false);
    }, 5000);
    if (!my) {
        var url = "../../mock/miniTb/" + netName + ".json";
        fetchAsync(url)
            .then(function (data) {
            ctrls_1.clearWait(waitObj);
            dataRecord[name] = data;
            if (!hideMsg && !data.success)
                ctrls_1.showToast(data.message || "网络异常");
            callback(data.success, data);
        }, function () { });
        return;
    }
    if (!fc)
        fc = getApp().cloud.function;
    fc.invoke("becheery", parameter, netName)
        .then(function (res) {
        ctrls_1.clearWait(waitObj);
        dataRecord[netName] = res;
        if (!hideMsg && !res.success)
            ctrls_1.showToast(codeMsg[res.code] || res.message || "网络异常");
        callback(res.success, res);
    });
}
exports.sendTbNet = sendTbNet;
function getTbData(netName) {
    return dataRecord[netName] || null;
}
exports.getTbData = getTbData;
function destroyNetData() {
    dataRecord = {};
}
exports.destroyNetData = destroyNetData;
function fetchAsync(url) {
    return __awaiter(this, void 0, void 0, function () {
        var response, data;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1:
                    response = _a.sent();
                    return [4, response.json()];
                case 2:
                    data = _a.sent();
                    return [2, data];
            }
        });
    });
}
var codeMsg = {
    "210001": "服务器异常",
    "210002": "用户不存在",
    "210003": "邀请已达上限",
    "210004": "无法邀请自己",
    "210006": "该活动ID无效",
    "210009": "该活动暂未开始",
    "210010": "该分享ID不存在",
    "210012": "该用户暂未获奖",
    "210013": "领取失败",
    "210015": "该活动已删除",
    "210016": "该活动已经结束",
    "210017": "该奖品已达领取上线",
    "210018": "请先分享好友",
    "210019": "暂有奖品未领取",
    "210020": "暂有奖品未完成",
    "210021": "请先玩一局游戏",
    "210022": "请先选择奖品",
    "210023": "领取失败，库存不足",
    "210024": "请先成为会员",
    "210025": "奖品已经过期",
    "210026": "不能重复助力",
    "210028": "请至我的奖品页重新领取",
};


/***/ }),

/***/ "./src/Tools.ts":
/*!**********************!*\
  !*** ./src/Tools.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var Tool = (function () {
    function Tool() {
    }
    Tool.init = function () {
    };
    Tool.getSprite = function (imageName, x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var sprite = new FYGE.Sprite(RES_1.RES.getRes(imageName));
        sprite.x = x;
        sprite.y = y;
        return sprite;
    };
    Tool.getText = function (txt, size, color, align, textWidth, x, y) {
        if (color === void 0) { color = "#000000"; }
        if (align === void 0) { align = FYGE.TEXT_ALIGN.LEFT; }
        if (textWidth === void 0) { textWidth = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var text = new FYGE.TextField();
        text.fillColor = color;
        text.size = size;
        text.textWidth = textWidth;
        text.textAlign = align;
        text.x = x;
        text.y = y;
        text.text = txt;
        return text;
    };
    Tool.getRect = function (width, height, color, alpha, radius, x, y) {
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (radius === void 0) { radius = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        if (!radius) {
            g.drawRect(0, 0, width, height);
        }
        else {
            g.drawRoundedRect(0, 0, width, height, radius);
        }
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tool.getCircle = function (radius, color, alpha, x, y) {
        if (radius === void 0) { radius = 10; }
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        g.drawCircle(0, 0, radius);
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tool.initLatData = function () {
        var spaceX = this.width + 11, spaceY = this.height + 11, offsetX = this.offsetX + this.width / 2, offsetY = this.offsetY + this.height / 2;
        for (var i = 0; i < this.rowNum; i++) {
            for (var j = 0; j < this.colNum; j++) {
                this.rcToIndexMap["" + i + j] = i * this.colNum + j;
                this.indexToRcMap[i * this.colNum + j] = [i, j];
                this.rowColPositions["" + i + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
                this.indexPositions[i * this.colNum + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
            }
        }
    };
    Tool.rcToIndex = function (row, col) {
        var key = "" + row + col;
        return this.rcToIndexMap[key];
    };
    Tool.indexToRc = function (index) {
        return this.indexToRcMap[index];
    };
    Tool.getPositionByRc = function (row, col) {
        var key = "" + row + col;
        return this.rowColPositions[key];
    };
    Tool.getPositionByIndex = function (index) {
        return this.indexPositions[index];
    };
    Tool.cacheKey = "hadCompleteHaokelai";
    Tool.rowNum = 4;
    Tool.colNum = 4;
    Tool.width = 125;
    Tool.height = 125;
    Tool.offsetX = 106;
    Tool.offsetY = 600;
    Tool.rcToIndexMap = {};
    Tool.indexToRcMap = [];
    Tool.rowColPositions = {};
    Tool.indexPositions = [];
    return Tool;
}());
exports.Tool = Tool;


/***/ }),

/***/ "./src/component/FrameAnimation.ts":
/*!*****************************************!*\
  !*** ./src/component/FrameAnimation.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameMgr_1 = __webpack_require__(/*! ../Mgr/GameMgr */ "./src/Mgr/GameMgr.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var FrameAnimationMgr = (function (_super) {
    __extends(FrameAnimationMgr, _super);
    function FrameAnimationMgr() {
        var _this = _super.call(this, "FrameAnimationMgr") || this;
        _this.playingAnimations = [];
        return _this;
    }
    FrameAnimationMgr.prototype.onUpdate = function () {
        if (this.pause)
            return;
        var filters = [];
        var anim = null;
        for (var i = 0; i < this.playingAnimations.length; i++) {
            anim = this.playingAnimations[i];
            anim.onUpdate();
            if (anim.curPos >= anim.frameCount) {
                anim.onCompleted && anim.onCompleted();
            }
            else {
                filters.push(anim);
            }
        }
        this.playingAnimations = filters;
    };
    return FrameAnimationMgr;
}(GameMgr_1.default));
exports.FrameAnimationMgr = FrameAnimationMgr;
var FrameAnimation = (function (_super) {
    __extends(FrameAnimation, _super);
    function FrameAnimation(key) {
        var _this = _super.call(this) || this;
        _this.frames = [];
        _this.frameCount = 0;
        _this.curPos = 0;
        _this.frameTimer = 0;
        _this.frameRate = 60;
        _this.sprite = new FYGE.Sprite;
        if (!FrameAnimation.caches[key]) {
            console.error("unloaded animation:" + key);
            return _this;
        }
        _this.frames = FrameAnimation.caches[key].frames;
        _this.frameCount = Object.keys(_this.frames).length;
        _this.frameRate = FrameAnimation.caches[key].frameRate;
        _this.addChild(_this.sprite);
        return _this;
    }
    FrameAnimation.loadRes = function (texture, egretData) {
        var name = null;
        var mc = egretData.mc;
        for (var key in mc) {
            name = key;
            break;
        }
        if (!FrameAnimation.caches[name]) {
            var altaData = {};
            for (var i in egretData.res) {
                altaData[name + "_" + i] = egretData.res[i];
            }
            FYGE.createTextureSheet(texture.baseTexture, altaData);
            var frames_1 = [];
            var framesData = mc[name].frames;
            for (var i in framesData) {
                frames_1[i] = {
                    x: framesData[i].x,
                    y: framesData[i].y,
                    texture: RES_1.RES.getRes(name + "_" + framesData[i].res)
                };
            }
            FrameAnimation.caches[name] = {
                frameRate: mc[name].frameRate,
                frameCount: Object.keys(altaData).length,
                frames: frames_1
            };
        }
    };
    FrameAnimation.prototype.onUpdate = function () {
        if (this.frameTimer >= 60 / this.frameRate) {
            if (this.curPos >= this.frameCount) {
                return;
            }
            else {
                var frameData = this.frames[this.curPos];
                this.sprite.texture = frameData.texture;
                this.sprite.x = frameData.x;
                this.sprite.y = frameData.y;
            }
            this.curPos++;
            this.frameTimer = 0;
        }
        else {
            this.frameTimer++;
        }
    };
    FrameAnimation.prototype.play = function () {
        DataMgr_1.DataMgr.game._animationMgr.playingAnimations.push(this);
    };
    FrameAnimation.caches = {};
    return FrameAnimation;
}(FYGE.Container));
exports.default = FrameAnimation;


/***/ }),

/***/ "./src/game/Ball.ts":
/*!**************************!*\
  !*** ./src/game/Ball.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MoveObject_1 = __webpack_require__(/*! ./MoveObject */ "./src/game/MoveObject.ts");
var MConfigs_1 = __webpack_require__(/*! ../Global/MConfigs */ "./src/Global/MConfigs.ts");
var GUtils_1 = __webpack_require__(/*! ../Global/GUtils */ "./src/Global/GUtils.ts");
var MConst_1 = __webpack_require__(/*! ../Global/MConst */ "./src/Global/MConst.ts");
var MUtils_1 = __webpack_require__(/*! ../Global/MUtils */ "./src/Global/MUtils.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var MTimer_1 = __webpack_require__(/*! ../Global/MTimer */ "./src/Global/MTimer.ts");
var Collider_1 = __webpack_require__(/*! ./Collider */ "./src/game/Collider.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var GuideMgr_1 = __webpack_require__(/*! ../Mgr/GuideMgr */ "./src/Mgr/GuideMgr.ts");
var tempPower = null;
var tempIndexOffset = null;
var imageNames = [
    "ball_0.png",
    "ball_1.png",
    "ball_2.png",
    "ball_3.png",
    "ball_4.png",
    "ball_5.png"
];
var textureSize = {
    width: 210,
    height: 213
};
var Ball = (function (_super) {
    __extends(Ball, _super);
    function Ball(sizeIndex) {
        var _this = _super.call(this) || this;
        _this.colorIndex = 0;
        _this.sizeIndex = 0;
        _this.bitmap = null;
        _this.labelScore = null;
        _this.scaleRatio = 1;
        _this.initScore = null;
        _this.initColorIndex = 0;
        _this.collider = null;
        _this.isBornStage = false;
        _this.poolKey = null;
        _this._score = 0;
        _this.dir = 1;
        _this.scoreUpdateFlag = false;
        var scaleRatio = MConfigs_1.MConfigs.size[sizeIndex];
        var bitmapWidth = textureSize.width * scaleRatio;
        var bitmapHeight = textureSize.height * scaleRatio;
        _this.bitmap = new FYGE.Sprite();
        _this.addChild(_this.bitmap);
        console.log(_this.name);
        _this.bitmap.width = bitmapWidth;
        _this.bitmap.height = bitmapHeight;
        _this.anchorX = bitmapWidth / 2;
        _this.anchorY = bitmapHeight / 2;
        _this.bitmap.x = -bitmapWidth / 2;
        _this.bitmap.y = -bitmapHeight / 2;
        var labelScore = new FYGE.TextField();
        labelScore.size = 60;
        labelScore.scaleX = labelScore.scaleY = scaleRatio;
        _this.addChild(labelScore);
        var collider = _this.addComponent(Collider_1.CircleCollider);
        collider.group = Collider_1.ColliderGroup.Ball;
        _this.collider = collider;
        collider.setData(0, 0, bitmapHeight / 2);
        _this.scaleRatio = scaleRatio;
        _this.sizeIndex = sizeIndex;
        _this.labelScore = labelScore;
        return _this;
    }
    Object.defineProperty(Ball.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (v) {
            if (v < 0)
                v = 0;
            if (this._score != v) {
                this.scoreUpdateFlag = true;
            }
            this._score = v;
        },
        enumerable: true,
        configurable: true
    });
    Ball.prototype.onScoreIsZero = function () {
        if (GuideMgr_1.default.instance.guideFlag == true) {
            this.drop();
        }
        else {
            if (this.sizeIndex > 0) {
                this.split();
            }
            else {
                this.drop();
            }
        }
        DataMgr_1.DataMgr.game._pool.ball.recycle(this.poolKey, this);
    };
    Ball.prototype.init = function (colorIndex, direction, score) {
        this.colorIndex = colorIndex;
        this.initColorIndex = colorIndex;
        this.bitmap.texture = RES_1.RES.getRes(imageNames[colorIndex]);
        this.initScore = score;
        this.score = score;
        this.physics.rotateVelocity = direction * MConst_1.MConst.BallRotateSpeed * Math.pow(1 / this.scaleRatio, 0.5);
        return this;
    };
    Ball.prototype.startBornStage = function (dir) {
        this.isBornStage = true;
        if (dir == 1) {
            this.x = 0 - this.width / 2 - 10;
        }
        else if (dir == -1) {
            this.x = MConst_1.MConst.DesignResolution.width + this.width / 2 + 10;
        }
        this.y = MConst_1.MConst.BallInitPosY;
        this.physics.velocity.x = this.getRandomVelocityX(dir) + 1 * dir;
        this.dir = dir;
        this.physics.onMoved = this.onBornStageMoved.bind(this);
    };
    Ball.prototype.onBornStageMoved = function (owner) {
        if (this.dir == 1) {
            if (this.x > this.width / 2) {
                this.startGravityStage(this.dir);
                this.physics.onMoved = null;
            }
        }
        else if (this.dir == -1) {
            if (this.x < MConst_1.MConst.DesignResolution.width - this.width / 2) {
                this.startGravityStage(this.dir);
                this.physics.onMoved = null;
            }
        }
    };
    Ball.prototype.getRandomVelocityX = function (direction) {
        return direction * MConst_1.MConst.BallVelocityX * (1 + ((1 / this.scaleRatio) - 1) * MUtils_1.MUtils.random(0, MConst_1.MConst.BallVelocityXRandomFactor));
    };
    Ball.prototype.startGravityStage = function (direction) {
        this.isBornStage = false;
        this.physics.velocity.x = this.getRandomVelocityX(direction);
        this.physics.acceleration.y = MConst_1.MConst.Gravity;
    };
    Ball.prototype.onCollisionEnter = function (other) {
        if (other.group == Collider_1.ColliderGroup.Bullet) {
            tempPower = other.owner.power;
            this.score = this.score - tempPower;
            DataMgr_1.DataMgr.game._score += tempPower;
        }
        if (other.group == Collider_1.ColliderGroup.Ground) {
            this.physics.velocity.y = -(MConst_1.MConst.BallVelocityY * (1 + ((1 / this.scaleRatio) - 1) * MUtils_1.MUtils.random(0, MConst_1.MConst.BallVelocityYRandomFactor)));
            if (this.sizeIndex >= MConfigs_1.MConfigs.size.length - 2) {
                DataMgr_1.DataMgr.game._shake();
            }
        }
        if (other.group == Collider_1.ColliderGroup.Wall && !this.isBornStage) {
            this.physics.velocity.x = -this.physics.velocity.x;
            this.physics.rotateVelocity = -this.physics.rotateVelocity;
        }
    };
    Ball.prototype.onCollisionStay = function (other) {
        if (other.group == Collider_1.ColliderGroup.Wall && !this.isBornStage) {
            var dir = other.owner.x < 0 ? 1 : -1;
            this.physics.velocity.x = dir * Math.abs(this.physics.velocity.x);
            this.physics.rotateVelocity = dir * Math.abs(this.physics.rotateVelocity);
        }
    };
    Ball.prototype.onElementRecycle = function () {
        this.visible = false;
        this.physics.velocity.y = 0;
        this.physics.velocity.x = 0;
        this.physics.acceleration.y = 0;
        this.physics.acceleration.x = 0;
        this.disableAllComponents();
    };
    Ball.prototype.onElementInit = function () {
        this.visible = true;
        this.enableAllComponents();
    };
    Ball.prototype.split = function () {
        var _this = this;
        var sizeIndex = this.sizeIndex - 1;
        var score = Math.ceil(this.initScore / 2 * (Math.random() * 0.4 + 0.8));
        var colorIndex = Math.max(this.initColorIndex - 1, 0);
        var callback = function (direction) {
            var ball = DataMgr_1.DataMgr.game._pool.ball.spwan(sizeIndex).init(colorIndex, direction, score);
            ball.x = _this.x;
            ball.y = _this.y;
            ball.startGravityStage(direction);
            ball.physics.velocity.y = -MConst_1.MConst.BallSplitVelocityY;
        };
        callback(1);
        callback(-1);
    };
    Ball.prototype.updateScoreLabel = function () {
        if (this.scoreUpdateFlag == true) {
            var labelScore = this.labelScore;
            var score = this.score;
            if (score >= 1000) {
                labelScore.text = (Math.floor(score / 100) / 10).toString() + "k";
            }
            else {
                labelScore.text = score.toString();
            }
            labelScore.x = -labelScore.width / 2;
            labelScore.y = -labelScore.height / 2;
            this.scoreUpdateFlag = false;
            if (this.score <= 0) {
                this.onScoreIsZero();
            }
        }
    };
    Ball.prototype.drop = function () {
        var index = 1;
        var bulletScore = DataMgr_1.DataMgr.game.bulletScore;
        if (bulletScore <= 30)
            index = 0;
        else if (bulletScore > 30 && bulletScore <= 70)
            index = 1;
        else if (bulletScore > 70)
            index = 2;
        var config = MConfigs_1.MConfigs.dropPool[index];
        var keys = Object.keys(config.factor);
        var values = keys.map(function (e) { return config.factor[e]; });
        var dropIds = GUtils_1.getProp(keys, values, config.num);
        var drops = [];
        for (var _i = 0, dropIds_1 = dropIds; _i < dropIds_1.length; _i++) {
            var id = dropIds_1[_i];
            drops.push(DataMgr_1.DataMgr.game._pool.drop.spwan(id.toString()));
        }
        var dir = this.x > MConst_1.MConst.DesignResolution.width / 2 ? -1 : 1;
        var _loop_1 = function (i) {
            var drop = drops[i];
            drop.x = this_1.x - drop.bitmap.width / 2;
            drop.y = this_1.y - drop.bitmap.height / 2;
            var offsetRatio = (i - 1) + (2 - (drops.length - 1));
            var x = MConst_1.MConst.DropVelocityX.x + offsetRatio * MConst_1.MConst.DropVelocityX.offset;
            x *= MUtils_1.MUtils.random(1 - MConst_1.MConst.DropRandomFactor, 1 + MConst_1.MConst.DropRandomFactor);
            drop.physics.velocity.x = dir * x;
            drop.physics.velocity.y = -(x * 5 * MUtils_1.MUtils.random(0.9, 1.1));
            if (GuideMgr_1.default.instance.guideFlag && i == 1) {
                MTimer_1.default.setFrameTimer(20, function () {
                    GuideMgr_1.default.instance.runGuide(1, drop.x, drop.y, true);
                });
            }
        };
        var this_1 = this;
        for (var i = 0; i < drops.length; i++) {
            _loop_1(i);
        }
    };
    Ball.textures = [];
    return Ball;
}(MoveObject_1.default));
exports.default = Ball;


/***/ }),

/***/ "./src/game/Bullet.ts":
/*!****************************!*\
  !*** ./src/game/Bullet.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var GameMgr_1 = __webpack_require__(/*! ../Mgr/GameMgr */ "./src/Mgr/GameMgr.ts");
var MoveObject_1 = __webpack_require__(/*! ./MoveObject */ "./src/game/MoveObject.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Collider_1 = __webpack_require__(/*! ./Collider */ "./src/game/Collider.ts");
var bulletSpeedValue = 20;
var frameCountThatBulletsMoveInX = 4;
var Bullet = (function (_super) {
    __extends(Bullet, _super);
    function Bullet() {
        var _this = _super.call(this) || this;
        _this.power = 1;
        _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("bullet.png")));
        var collider = _this.addComponent(Collider_1.PointCollider);
        collider.group = Collider_1.ColliderGroup.Bullet;
        collider.setData(2, 0);
        _this.physics.velocity.y = -bulletSpeedValue;
        return _this;
    }
    Bullet.prototype.init = function (power) {
        this.power = power;
        return this;
    };
    Bullet.prototype.onElementInit = function () {
        this.enableAllComponents();
        this.visible = true;
    };
    Bullet.prototype.onElementRecycle = function () {
        this.disableAllComponents();
        this.visible = false;
    };
    Bullet.prototype.onCollisionEnter = function (other) {
        if (other.group == Collider_1.ColliderGroup.Ball || other.group == Collider_1.ColliderGroup.Top) {
            DataMgr_1.DataMgr.game._pool.bullet.recycle(this);
        }
    };
    return Bullet;
}(MoveObject_1.default));
exports.default = Bullet;
var BulletGroup = (function () {
    function BulletGroup(position, rowBulletNum) {
        this.moveDatas = [];
        this.restFrameCountThatBulletsMoveInX = frameCountThatBulletsMoveInX;
        for (var i = 0; i < rowBulletNum; i++) {
            var bullet = DataMgr_1.DataMgr.game._pool.bullet.spwan().init(Math.floor(DataMgr_1.DataMgr.game.powerScore / 100));
            bullet.x = position.x - bullet.width / 2;
            bullet.y = position.y + bullet.height / 2;
            var frameOffset = ((i - (rowBulletNum - 1) / 2) * (bullet.width + 3)) / frameCountThatBulletsMoveInX;
            this.moveDatas.push({
                bullet: bullet,
                frameOffset: frameOffset,
            });
        }
        DataMgr_1.DataMgr.game._horizontalMoveMgr.movingList.push(this);
    }
    BulletGroup.prototype.onUpdate = function () {
        var data = null;
        for (var i = 0; i < this.moveDatas.length; i++) {
            data = this.moveDatas[i];
            data.bullet.x += data.frameOffset;
        }
        this.restFrameCountThatBulletsMoveInX--;
    };
    return BulletGroup;
}());
exports.BulletGroup = BulletGroup;
var HorizontalMoveMgr = (function (_super) {
    __extends(HorizontalMoveMgr, _super);
    function HorizontalMoveMgr() {
        var _this = _super.call(this, "HorizontalMoveMgr") || this;
        _this.movingList = [];
        return _this;
    }
    HorizontalMoveMgr.prototype.onUpdate = function () {
        if (this.pause)
            return;
        for (var i = 0; i < this.movingList.length; i++) {
            this.movingList[i].onUpdate();
        }
        this.movingList = this.movingList.filter(function (e) { return e.restFrameCountThatBulletsMoveInX > 0; });
    };
    return HorizontalMoveMgr;
}(GameMgr_1.default));
exports.HorizontalMoveMgr = HorizontalMoveMgr;


/***/ }),

/***/ "./src/game/Car.ts":
/*!*************************!*\
  !*** ./src/game/Car.ts ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameObject_1 = __webpack_require__(/*! ./GameObject */ "./src/game/GameObject.ts");
var Collider_1 = __webpack_require__(/*! ./Collider */ "./src/game/Collider.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var MConst_1 = __webpack_require__(/*! ../Global/MConst */ "./src/Global/MConst.ts");
var MTimer_1 = __webpack_require__(/*! ../Global/MTimer */ "./src/Global/MTimer.ts");
var Bullet_1 = __webpack_require__(/*! ./Bullet */ "./src/game/Bullet.ts");
var Car = (function (_super) {
    __extends(Car, _super);
    function Car() {
        var _this = _super.call(this) || this;
        _this.imgParticel = null;
        _this.fireTimer = null;
        _this.touchWall = 0;
        _this.isDied = false;
        _this.fireParticleTimer = 0;
        _this.invincible = false;
        _this.rowBulletNum = 1;
        _this.fireSpeed = MConst_1.MConst.BulletFireSpeed.min;
        _this.globalcarCollidePaddingX = 29;
        _this.globalcarCollidePaddingY = 20;
        var carCollidePaddingX = _this.globalcarCollidePaddingX, carCollidePaddingY = _this.globalcarCollidePaddingY;
        var sprite = new FYGE.Sprite(RES_1.RES.getRes("car.png"));
        sprite.x = 0;
        sprite.y = 16;
        _this.addChild(sprite);
        var particle = new FYGE.Sprite(RES_1.RES.getRes("car_particle.png"));
        particle.x = (sprite.width - particle.width) / 2;
        particle.y = 0;
        _this.addChild(particle);
        _this.imgParticel = particle;
        MTimer_1.default.onFrame("Car", _this.onUpdate, _this);
        var collider = _this.collider = _this.addComponent(Collider_1.RectCollider);
        collider.setData(carCollidePaddingX, carCollidePaddingY, sprite.width - carCollidePaddingX * 2, sprite.height - carCollidePaddingY * 2);
        collider.group = Collider_1.ColliderGroup.Car;
        return _this;
    }
    Car.prototype.fire = function () {
        new Bullet_1.BulletGroup(new FYGE.Point(this.x + this.width / 2, this.y), this.rowBulletNum);
    };
    Car.prototype.die = function () {
        if (this.invincible)
            return;
        if (this.isDied)
            return;
        this.isDied = true;
        this.onDied && this.onDied();
    };
    Car.prototype.onCollisionEnter = function (other) {
        if (other.group == Collider_1.ColliderGroup.Ball) {
            this.die();
        }
        if (other.group == Collider_1.ColliderGroup.Wall) {
            this.touchWall = other.owner.x < 0 ? 1 : -1;
        }
    };
    Car.prototype.onCollisionStay = function (other) {
        if (other.group == Collider_1.ColliderGroup.Ball) {
            this.die();
        }
        if (other.group == Collider_1.ColliderGroup.Wall) {
            this.touchWall = other.owner.x < 0 ? 1 : -1;
        }
    };
    Car.prototype.onceBlink = function () {
        var _this = this;
        FYGE.Tween.get(this)
            .to({ alpha: 0 }, 1)
            .wait(100)
            .to({ alpha: 1 }, 1)
            .wait(100)
            .call(function () {
            _this.onceBlink();
        });
    };
    Car.prototype.revive = function () {
        var _this = this;
        this.invincible = true;
        this.isDied = false;
        FYGE.Tween.removeTweens(this);
        this.onceBlink();
        MTimer_1.default.setFrameTimer(MConst_1.MConst.ReviveInvincibleDuration * 60, function () {
            _this.invincible = false;
            _this.alpha = 1;
            FYGE.Tween.removeTweens(_this);
        });
    };
    Car.prototype.move = function (deltaX) {
        if (this.touchWall == 1 && deltaX <= 0) {
            return;
        }
        else if (this.touchWall == -1 && deltaX >= 0) {
            return;
        }
        var carCollidePaddingX = this.globalcarCollidePaddingX;
        var _a = this.collider.rect, x = _a.x, width = _a.width;
        this.x = Math.max(-x, Math.min(750 - width - carCollidePaddingX, this.x + deltaX));
    };
    Car.prototype.onCollisionExit = function (other) {
        if (other.group == Collider_1.ColliderGroup.Wall) {
            this.touchWall = 0;
        }
    };
    Car.prototype.onUpdate = function () {
        if (DataMgr_1.DataMgr.game.pause)
            return;
        var score = DataMgr_1.DataMgr.game.bulletScore;
        if (score <= 20) {
            var max = MConst_1.MConst.BulletFireSpeed.max;
            var min = MConst_1.MConst.BulletFireSpeed.min;
            this.fireSpeed = min + (max - min) * (score / 20);
        }
        else {
            this.fireSpeed = MConst_1.MConst.BulletFireSpeed.max;
        }
        this.rowBulletNum = Math.ceil((this.clamp(score, 15, 140) / 2) / 10);
        this.fireTimer += 1 * MTimer_1.default.dtFactor;
        if (this.fireTimer >= 60 / this.fireSpeed) {
            this.fire();
            this.fireTimer = 0;
        }
        if (this.fireParticleTimer % 3 == 0) {
            this.imgParticel.visible = !this.imgParticel.visible;
        }
        this.fireParticleTimer++;
    };
    Car.prototype.clamp = function (v, min, max) {
        return v >= min && v <= max ? v : (v < min ? min : max);
    };
    return Car;
}(GameObject_1.default));
exports.default = Car;


/***/ }),

/***/ "./src/game/Collider.ts":
/*!******************************!*\
  !*** ./src/game/Collider.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameComponent_1 = __webpack_require__(/*! ../Game/GameComponent */ "./src/Game/GameComponent.ts");
var Physics_1 = __webpack_require__(/*! ./Physics */ "./src/game/Physics.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var Collider = (function (_super) {
    __extends(Collider, _super);
    function Collider() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.physics = null;
        _this._group = null;
        _this.type = null;
        _this.worldPos = new FYGE.Point();
        return _this;
    }
    Object.defineProperty(Collider.prototype, "group", {
        get: function () {
            return this._group;
        },
        set: function (group) {
            if (this._group == null) {
                this._group = group;
                DataMgr_1.DataMgr.game._phycicsSystem.addCollider(this);
            }
            else {
                this._group = group;
            }
        },
        enumerable: true,
        configurable: true
    });
    Collider.prototype.setData = function () {
        var ags = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            ags[_i] = arguments[_i];
        }
        this.physics && this.physics.onColliderResize(this);
    };
    Collider.prototype.onEnabled = function () {
        if (this.group)
            DataMgr_1.DataMgr.game._phycicsSystem.addCollider(this);
        var physics = this.owner.getComponent(Physics_1.default);
        if (physics) {
            this.physics = physics;
            physics.collider = this;
        }
    };
    Collider.prototype.onDisabled = function () {
        DataMgr_1.DataMgr.game._phycicsSystem.removeCollider(this);
    };
    return Collider;
}(GameComponent_1.default));
exports.default = Collider;
var CircleCollider = (function (_super) {
    __extends(CircleCollider, _super);
    function CircleCollider(owner) {
        var _this = _super.call(this, owner) || this;
        _this.radius = 0;
        _this.center = [];
        _this.t = {
            x: 0,
            y: 0
        };
        _this.type = ColliderType.Circle;
        return _this;
    }
    CircleCollider.prototype.setData = function (x, y, radius) {
        this.radius = radius;
        this.center[0] = x;
        this.center[1] = y;
        _super.prototype.setData.call(this);
    };
    CircleCollider.prototype.getCenter = function () {
        return this.center;
    };
    CircleCollider.prototype.getWorldPosition = function (out) {
        out[0] = this.owner.x + this.center[0];
        out[1] = this.owner.y + this.center[1];
    };
    return CircleCollider;
}(Collider));
exports.CircleCollider = CircleCollider;
var RectCollider = (function (_super) {
    __extends(RectCollider, _super);
    function RectCollider(owner) {
        var _this = _super.call(this, owner) || this;
        _this.rect = new FYGE.Rectangle();
        _this.type = ColliderType.Rect;
        return _this;
    }
    RectCollider.prototype.setData = function (x, y, width, height) {
        this.rect.x = x;
        this.rect.y = y;
        this.rect.width = width;
        this.rect.height = height;
        _super.prototype.setData.call(this);
    };
    RectCollider.prototype.getCenter = function () {
        return [this.rect.x + this.rect.width / 2, this.rect.y + this.rect.height / 2];
    };
    RectCollider.prototype.getWorldPosition = function (out) {
        out[0] = this.owner.x + this.rect.left;
        out[1] = this.owner.y + this.rect.top;
    };
    return RectCollider;
}(Collider));
exports.RectCollider = RectCollider;
var PointCollider = (function (_super) {
    __extends(PointCollider, _super);
    function PointCollider(owner) {
        var _this = _super.call(this, owner) || this;
        _this.center = [];
        _this.type = ColliderType.Point;
        return _this;
    }
    PointCollider.prototype.setData = function (x, y) {
        this.center[0] = x;
        this.center[1] = y;
        _super.prototype.setData.call(this);
    };
    PointCollider.prototype.getCenter = function () {
        return this.center;
    };
    PointCollider.prototype.getWorldPosition = function (out) {
        var owner = this.owner;
        out[0] = this.owner.x + this.center[0];
        out[1] = this.owner.y + this.center[1];
    };
    return PointCollider;
}(Collider));
exports.PointCollider = PointCollider;
var ColliderGroup;
(function (ColliderGroup) {
    ColliderGroup[ColliderGroup["None"] = 0] = "None";
    ColliderGroup[ColliderGroup["Ball"] = 1] = "Ball";
    ColliderGroup[ColliderGroup["Bullet"] = 2] = "Bullet";
    ColliderGroup[ColliderGroup["Wall"] = 3] = "Wall";
    ColliderGroup[ColliderGroup["Ground"] = 4] = "Ground";
    ColliderGroup[ColliderGroup["Drop"] = 5] = "Drop";
    ColliderGroup[ColliderGroup["Car"] = 6] = "Car";
    ColliderGroup[ColliderGroup["Top"] = 7] = "Top";
})(ColliderGroup = exports.ColliderGroup || (exports.ColliderGroup = {}));
var ColliderType;
(function (ColliderType) {
    ColliderType[ColliderType["Circle"] = 0] = "Circle";
    ColliderType[ColliderType["Rect"] = 1] = "Rect";
    ColliderType[ColliderType["Point"] = 2] = "Point";
})(ColliderType = exports.ColliderType || (exports.ColliderType = {}));


/***/ }),

/***/ "./src/game/Drop.ts":
/*!**************************!*\
  !*** ./src/game/Drop.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MoveObject_1 = __webpack_require__(/*! ./MoveObject */ "./src/game/MoveObject.ts");
var MConfigs_1 = __webpack_require__(/*! ../Global/MConfigs */ "./src/Global/MConfigs.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var Collider_1 = __webpack_require__(/*! ./Collider */ "./src/game/Collider.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var dropImgNames = [
    "drop_1.png",
    "drop_2.png",
    "drop_3.png",
    "drop_4.png",
    "drop_5.png"
];
var Drop = (function (_super) {
    __extends(Drop, _super);
    function Drop(id) {
        var _this = _super.call(this) || this;
        _this.type = null;
        _this.label = null;
        _this.bitmap = null;
        _this.scoreValue = null;
        _this.collider = null;
        _this.isGround = false;
        _this.stayGroundCount = 0;
        _this.id = null;
        _this.id = id;
        var bitmap = new FYGE.Sprite();
        _this.addChild(bitmap);
        _this.bitmap = bitmap;
        var label = new FYGE.TextField();
        label.size = 24;
        _this.addChild(label);
        _this.label = label;
        _this.collider = _this.addComponent(Collider_1.PointCollider);
        _this.collider.group = Collider_1.ColliderGroup.Drop;
        var config = MConfigs_1.MConfigs.drop[id];
        _this.type = config.type;
        _this.scoreValue = config.value;
        _this.physics.acceleration.y = 0.3;
        var texture = RES_1.RES.getRes(dropImgNames[id]);
        _this.bitmap.texture = texture;
        var str = "+" + config.value;
        if (config.type == "power")
            str = str + "%";
        label.text = str;
        label.fillColor = config.textColor + "";
        label.visible = false;
        label.x = texture.width + 2;
        label.y = texture.height / 2 - label.height / 2;
        _this.collider.setData(texture.width / 2, texture.height / 2);
        return _this;
    }
    Drop.prototype.eated = function () {
        var _this = this;
        this.physics.rotateVelocity = 0;
        DataMgr_1.DataMgr.game._dropBlinkMgr.remove(this);
        this.visible = true;
        this.rotation = 0;
        this.physics.enabled = false;
        this.getComponent(Collider_1.PointCollider).enabled = false;
        this.label.visible = true;
        if (this.type == "bullet") {
            DataMgr_1.DataMgr.game._BulletScore += this.scoreValue;
        }
        else if (this.type == "power") {
            DataMgr_1.DataMgr.game._PowerScore += this.scoreValue;
        }
        FYGE.Tween.removeTweens(this);
        FYGE.Tween.get(this)
            .to({ y: this.y - 200, alpha: 0 }, 1000)
            .call(function () {
            DataMgr_1.DataMgr.game._pool.drop.recycle(_this.id.toString(), _this);
            FYGE.Tween.removeTweens(_this);
        });
    };
    Drop.prototype.onCollisionEnter = function (other) {
        if (other.group == Collider_1.ColliderGroup.Car) {
            this.eated();
        }
        if (other.group == Collider_1.ColliderGroup.Ground && !this.isGround) {
            this.stayGroundCount = 0;
            this.physics.velocity.y = -(this.physics.velocity.y * 0.4);
        }
        if (other.group == Collider_1.ColliderGroup.Wall) {
            this.physics.velocity.x = -this.physics.velocity.x;
            if (this.isGround) {
                this.physics.rotateVelocity = -this.physics.rotateVelocity;
            }
        }
    };
    Drop.prototype.onCollisionStay = function (other) {
        if (other.group == Collider_1.ColliderGroup.Ground && !this.isGround) {
            this.stayGroundCount++;
            if (this.stayGroundCount > 2) {
                this.isGround = true;
                this.physics.velocity.y = 0;
                this.physics.acceleration.y = 0;
                this.physics.velocity.x *= 0.5;
                DataMgr_1.DataMgr.game._dropBlinkMgr.add(this);
                this.physics.rotateVelocity = this.physics.velocity.x * (180 / (Math.PI * 13));
            }
        }
    };
    Drop.prototype.onCollisionExit = function (other) {
        if (other.group == Collider_1.ColliderGroup.Ground) {
            this.stayGroundCount = 0;
        }
    };
    Drop.prototype.onElementInit = function () {
        this.visible = true;
        this.stayGroundCount = 0;
        this.isGround = false;
        this.enableAllComponents();
        this.label.visible = false;
        this.physics.acceleration.y = 0.3;
    };
    Drop.prototype.onElementRecycle = function () {
        this.alpha = 1;
        this.visible = false;
        this.disableAllComponents();
    };
    return Drop;
}(MoveObject_1.default));
exports.default = Drop;


/***/ }),

/***/ "./src/game/DxqPlayScene.ts":
/*!**********************************!*\
  !*** ./src/game/DxqPlayScene.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MTimer_1 = __webpack_require__(/*! ../Global/MTimer */ "./src/Global/MTimer.ts");
var PhycicsSystem_1 = __webpack_require__(/*! ./PhycicsSystem */ "./src/game/PhycicsSystem.ts");
var SpBoomEffect_1 = __webpack_require__(/*! ./SpBoomEffect */ "./src/game/SpBoomEffect.ts");
var FrameAnimation_1 = __webpack_require__(/*! ../component/FrameAnimation */ "./src/component/FrameAnimation.ts");
var Bullet_1 = __webpack_require__(/*! ./Bullet */ "./src/game/Bullet.ts");
var MConst_1 = __webpack_require__(/*! ../Global/MConst */ "./src/Global/MConst.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var GuideMgr_1 = __webpack_require__(/*! ../Mgr/GuideMgr */ "./src/Mgr/GuideMgr.ts");
var Physics_1 = __webpack_require__(/*! ./Physics */ "./src/game/Physics.ts");
var Car_1 = __webpack_require__(/*! ./Car */ "./src/game/Car.ts");
var PlayerController_1 = __webpack_require__(/*! ./PlayerController */ "./src/game/PlayerController.ts");
var GameObject_1 = __webpack_require__(/*! ./GameObject */ "./src/game/GameObject.ts");
var Collider_1 = __webpack_require__(/*! ./Collider */ "./src/game/Collider.ts");
var MConfigs_1 = __webpack_require__(/*! ../Global/MConfigs */ "./src/Global/MConfigs.ts");
var MUtils_1 = __webpack_require__(/*! ../Global/MUtils */ "./src/Global/MUtils.ts");
var GUtils_1 = __webpack_require__(/*! ../Global/GUtils */ "./src/Global/GUtils.ts");
var BallPool_1 = __webpack_require__(/*! ../Pools/BallPool */ "./src/Pools/BallPool.ts");
var BulletPool_1 = __webpack_require__(/*! ../Pools/BulletPool */ "./src/Pools/BulletPool.ts");
var AnimationPool_1 = __webpack_require__(/*! ../Pools/AnimationPool */ "./src/Pools/AnimationPool.ts");
var DropPool_1 = __webpack_require__(/*! ../Pools/DropPool */ "./src/Pools/DropPool.ts");
var DropBlinkMgr_1 = __webpack_require__(/*! ../Mgr/DropBlinkMgr */ "./src/Mgr/DropBlinkMgr.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var DxqPlayScene = (function (_super) {
    __extends(DxqPlayScene, _super);
    function DxqPlayScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._pause = false;
        _this._updateData = {};
        _this.mgrs = [];
        _this._phycicsSystem = new PhycicsSystem_1.default();
        _this._boomEffectMgr = new SpBoomEffect_1.SpBoomEffectMgr();
        _this._animationMgr = new FrameAnimation_1.FrameAnimationMgr();
        _this._horizontalMoveMgr = new Bullet_1.HorizontalMoveMgr();
        _this.needSubmitCount = 0;
        _this._localScore = 0;
        _this._pool = null;
        _this._dropBlinkMgr = new DropBlinkMgr_1.default();
        _this.layers = {
            bullet: new FYGE.Container(),
            ball: new FYGE.Container(),
            drop: new FYGE.Container(),
            effect: new FYGE.Container(),
            animation: new FYGE.Container()
        };
        _this._car = null;
        _this.__score = 0;
        _this.curMaxBallNum = 1;
        _this.timing = false;
        _this.createBallCD = 0;
        _this.bulletScoreUpdateFlag = false;
        _this._ballList = [];
        _this.node = new FYGE.Container();
        _this._bulletScore = 0;
        _this._powerScore = 100;
        return _this;
    }
    Object.defineProperty(DxqPlayScene.prototype, "groupNames", {
        get: function () { return ["dxqPlayScene"]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxqPlayScene.prototype, "score", {
        get: function () {
            return this._score;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxqPlayScene.prototype, "bulletScore", {
        get: function () {
            return this._bulletScore;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxqPlayScene.prototype, "powerScore", {
        get: function () {
            return this._powerScore;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxqPlayScene.prototype, "pause", {
        get: function () {
            return this._pause;
        },
        set: function (v) {
            this._pause = v;
            this.timing = !this._pause;
            for (var _i = 0, _a = this.mgrs; _i < _a.length; _i++) {
                var mgr = _a[_i];
                mgr.pause = this._pause;
            }
        },
        enumerable: true,
        configurable: true
    });
    DxqPlayScene.prototype.revive = function () {
        this._car.revive();
        this.pause = false;
    };
    DxqPlayScene.prototype.destroy = function () {
        this.node.dispose();
        for (var _i = 0, _a = this.mgrs; _i < _a.length; _i++) {
            var mgr = _a[_i];
            mgr.onDestroy();
        }
        MTimer_1.default.removeOnFrame("Game");
        MTimer_1.default.removeOnFrame("Car");
    };
    Object.defineProperty(DxqPlayScene.prototype, "localScore", {
        get: function () {
            return this._localScore;
        },
        set: function (v) {
            this._localScore = v;
            if (this._localScore >= MConst_1.MConst.ConstantSubmitScoreNum) {
                var count = Math.floor(this._localScore / MConst_1.MConst.ConstantSubmitScoreNum);
                this.needSubmitCount += count;
                this._localScore -= MConst_1.MConst.ConstantSubmitScoreNum * count;
            }
        },
        enumerable: true,
        configurable: true
    });
    DxqPlayScene.prototype.loadRes = function () {
    };
    DxqPlayScene.prototype.initMgrs = function () {
        this.mgrs = [
            this._dropBlinkMgr,
            this._phycicsSystem,
            this._boomEffectMgr,
            this._animationMgr,
            this._horizontalMoveMgr
        ];
        for (var _i = 0, _a = this.mgrs; _i < _a.length; _i++) {
            var mgr = _a[_i];
            mgr.onInit();
        }
    };
    DxqPlayScene.prototype.customProperty = function () {
        Object.defineProperty(FYGE.Point.prototype, 'length', {
            get: function () {
                return Math.sqrt(this.x * this.x + this.y * this.y);
            }
        });
        FYGE.DisplayObject.prototype.dispose = function () {
            this.parent.removeChild(this);
        };
    };
    DxqPlayScene.prototype.initUi = function () {
        var _this = this;
        console.log("aasd");
        this.customProperty();
        MTimer_1.default.init();
        DataMgr_1.DataMgr.game = this;
        this.initMgrs();
        this.pause = false;
        this.loadRes();
        console.log("qwwee");
        this.addChild(this.node);
        GuideMgr_1.default.instance.container = this;
        this.node.width = MConst_1.MConst.DesignResolution.width;
        this.node.height = MConst_1.MConst.DesignResolution.height;
        var bg = new FYGE.Sprite(RES_1.RES.getRes("main_bg.jpg"));
        this.node.addChild(bg);
        this.node.addChild(this.layers.bullet);
        this.layers.bullet.x = 0;
        this.layers.bullet.y = 0;
        this.layers.animation.width = this.layers.effect.width = this.layers.drop.width = this.layers.bullet.width = MConst_1.MConst.DesignResolution.width;
        this.layers.animation.height = this.layers.effect.height = this.layers.drop.height = this.layers.bullet.height = MConst_1.MConst.DesignResolution.height;
        var car = new Car_1.default();
        car.x = this.node.width / 2 - car.width / 2;
        car.y = MConst_1.MConst.GroundLine - car.height + 30;
        this.node.addChild(car);
        car.addComponent(Physics_1.default);
        car.onDied = function () {
            _this.over();
        };
        this._car = car;
        this.node.addChild(this.layers.ball);
        this.node.addChild(this.layers.drop);
        this.node.addChild(this.layers.effect);
        this.node.addChild(this.layers.animation);
        for (var k in this.layers) {
            this.layers[k].mouseChildren = false;
            this.layers[k].mouseEnabled = false;
        }
        var playerController = new PlayerController_1.default();
        playerController.onTouchMove = function (deltaX) {
            if (!_this.pause) {
                car.move(deltaX);
            }
        };
        this.node.addChild(playerController);
        MTimer_1.default.onFrame("Game", this.onUpdate, this);
        this.createPools();
        this.createWall();
        this.timing = true;
        console.log("asdqwee");
    };
    DxqPlayScene.prototype.over = function () {
        var _this = this;
        this.pause = true;
        FYGE.GDispatcher.dispatchEvent("game-over", this._updateData);
        this.onGameOver && this.onGameOver();
        console.log(this.score);
        setTimeout(function () {
            _this.revive();
        }, 300);
    };
    DxqPlayScene.prototype.createWall = function () {
        var topWall = new GameObject_1.default();
        topWall.x = -500;
        topWall.y = -500;
        this.node.addChild(topWall);
        var topWallCollider = topWall.addComponent(Collider_1.RectCollider);
        topWallCollider.setData(0, 0, MConst_1.MConst.DesignResolution.width + 1000, 490);
        topWallCollider.group = Collider_1.ColliderGroup.Top;
        var ground = new GameObject_1.default();
        ground.x = -500;
        ground.y = MConst_1.MConst.GroundLine;
        this.node.addChild(ground);
        var groundCollider = ground.addComponent(Collider_1.RectCollider);
        groundCollider.setData(0, 0, MConst_1.MConst.DesignResolution.width + 1000, 1000);
        groundCollider.group = Collider_1.ColliderGroup.Ground;
        var leftWall = new GameObject_1.default();
        leftWall.x = -500;
        leftWall.y = -500;
        this.node.addChild(leftWall);
        var leftWallCollider = leftWall.addComponent(Collider_1.RectCollider);
        leftWallCollider.setData(0, 0, 500, MConst_1.MConst.DesignResolution.height + 1000);
        leftWallCollider.group = Collider_1.ColliderGroup.Wall;
        var rightWall = new GameObject_1.default();
        rightWall.x = MConst_1.MConst.DesignResolution.width;
        rightWall.y = -500;
        this.node.addChild(rightWall);
        var rightWallCollider = rightWall.addComponent(Collider_1.RectCollider);
        rightWallCollider.setData(0, 0, 500, MConst_1.MConst.DesignResolution.height + 1000);
        rightWallCollider.group = Collider_1.ColliderGroup.Wall;
    };
    DxqPlayScene.prototype.createBall = function () {
        var size = MUtils_1.MUtils.randomInt(0, MConfigs_1.MConfigs.size.length);
        if (GuideMgr_1.default.instance.guideFlag == true) {
            size = 3;
        }
        var color = MUtils_1.MUtils.randomInt(size, MConst_1.MConst.MaxColorIndex);
        var ball = this._pool.ball.spwan(size);
        var dir = Math.random() > 0.5 ? -1 : 1;
        var score = GUtils_1.getBallScore(this._BulletScore, this._PowerScore, color);
        ball.init(color, dir, score);
        ball.startBornStage(dir);
        this.createBallCD = 1500;
    };
    DxqPlayScene.prototype.onUpdate = function () {
        for (var i = 0; i < this._ballList.length; i++) {
            this._ballList[i].updateScoreLabel();
        }
        if (this.bulletScoreUpdateFlag) {
            var score = this._BulletScore;
            this.updateMaxBallNum(score);
            this.bulletScoreUpdateFlag = false;
        }
        if (this.createBallCD > 0) {
            this.createBallCD -= MTimer_1.default.deltaTime;
        }
        if (this._ballList.length < this.curMaxBallNum) {
            if (this.createBallCD <= 0) {
                this.createBall();
            }
        }
        if (!this.pause) {
            this.outputEvent();
        }
    };
    DxqPlayScene.prototype.outputEvent = function () {
        var updateData = {
            score: this.score,
            bulletScore: this.bulletScore,
            powerScore: this.powerScore,
        };
        var needSend = false;
        for (var key in updateData) {
            if (updateData[key] != this._updateData[key]) {
                this._updateData[key] = updateData[key];
                needSend = true;
            }
        }
        if (needSend) {
            FYGE.GDispatcher.dispatchEvent("game-update", updateData);
        }
    };
    DxqPlayScene.prototype.updateMaxBallNum = function (bulletScore) {
        var num = 0;
        if (bulletScore <= 20)
            num = 1;
        else if (bulletScore <= 60)
            num = 2;
        else if (bulletScore <= 100)
            num = 3;
        else if (bulletScore <= 130)
            num = 4;
        else if (Math.random() < 0.3)
            num = 6;
        else
            num = 7;
        this.curMaxBallNum = num;
    };
    DxqPlayScene.prototype._shake = function () {
        var _this = this;
        var count = 0;
        var callback = function () {
            if (count > 1)
                return;
            count++;
            _this.node.x = 10;
            FYGE.Tween.get(_this.node)
                .wait(1, true)
                .to({ x: 0, y: -10 }, 1)
                .to({ x: -10, y: 0 }, 1)
                .to({ x: 0, y: 10 }, 1)
                .to({ x: 0, y: 0 }, 1)
                .call(callback);
        };
        callback();
    };
    DxqPlayScene.prototype.createPools = function () {
        this._pool = {
            ball: new BallPool_1.BallPoolGroup(this.layers.ball),
            bullet: new BulletPool_1.BulletPool(this.layers.bullet),
            animation: new AnimationPool_1.default(this.layers.animation),
            boomEffect: new SpBoomEffect_1.default(this.layers.effect),
            drop: new DropPool_1.default(this.layers.drop)
        };
    };
    DxqPlayScene.prototype._playBoomEffect = function (position, size) {
        var effect = this._pool.boomEffect.spwan(MUtils_1.MUtils.randomInt(0, 3), size);
        effect.position = position;
    };
    DxqPlayScene.prototype._createAnimation = function (key) {
        var _this = this;
        var clip = this._pool.animation.spwan(key);
        clip.onCompleted = function () {
            _this._pool.animation.recycle(key, clip);
        };
        return clip;
    };
    Object.defineProperty(DxqPlayScene.prototype, "_score", {
        get: function () {
            return this.__score;
        },
        set: function (v) {
            this.localScore += (v - this.__score);
            this.__score = v;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxqPlayScene.prototype, "_BulletScore", {
        get: function () {
            return this._bulletScore;
        },
        set: function (v) {
            if (v == this._bulletScore)
                return;
            v = Math.max(v, 0);
            this._bulletScore = v;
            this.bulletScoreUpdateFlag = true;
        },
        enumerable: true,
        configurable: true
    });
    DxqPlayScene.prototype.onGuideDone = function () {
        FYGE.GDispatcher.dispatchEvent('game-start');
    };
    Object.defineProperty(DxqPlayScene.prototype, "_PowerScore", {
        get: function () {
            return this._powerScore;
        },
        set: function (v) {
            v = Math.max(v, 100);
            this._powerScore = v;
        },
        enumerable: true,
        configurable: true
    });
    return DxqPlayScene;
}(Scene_1.Scene));
exports.default = DxqPlayScene;


/***/ }),

/***/ "./src/game/GameObject.ts":
/*!********************************!*\
  !*** ./src/game/GameObject.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameObject = (function (_super) {
    __extends(GameObject, _super);
    function GameObject() {
        var _this = _super.call(this) || this;
        _this.name = "";
        _this._anchorOffsetX = 0;
        _this._anchorOffsetY = 0;
        _this.componentList = [];
        _this.mouseEnable = false;
        _this.mouseChildren = false;
        return _this;
    }
    GameObject.prototype.addComponent = function (cls) {
        if (this.getComponent(cls) != null) {
            console.error("component is existent");
            return;
        }
        var ins = new cls(this);
        ins.enabled = true;
        this.componentList.push(ins);
        return ins;
    };
    GameObject.prototype.getComponent = function (cls) {
        for (var _i = 0, _a = this.componentList; _i < _a.length; _i++) {
            var i = _a[_i];
            if (i instanceof cls) {
                return i;
            }
        }
        return null;
    };
    GameObject.prototype.removeComponent = function (cls) {
        var _loop_1 = function (i) {
            if (i instanceof cls) {
                i.enabled = false;
                this_1.componentList = this_1.componentList.filter(function (e) { return e != i; });
                return { value: void 0 };
            }
        };
        var this_1 = this;
        for (var _i = 0, _a = this.componentList; _i < _a.length; _i++) {
            var i = _a[_i];
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
    };
    Object.defineProperty(GameObject.prototype, "anchorOffsetX", {
        get: function () {
            return this._anchorOffsetX;
        },
        set: function (v) {
            this._anchorOffsetX = v;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GameObject.prototype, "anchorOffsetY", {
        get: function () {
            return this._anchorOffsetY;
        },
        set: function (v) {
            this._anchorOffsetY = v;
        },
        enumerable: true,
        configurable: true
    });
    GameObject.prototype.dispose = function () {
        this.destroy();
        this.disableAllComponents();
    };
    GameObject.prototype.disableAllComponents = function () {
        var _this = this;
        Object.keys(this.componentList).forEach(function (e) { return _this.componentList[e].enabled = false; });
    };
    GameObject.prototype.enableAllComponents = function () {
        var _this = this;
        Object.keys(this.componentList).forEach(function (e) { return _this.componentList[e].enabled = true; });
    };
    GameObject.prototype.onCollisionEnter = function (other) {
    };
    GameObject.prototype.onCollisionStay = function (other) {
    };
    GameObject.prototype.onCollisionExit = function (other) {
    };
    return GameObject;
}(FYGE.Container));
exports.default = GameObject;


/***/ }),

/***/ "./src/game/GuideMask.ts":
/*!*******************************!*\
  !*** ./src/game/GuideMask.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MConfigs_1 = __webpack_require__(/*! ../Global/MConfigs */ "./src/Global/MConfigs.ts");
var MConst_1 = __webpack_require__(/*! ../Global/MConst */ "./src/Global/MConst.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var padding = 10;
var GuideMask = (function (_super) {
    __extends(GuideMask, _super);
    function GuideMask(index, x1, y1) {
        var _this = _super.call(this) || this;
        var config = MConfigs_1.MConfigs.guide[index];
        var mask = new FYGE.Sprite(RES_1.RES.getRes("mask.png"));
        var w = mask.width, h = mask.height;
        x1 = Math.floor(x1);
        y1 = Math.floor(y1);
        var x = x1 - w / 2;
        var y = y1 - h / 2;
        mask.x = x;
        mask.y = y;
        _this.addChild(mask);
        var sw = MConst_1.MConst.DesignResolution.width, sh = MConst_1.MConst.DesignResolution.height;
        var color = 0x000000;
        var alpha = 0.7;
        var top = new FYGE.Graphics();
        top.beginFill(color, alpha);
        top.drawRect(0, -sh, sw, y + sh);
        top.endFill();
        _this.addChild(top);
        var bottom = new FYGE.Graphics();
        bottom.beginFill(color, alpha);
        bottom.drawRect(x, y + h, w, sh - h - y);
        bottom.endFill();
        _this.addChild(bottom);
        var left = new FYGE.Graphics();
        left.beginFill(color, alpha);
        left.drawRect(0, y, x, sh - y);
        left.endFill();
        _this.addChild(left);
        var right = new FYGE.Graphics();
        right.beginFill(color, alpha);
        right.drawRect(x + w, y, sw - x - w, sh - y);
        right.endFill();
        _this.addChild(right);
        var offsetToMask = config.text.offsetToMask;
        var label = new FYGE.TextField();
        label.text = MConfigs_1.MConfigs.guide[index].text.str;
        label.size = 24;
        label.fillColor = "rgba(255,255,255,1)";
        label.x = mask.x + (w - label.width) / 2;
        label.y = offsetToMask.y + mask.y;
        _this.addChild(label);
        if (index == 0) {
            var left_1 = new FYGE.Sprite(RES_1.RES.getRes(MConfigs_1.MConfigs.guide[0].mask));
            left_1.x = x1 + 200;
            left_1.y = y1 - left_1.height / 2;
            _this.addChild(left_1);
            var right_1 = new FYGE.Sprite(RES_1.RES.getRes(MConfigs_1.MConfigs.guide[0].mask));
            right_1.x = x1 - 200;
            right_1.scaleX = -1;
            right_1.y = y1 - right_1.height / 2;
            _this.addChild(right_1);
        }
        if (label.x < padding) {
            label.x = padding;
        }
        else if (label.x + label.width > 750 - padding) {
            label.x = 750 - label.width - padding;
        }
        _this.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, function () {
            _this.onClick && _this.onClick(_this);
        }, _this);
        return _this;
    }
    return GuideMask;
}(FYGE.Container));
exports.default = GuideMask;


/***/ }),

/***/ "./src/game/MoveObject.ts":
/*!********************************!*\
  !*** ./src/game/MoveObject.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameObject_1 = __webpack_require__(/*! ./GameObject */ "./src/game/GameObject.ts");
var Physics_1 = __webpack_require__(/*! ./Physics */ "./src/game/Physics.ts");
var MoveObjcet = (function (_super) {
    __extends(MoveObjcet, _super);
    function MoveObjcet() {
        var _this = _super.call(this) || this;
        _this.physics = null;
        _this.physics = _this.addComponent(Physics_1.default);
        return _this;
    }
    return MoveObjcet;
}(GameObject_1.default));
exports.default = MoveObjcet;


/***/ }),

/***/ "./src/game/PhycicsSystem.ts":
/*!***********************************!*\
  !*** ./src/game/PhycicsSystem.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Collider_1 = __webpack_require__(/*! ./Collider */ "./src/game/Collider.ts");
var GUtils_1 = __webpack_require__(/*! ../Global/GUtils */ "./src/Global/GUtils.ts");
var MTimer_1 = __webpack_require__(/*! ../Global/MTimer */ "./src/Global/MTimer.ts");
var GameMgr_1 = __webpack_require__(/*! ../Mgr/GameMgr */ "./src/Mgr/GameMgr.ts");
var DebugMgr_1 = __webpack_require__(/*! ../Mgr/DebugMgr */ "./src/Mgr/DebugMgr.ts");
var instanceId1 = null;
var instanceId2 = null;
var PhycicsSystem = (function (_super) {
    __extends(PhycicsSystem, _super);
    function PhycicsSystem() {
        var _this = _super.call(this, "PhycicsSystem") || this;
        _this.phycicsList = [];
        _this.colliderList = [];
        _this.collisions = [];
        return _this;
    }
    PhycicsSystem.prototype.onInit = function () {
        _super.prototype.onInit.call(this);
        for (var i = 0; i <= GroupMaxIndex; i++) {
            this.colliderList[i] = [];
        }
    };
    PhycicsSystem.prototype.onDestroy = function () {
        _super.prototype.onDestroy.call(this);
        for (var i = 0; i <= GroupMaxIndex; i++) {
            this.colliderList[i] = [];
        }
        this.phycicsList = [];
    };
    PhycicsSystem.prototype.onUpdate = function () {
        if (this.pause)
            return;
        for (var _i = 0, _a = this.phycicsList; _i < _a.length; _i++) {
            var i = _a[_i];
            i.onFixedUpdate(MTimer_1.default.dtFactor);
        }
        this.detectCollision();
        return false;
    };
    PhycicsSystem.prototype.add = function (phycics) {
        this.phycicsList.push(phycics);
    };
    PhycicsSystem.prototype.remove = function (phycics) {
        this.phycicsList = GUtils_1.arrayRemove(this.phycicsList, phycics);
    };
    PhycicsSystem.prototype.getCollisionIndex = function (collider1, collider2) {
        for (var i = 0; i < this.collisions.length; i++) {
            if ((this.collisions[i][0] == collider1 && this.collisions[i][1] == collider2) || (this.collisions[i][0] == collider2 && this.collisions[i][1] == collider1)) {
                return i;
            }
        }
        return -1;
    };
    PhycicsSystem.prototype.addCollider = function (collider) {
        if (typeof this.colliderList[collider.group] == "undefined") {
            this.colliderList[collider.group] = [];
        }
        this.colliderList[collider.group].push(collider);
    };
    PhycicsSystem.prototype.removeCollider = function (collider) {
        this.collisions = this.collisions.filter(function (e) {
            if (e[0] != collider.owner.instanceId && e[1] != collider.owner.instanceId) {
                return true;
            }
            else
                return false;
        });
        this.colliderList[collider.group] = GUtils_1.arrayRemove(this.colliderList[collider.group], collider);
    };
    PhycicsSystem.prototype.detectCollision = function () {
        var i = 0, j = 0, m = 0, n = 0, length = this.colliderList.length, group1 = null, group2 = null;
        for (i = 0; i <= length - 1; i++) {
            for (j = i + 1; j <= length - 1; j++) {
                if (CollisionMap[i] & 1 << j) {
                    group1 = this.colliderList[i];
                    group2 = this.colliderList[j];
                    for (m = 0; m <= group1.length - 1; m++) {
                        for (n = 0; n <= group2.length - 1; n++) {
                            this.detectTraverse(group1[m], group2[n]);
                        }
                    }
                }
            }
        }
    };
    PhycicsSystem.prototype.detectTraverse = function (collider1, collider2) {
        instanceId1 = collider1.owner.instanceId;
        instanceId2 = collider2.owner.instanceId;
        var collisionIndex = this.getCollisionIndex(instanceId1, instanceId2);
        if (callDetectFunc(collider1, collider2)) {
            if (collisionIndex >= 0) {
                collider1.owner.onCollisionStay(collider2);
                collider2.owner.onCollisionStay(collider1);
            }
            else {
                this.collisions.push([instanceId1, instanceId2]);
                collider1.owner.onCollisionEnter(collider2);
                collider2.owner.onCollisionEnter(collider1);
            }
        }
        else {
            if (collisionIndex >= 0) {
                this.collisions.splice(collisionIndex, 1);
                collider1.owner.onCollisionExit(collider2);
                collider2.owner.onCollisionExit(collider1);
            }
        }
    };
    PhycicsSystem.prototype.drawCollider = function (collider) {
        switch (collider.type) {
            case Collider_1.ColliderType.Circle:
                var circleCollider = collider;
                var worldCenter = [];
                collider.getWorldPosition(worldCenter);
                DebugMgr_1.default.instance.updateCircle(collider.owner.instanceId.toString(), worldCenter[0], worldCenter[1], circleCollider.radius);
                break;
            case Collider_1.ColliderType.Rect:
                var rectCollider = collider;
                var worldPos = [];
                rectCollider.getWorldPosition(worldPos);
                DebugMgr_1.default.instance.updateRect(rectCollider.owner.instanceId.toString(), new FYGE.Rectangle(worldPos[0], worldPos[1], rectCollider.rect.width, rectCollider.rect.height));
                break;
        }
    };
    return PhycicsSystem;
}(GameMgr_1.default));
exports.default = PhycicsSystem;
function callDetectFunc(collider1, collider2) {
    if (collider1.type == Collider_1.ColliderType.Circle) {
        if (collider2.type == Collider_1.ColliderType.Circle) {
            return circleToCircle(collider1, collider2);
        }
        else if (collider2.type == Collider_1.ColliderType.Rect) {
            return circleToRect(collider1, collider2);
        }
        else if (collider2.type == Collider_1.ColliderType.Point) {
            return circleToPoint(collider1, collider2);
        }
    }
    else if (collider1.type == Collider_1.ColliderType.Rect) {
        if (collider2.type == Collider_1.ColliderType.Circle) {
            return circleToRect(collider2, collider1);
        }
        else if (collider2.type == Collider_1.ColliderType.Rect) {
            return rectToRect(collider1, collider2);
        }
        else if (collider2.type == Collider_1.ColliderType.Point) {
            return pointToRect(collider2, collider1);
        }
    }
    else if (collider1.type == Collider_1.ColliderType.Point) {
        if (collider2.type == Collider_1.ColliderType.Circle) {
            return circleToPoint(collider2, collider1);
        }
        else if (collider2.type == Collider_1.ColliderType.Rect) {
            return pointToRect(collider1, collider2);
        }
    }
    return false;
}
var tempPoint1 = [];
var tempPoint2 = [];
function distance(p1, p2) {
    return Math.sqrt((p1[0] - p2[0]) * (p1[0] - p2[0]) + (p1[1] - p2[1]) * (p1[1] - p2[1]));
}
function circleToCircle(collider1, collider2) {
    collider1.getWorldPosition(tempPoint1);
    collider2.getWorldPosition(tempPoint2);
    return distance(tempPoint1, tempPoint2) < (collider1.radius + collider2.radius);
}
function circleToRect(circleCollider, rectCollider) {
    circleCollider.getWorldPosition(tempPoint1);
    rectCollider.getWorldPosition(tempPoint2);
    var closestPoint = new FYGE.Point();
    if (tempPoint1[1] < tempPoint2[1]) {
        closestPoint.y = tempPoint2[1];
    }
    else if (tempPoint1[1] > tempPoint2[1] + rectCollider.rect.height) {
        closestPoint.y = tempPoint2[1] + rectCollider.rect.height;
    }
    else {
        closestPoint.y = tempPoint1[1];
    }
    if (tempPoint1[0] < tempPoint2[0]) {
        closestPoint.x = tempPoint2[0];
    }
    else if (tempPoint1[0] > tempPoint2[0] + rectCollider.rect.width) {
        closestPoint.x = tempPoint2[0] + rectCollider.rect.width;
    }
    else {
        closestPoint.x = tempPoint1[0];
    }
    return distance([closestPoint.x, closestPoint.y], tempPoint1) < circleCollider.radius;
}
function rectToRect(collider1, collider2) {
    var rect1 = collider1.rect, rect2 = collider2.rect;
    collider1.getWorldPosition(tempPoint1);
    collider2.getWorldPosition(tempPoint2);
    var rectW1 = tempPoint1[0] + rect1.width, rectW2 = tempPoint2[0] + rect2.width, rectH1 = rect1.height + tempPoint1[1], rectH2 = tempPoint2[1] + rect2.height;
    if (tempPoint1[0] <= rectW2 &&
        rectW1 >= tempPoint2[0] &&
        tempPoint1[1] <= rectH2 &&
        rectH1 >= tempPoint2[1]) {
        return true;
    }
    else
        return false;
}
function circleToPoint(circle, point) {
    circle.getWorldPosition(tempPoint1);
    point.getWorldPosition(tempPoint2);
    if (distance(tempPoint1, tempPoint2) < circle.radius) {
        return true;
    }
    else {
        return false;
    }
}
function pointToRect(point, rect) {
    rect.getWorldPosition(tempPoint1);
    point.getWorldPosition(tempPoint2);
    if (tempPoint2[1] < tempPoint1[1] + rect.rect.height
        && tempPoint2[1] > tempPoint1[1]
        && tempPoint2[0] > tempPoint1[0]
        && tempPoint2[0] < tempPoint1[0] + rect.rect.width) {
        return true;
    }
    else {
        return false;
    }
}
var CollisionMap = {
    0: 0,
    1: 92,
    2: 130,
    3: 98,
    4: 34,
    5: 88,
    6: 42,
    7: 2
};
var GroupMaxIndex = 7;


/***/ }),

/***/ "./src/game/Physics.ts":
/*!*****************************!*\
  !*** ./src/game/Physics.ts ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameComponent_1 = __webpack_require__(/*! ../Game/GameComponent */ "./src/Game/GameComponent.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var Physics = (function (_super) {
    __extends(Physics, _super);
    function Physics() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.rotateVelocity = 0;
        _this.acceleration = new FYGE.Point();
        _this.velocity = new FYGE.Point();
        _this._collider = null;
        return _this;
    }
    Object.defineProperty(Physics.prototype, "collider", {
        get: function () {
            return this._collider;
        },
        set: function (v) {
            this._collider = v;
            v.physics = this;
        },
        enumerable: true,
        configurable: true
    });
    Physics.prototype.onFixedUpdate = function (dtFactor) {
        this.velocity.x += this.acceleration.x * dtFactor;
        this.velocity.y += this.acceleration.y * dtFactor;
        if (Math.sqrt(this.velocity.x * this.velocity.x + this.velocity.y * this.velocity.y) > 0) {
            this.moveTo(this.owner.x += this.velocity.x * dtFactor, this.owner.y += this.velocity.y * dtFactor);
        }
        if (this.rotateVelocity != 0) {
            this.owner.rotation += this.rotateVelocity * dtFactor;
        }
    };
    Physics.prototype.moveTo = function (x, y) {
        if (typeof x == "number") {
            if (!y) {
                console.error("invalid param");
                return;
            }
            this.owner.x = x;
            this.owner.y = y;
        }
        else {
            this.owner.x = x.x;
            this.owner.y = x.y;
        }
        this.onMoved && this.onMoved(this.owner);
    };
    Physics.prototype.onDisabled = function () {
        DataMgr_1.DataMgr.game._phycicsSystem.remove(this);
    };
    Physics.prototype.onEnabled = function () {
        DataMgr_1.DataMgr.game._phycicsSystem.add(this);
    };
    Physics.prototype.onColliderResize = function (collider) {
        var center = collider.getCenter();
        this.owner.anchorX = center[0];
        this.owner.anchorY = center[1];
    };
    return Physics;
}(GameComponent_1.default));
exports.default = Physics;


/***/ }),

/***/ "./src/game/PlayerController.ts":
/*!**************************************!*\
  !*** ./src/game/PlayerController.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MConst_1 = __webpack_require__(/*! ../Global/MConst */ "./src/Global/MConst.ts");
var PlayerController = (function (_super) {
    __extends(PlayerController, _super);
    function PlayerController() {
        var _this = _super.call(this) || this;
        _this.onTouchMove = null;
        _this.touchId = null;
        _this.lastX = null;
        _this.width = MConst_1.MConst.DesignResolution.width;
        _this.height = MConst_1.MConst.DesignResolution.height;
        _this.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, function (e) {
            _this.touchId = e.instanceId;
            _this.lastX = e.clientX;
        }, _this);
        _this.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, function (e) {
            console.log(11111);
            if (e.instanceId != _this.touchId || _this.touchId == null || _this.lastX == null)
                return;
            _this.onTouchMove && _this.onTouchMove(e.clientX - _this.lastX);
            _this.lastX = e.clientX;
        }, _this);
        _this.addEventListener(FYGE.MouseEvent.MOUSE_UP, function (e) {
            if (e.instanceId != _this.touchId)
                return;
            _this.touchId = null;
            _this.lastX = null;
        }, _this);
        var graphics = new FYGE.Graphics();
        var rect = graphics
            .beginFill(0xffffff, 0)
            .drawRect(0, 0, 750, 1624)
            .endFill();
        _this.addChild(rect);
        return _this;
    }
    return PlayerController;
}(FYGE.Container));
exports.default = PlayerController;


/***/ }),

/***/ "./src/game/SpBoomEffect.ts":
/*!**********************************!*\
  !*** ./src/game/SpBoomEffect.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MUtils_1 = __webpack_require__(/*! ../Global/MUtils */ "./src/Global/MUtils.ts");
var MTimer_1 = __webpack_require__(/*! ../Global/MTimer */ "./src/Global/MTimer.ts");
var Pool_1 = __webpack_require__(/*! ../Component/Pool */ "./src/Component/Pool.ts");
var DataMgr_1 = __webpack_require__(/*! ../Mgr/DataMgr */ "./src/Mgr/DataMgr.ts");
var GameMgr_1 = __webpack_require__(/*! ../Mgr/GameMgr */ "./src/Mgr/GameMgr.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var InitSpeedValue = 0.08;
var alphaDuration = 300;
var alphaPerFrame = 1 / (alphaDuration / (1000 / 60));
var InitAcceleration = -0.00005;
var noAlphaDuration = 200 / (1000 / 60);
var Line = (function () {
    function Line(parent, type, color, rotation) {
        this.sprite = null;
        this.direction = null;
        this.speedValue = InitSpeedValue;
        this.frameTimer = 0;
        var sprite = new FYGE.Sprite(RES_1.RES.getRes(("fireworks_line_" + type)));
        parent.addChild(sprite);
        sprite.anchorX = sprite.width / 2;
        sprite.rotation = rotation;
        this.sprite = sprite;
        var dir = MUtils_1.MUtils.getVector(rotation + 90);
        this.direction = dir;
    }
    Line.prototype.init = function () {
        this.sprite.y = -this.sprite.height;
        this.sprite.alpha = 1;
        this.sprite.x = 0;
        this.sprite.y = 0;
        this.frameTimer = 0;
        this.speedValue = InitSpeedValue;
    };
    Line.prototype.onUpdate = function (dt) {
        this.sprite.x += this.direction.x * this.speedValue * dt;
        this.sprite.y += this.direction.y * this.speedValue * dt;
        if (this.frameTimer > noAlphaDuration) {
            this.sprite.alpha -= alphaPerFrame * MTimer_1.default.dtFactor;
        }
        this.frameTimer++;
    };
    return Line;
}());
var SpBoomEffectMgr = (function (_super) {
    __extends(SpBoomEffectMgr, _super);
    function SpBoomEffectMgr() {
        var _this = _super.call(this, "SpBoomEffectMgr") || this;
        _this.list = [];
        return _this;
    }
    SpBoomEffectMgr.prototype.onUpdate = function (dt) {
        if (this.pause)
            return;
        var filter = [];
        for (var _i = 0, _a = this.list; _i < _a.length; _i++) {
            var i = _a[_i];
            if (i.onUpdate(dt)) {
                filter.push(i);
            }
        }
        this.list = filter;
    };
    return SpBoomEffectMgr;
}(GameMgr_1.default));
exports.SpBoomEffectMgr = SpBoomEffectMgr;
var SpBoomEffect = (function (_super) {
    __extends(SpBoomEffect, _super);
    function SpBoomEffect(color, size) {
        var _this = _super.call(this) || this;
        _this.lines = [];
        _this.scaleX = _this.scaleY = 0.5 * size + 0.5;
        _this.rotation = MUtils_1.MUtils.random(0, 90);
        for (var i = 0; i < 16; i++) {
            var line = new Line(_this, i % 2, color, i * 22.5);
            _this.lines.push(line);
        }
        DataMgr_1.DataMgr.game._boomEffectMgr.list.push(_this);
        return _this;
    }
    SpBoomEffect.prototype.onUpdate = function (dt) {
        for (var _i = 0, _a = this.lines; _i < _a.length; _i++) {
            var i = _a[_i];
            i.onUpdate(dt);
        }
        if (this.lines[0].sprite.alpha <= 0) {
            DataMgr_1.DataMgr.game._pool.boomEffect.recycle(this.poolKey, this);
            return false;
        }
        return true;
    };
    SpBoomEffect.prototype.onElementInit = function () {
        this.visible = true;
        this.alpha = 1;
        for (var _i = 0, _a = this.lines; _i < _a.length; _i++) {
            var i = _a[_i];
            i.init();
        }
        DataMgr_1.DataMgr.game._boomEffectMgr.list.push(this);
    };
    SpBoomEffect.prototype.onElementRecycle = function () {
        this.visible = false;
    };
    return SpBoomEffect;
}(FYGE.Container));
var SpBoomEffectPool = (function (_super) {
    __extends(SpBoomEffectPool, _super);
    function SpBoomEffectPool() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SpBoomEffectPool.prototype.spwan = function (color, size) {
        if (this.data.length > 0) {
            var element = this.data.shift();
            element.onElementInit();
            return element;
        }
        else {
            var e = new SpBoomEffect(color, size);
            this.layer.addChild(e);
            return e;
        }
    };
    return SpBoomEffectPool;
}(Pool_1.Pool));
var SpBoomEffectPoolGroup = (function (_super) {
    __extends(SpBoomEffectPoolGroup, _super);
    function SpBoomEffectPoolGroup() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SpBoomEffectPoolGroup.prototype.spwan = function (color, size) {
        var key = color.toString() + size;
        if (!this.data[key]) {
            this.data[key] = new SpBoomEffectPool(this.layer);
        }
        var element = this.data[key].spwan(color, size);
        element.poolKey = key;
        return element;
    };
    return SpBoomEffectPoolGroup;
}(Pool_1.PoolGroup));
exports.default = SpBoomEffectPoolGroup;


/***/ }),

/***/ "./src/panels/rankPanel.ts":
/*!*********************************!*\
  !*** ./src/panels/rankPanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Light_1 = __webpack_require__(/*! ../parts/Light */ "./src/parts/Light.ts");
var RankPanel = (function (_super) {
    __extends(RankPanel, _super);
    function RankPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RankPanel.prototype, "groupNames", {
        get: function () {
            return ["outerPanel"];
        },
        enumerable: true,
        configurable: true
    });
    RankPanel.prototype.initUi = function () {
        this.addChild(new Light_1.Light()).position.set(375, 735);
        var ruleBg = Tools_1.Tool.getSprite("rank_bg.png");
        ruleBg.position.set((750 - 530) / 2, 250);
        this.addChild(ruleBg);
        this.closeBtn = new FYGE.Button(RES_1.RES.getRes("close.png"));
        this.closeBtn.position.set(625, 255);
        this.addChild(this.closeBtn).once(FYGE.MouseEvent.CLICK, this.onClick_closeBtn, this);
    };
    RankPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    RankPanel.prototype.initEvents = function () {
        this.closeBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onClick_closeBtn, this);
    };
    RankPanel.prototype.onClick_closeBtn = function () {
        this.hidePanel();
    };
    RankPanel.prototype.removeEvents = function () {
        this.closeBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onClick_closeBtn, this);
    };
    return RankPanel;
}(Panel_1.Panel));
exports.RankPanel = RankPanel;


/***/ }),

/***/ "./src/panels/rulePanel.ts":
/*!*********************************!*\
  !*** ./src/panels/rulePanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Light_1 = __webpack_require__(/*! ../parts/Light */ "./src/parts/Light.ts");
var RulePanel = (function (_super) {
    __extends(RulePanel, _super);
    function RulePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RulePanel.prototype, "groupNames", {
        get: function () {
            return ["outerPanel"];
        },
        enumerable: true,
        configurable: true
    });
    RulePanel.prototype.initUi = function () {
        this.addChild(new Light_1.Light()).position.set(375, 735);
        var ruleBg = Tools_1.Tool.getSprite("ruleBg.png");
        ruleBg.position.set((750 - 530) / 2, 250);
        var arr = '这里是文本内容区域哦规则说明：一天有免费的三次试玩时间，用完后可通过好友助力再来游戏，上限为三次规则说明：一天有免费的三次试玩时间，用完后可通过好友助力再来游戏，上限为三次规则说明：一天有免费的三次试玩时间，用完后可通过好友助力再来游戏，上限为三次';
        var text = Tools_1.Tool.getText(arr, 20, 'lightblue', FYGE.TEXT_ALIGN.LEFT, 450, 60, 230);
        ruleBg.addChild(text);
        this.addChild(ruleBg);
        this.closeBtn = new FYGE.Button(RES_1.RES.getRes("close.png"));
        this.closeBtn.position.set(625, 255);
        this.addChild(this.closeBtn).once(FYGE.MouseEvent.CLICK, this.onClick_closeBtn, this);
    };
    RulePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    RulePanel.prototype.initEvents = function () {
        this.closeBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onClick_closeBtn, this);
    };
    RulePanel.prototype.onClick_closeBtn = function () {
        this.hidePanel();
    };
    RulePanel.prototype.removeEvents = function () {
        this.closeBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onClick_closeBtn, this);
    };
    return RulePanel;
}(Panel_1.Panel));
exports.RulePanel = RulePanel;


/***/ }),

/***/ "./src/parts/Light.ts":
/*!****************************!*\
  !*** ./src/parts/Light.ts ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Light = (function (_super) {
    __extends(Light, _super);
    function Light() {
        var _this = _super.call(this) || this;
        _this.texture = RES_1.RES.getRes("light.png");
        _this.anchorTexture.set(0.5, 0.5);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            _this.rotation += 1;
        }, _this);
        return _this;
    }
    return Light;
}(FYGE.Sprite));
exports.Light = Light;


/***/ }),

/***/ "./src/scenes/StartScene.ts":
/*!**********************************!*\
  !*** ./src/scenes/StartScene.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var rulePanel_1 = __webpack_require__(/*! ../panels/rulePanel */ "./src/panels/rulePanel.ts");
var rankPanel_1 = __webpack_require__(/*! ../panels/rankPanel */ "./src/panels/rankPanel.ts");
var DxqPlayScene_1 = __webpack_require__(/*! ../game/DxqPlayScene */ "./src/game/DxqPlayScene.ts");
exports.svgaPool = {};
var StartScene = (function (_super) {
    __extends(StartScene, _super);
    function StartScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(StartScene.prototype, "groupNames", {
        get: function () { return ["startScene"]; },
        enumerable: true,
        configurable: true
    });
    StartScene.prototype.initUi = function () {
        _super.prototype.initUi.call(this);
        var startBg = new FYGE.Sprite(RES_1.RES.getRes("startBg.png"));
        this.addChild(startBg);
    };
    StartScene.prototype.start = function () {
        _super.prototype.start.call(this);
        ctrls_1.showToast("点击下方按钮\n开始游戏");
        var btn = new FYGE.Button(RES_1.RES.getRes("startBtn.png"));
        btn.position.set((750 - 443) / 2, 740);
        this.addChild(btn);
        btn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            console.log("开始按钮");
            ctrls_1.changeScene(DxqPlayScene_1.default);
        }, this);
        var ruleBtn = new FYGE.Button(RES_1.RES.getRes("ruleBtn.png"));
        ruleBtn.position.set(80, 1000);
        this.addChild(ruleBtn);
        ruleBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            ctrls_1.showPanel(rulePanel_1.RulePanel);
            console.log("我是规则");
        });
        var rankBtn = new FYGE.Button(RES_1.RES.getRes("rankBtn.png"));
        rankBtn.position.set(300, 1000);
        this.addChild(rankBtn);
        rankBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            ctrls_1.showPanel(rankPanel_1.RankPanel);
            console.log("我是排行榜");
        });
        var signInBtn = new FYGE.Button(RES_1.RES.getRes("signInBtn.png"));
        signInBtn.position.set(540, 1000);
        this.addChild(signInBtn);
        signInBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            console.log("我是签到");
        });
        var propBtn = new FYGE.Button(RES_1.RES.getRes("propBtn.png"));
        propBtn.position.set(-20, 60);
        this.addChild(propBtn);
        propBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            console.log("我是本期道具");
        });
        var recordBtn = new FYGE.Button(RES_1.RES.getRes("recordBtn.png"));
        recordBtn.position.set(-20, 135);
        this.addChild(recordBtn);
        recordBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            console.log("我是我的奖品");
        });
        var doHelpIcon = new FYGE.Sprite(RES_1.RES.getRes("doHelpIcon.png"));
        doHelpIcon.position.set(125, 25);
        this.addChild(doHelpIcon);
    };
    StartScene.prototype.testMove = function () {
        var image = new FYGE.Sprite(RES_1.RES.getRes("silverDraft.png"));
        image.x = 500;
        image.y = 0;
        this.addChild(image);
        var s = 5;
        this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            image.y += s;
            image.y = Math.round(image.y);
            if (image.y > 1300) {
                image.y = 0;
            }
        }, this);
    };
    StartScene.prototype.testScroll = function () {
        var image = new FYGE.Sprite(RES_1.RES.getRes("startBg.jpg"));
        var sPage = new FYGE.ScrollPage(750, layers_1.layers.stageHeight, 1624, true, true);
        sPage.view.addChild(image);
        this.addChild(sPage);
        sPage.x = 100;
        sPage.y = 100;
        var delta = 10;
        var sc = new FYGE.ScrollPage(750, 200, 1624, false, false);
        sc.maxDistance = delta * (10 - 1) + 200 * 10;
        sc.y = 900;
        sPage.view.addChild(sc);
        for (var i = 0; i < 10; i++) {
            var image_1 = new FYGE.Sprite(RES_1.RES.getRes("silverDraft.png"));
            image_1.width = 200;
            image_1.height = 200;
            image_1.x = delta * i + i * 200;
            sc.view.addChild(image_1);
        }
    };
    StartScene.prototype.testGraphics = function () {
        var g = new FYGE.Graphics();
        g.beginFill(0xff0000, 0.7);
        g.drawEllipse(200, 200, 200, 300);
        g.endFill();
        this.addChild(g);
    };
    StartScene.prototype.testSprite = function () {
        var t = RES_1.RES.getRes("silverDraft.png");
        for (var i = 0; i < 2500; i++) {
            var image = new FYGE.Sprite(t);
            image.x = Math.random() * 750;
            image.y = Math.random() * 1206;
            this.addChild(image);
        }
    };
    StartScene.prototype.testMv = function () {
        var _this = this;
        var src = "cloud://A8673B47AAA58993A24A6718E203B967//dice.svga";
        SvgaParser.loadSvga(src, function (v) {
            var mv = new FYGE.MovieClip(v);
            _this.addChild(mv);
        }, function (err) { console.log(err); });
    };
    StartScene.prototype.testList = function () {
        var list = new FYGE.ScrollList(Item1, 60, 100, 200, 100, false);
        list.x = 100;
        list.y = 500;
        list.updateData([1, 2, 3, 4, 5, 6]);
        this.addChild(list);
    };
    return StartScene;
}(Scene_1.Scene));
exports.StartScene = StartScene;
var Item1 = (function (_super) {
    __extends(Item1, _super);
    function Item1() {
        var _this = _super.call(this) || this;
        _this.txt = new FYGE.TextField();
        _this.txt.size = 50;
        _this.txt.fillColor = "#ff0000";
        _this.addChild(_this.txt);
        return _this;
    }
    Item1.prototype.initData = function (id, data) {
        console.log(data);
        this.txt.text = data + "";
    };
    return Item1;
}(FYGE.Sprite));


/***/ })

/******/ });
});
//# sourceMappingURL=output.js.map