export as namespace SVGA;

declare global {
    const SVGA: {
        Parser: typeof Parser,
        EgretMovieClip: typeof EgretMovieClip,
    }
}

export class VideoEntity {
    videoSize: { width: number, height: number }
    FPS: number
    frames: number
}

export class Parser {
    load(url: string, success: (videoItem: VideoEntity) => void, failure?: (err: Error) => void): void
}

export class EgretMovieClip {
    lockStep: boolean;
    readonly currentFrame: number;
    readonly isPlaying: boolean;
    readonly isFront: boolean;
    totalFrames: number;
    /**
     * 停止
     */
    stop(): void;
    /**
     * 播放
     */
    play(): void;
    nextFrame(): void;
    prevFrame(): void;
    /**
     * 停在指定帧
     * @param frameIndex 
     */
    gotoAndStop(frameIndex: number): void;
    /**
     * 
     * @param frameIndex 1开始
     * @param isFront 默认true正向播放
     */
    gotoAndPlay(frameIndex: number, isFront: boolean): void;
    readonly isInTimeFrame: boolean;
    /**
     * 帧数范围播放
     * @param beginFrame 默认第一帧
     * @param endFrame 默认最后一帧
     * @param loops 默认0，表示无限循环
     * @param callback 所有播放完的回调
     */
    startAniRange(beginFrame: number, endFrame: number, loops: number, callback?: Function): void
    constructor(mv: VideoEntity)
}
