import getIsIOS from "../../new_tc/getIsIOS";
import wait from "../../new_tc/wait";
import doStart from "../../new_tw/ctrls/doStart";
import getCountTxt from "../../new_tw/datas/getCountTxt";
import getStartBtnEnable from "../../new_tw/datas/getStartBtnEnable";
import { DataManager,TwFun } from "../../tw/index";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "./Scene";
import { NetManager } from "../../tw/manager/NetManager";
import { Buried } from "../../tw/index";

export default class StartSceneBase extends Scene {
    public exemptionTxt:eui.Label;
    public recordBtn:eui.Button;
    public ruleBtn:eui.Button;
    public image:eui.Image;
    public image0:eui.Image;
    public image3:eui.Image;
    public image2:eui.Image;
    public image1:eui.Image;
    public image4:eui.Image;
    public image5:eui.Image;
    public image6:eui.Image;
    public image8:eui.Image;
    public image7:eui.Image;
    public countTxt:eui.Label;
    public startBtn:eui.Button;
    public creditsText:eui.Label;
    
    _timer: egret.Timer;

    async start(data?) {
       // this.startBtn.visible = false;
        this.updateGetInfoView();
        this.updateExemptionTxt();
        // this.autoStart();
        super.start();
        this.doBuried()
        this.getCredits()
    }

    private exposure=[]

    private doBuried(){
        //初始化埋点数据
        Buried.init();
        var appId=DataManager.ins.gameCfgData.appInfo.appId;
        var oaId=DataManager.ins.gameCfgData.gameInfo.oaId;

        var dpmstartBtn=appId+'.110.1.1';
        var dcmstartBtn="202."+oaId+".0.0";
        this.exposure["startBtn"] = Buried.createExposure(dpmstartBtn, dcmstartBtn);
        NetManager.ins.showLog(this.exposure["startBtn"]);
   }

   private getCredits(){
        NetManager.ins.getCredits(()=>{ // 获取用户剩余积分
            let userCredits = DataManager.ins.getCreditsData.consumerCredits ? DataManager.ins.getCreditsData.consumerCredits : 0;
            let unitName = DataManager.ins.getCreditsData.unitName ? DataManager.ins.getCreditsData.unitName : '积分'
           // console.log("您共有"+userCredits+unitName)
            this.creditsText.text="您共有"+userCredits+unitName
        })
   }

    clearTime=[]

    async playAnimation() {
        this["btnkeep"].play(0)
        console.log(this["btnkeep"])
        this.clearTime["btnkeep"]=setInterval(()=>{
            this["btnkeep"].play(0)
        },500)

        this["keepAn"].play(0)
        this.clearTime["keepAn"]=setInterval(()=>{
            this["keepAn"].play(0)
        },1000)

        this["keepAnList"].play(0)
        this.clearTime["keepAnList"]=setInterval(()=>{
            this["keepAnList"].play(0)
        },4000)
    }

    private updateGetInfoView() {
        if (DataManager.ins.getInfoData) {
            this.updateStartBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    async updateStartBtnStatus() {
        if (this.startBtn) {
            this.startBtn.visible = true;
           // this.startBtn.enabled = getStartBtnEnable();
            this.startBtn.enabled=true;
        }
    }

    updateCountTxt() {
        if (this.countTxt) {
            this.countTxt.text = getCountTxt();

        }
    }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
       /*  if (this.htmlRuleBtn)
            this.htmlRuleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_htmlRuleBtn, this);
        if (this.optionBtn)
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this); */
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        if (this.startBtn)
            this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
       /*  if (this.rankBtn)
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this); */
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    onTap_htmlRuleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
      //  this.delayEnable(this.view.recordBtn, 5000);
        window.location.href = TwFun.getRecordUrl('00');
    }

    async onTap_startBtn(e?: egret.Event) {
        NetManager.ins.clickLog(this.exposure["startBtn"]);
        this.startBtn.enabled=false
        doStart((success:boolean)=>{
            this.startBtn.enabled=true
            if(success){
                if(DataManager.ins.getStartStatusData.code==0){
                    localStorage.gameState3="noStartStatus"
                }
                SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
            }else if(!success&&localStorage.gameState2=="getStartOrderStatus"){
                localStorage.gameState3="noStartStatus"
                SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
            }
        })
    }
    private stopTimer() {
       /*  if (this._timer)
            this._timer.stop();
        egret.Tween.get(this.countdownTxt).to({ alpha: 0 }, 200); */
    }

    onTap_rankBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
    }

    get skinKey() { return 'Start' }
}