import StartScene from "./startScene/StartScene";
import PlayScene from "./playScene/PlayScene";
import MainBase from "../libs/new_wx/MainBase";
import { Buried, NetManager } from "../libs/tw/index";
import { getProjectId } from "./Net";

class Main extends MainBase {
    protected get startSceneConfig() {
        return { cls: StartScene }
    }
    protected get playSceneConfig() {
        return { cls: PlayScene }
    }
}

//曝光埋点
export function newShowLog(appIdParam) {
    var appId = window["appId"];
    var oaId = getProjectId()//window["projectId"];
    let data: any = Buried.createExposure(appId + `.110.${appIdParam}.1`, `202.${oaId}.0.0`);
    NetManager.ins.showLog(data)
}
//点击埋点
export function newClickLog(appIdParam) {
    var appId = window["appId"];
    var oaId = getProjectId()//window["projectId"];
    let data: any = Buried.createExposure(appId + `.110.${appIdParam}.1`, `202.${oaId}.0.0`);
    NetManager.ins.clickLog(data)
}



window['Main'] = Main;
egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: (context: any) => {
        const backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});