

import layers from "../views/layers";
import Toast from "../components/Toast";

let inited = false;
let _toast: Toast;

const initToast = () => {
    if (!inited) {
        inited = true;
        const toast = new Toast();
        toast.loadSkin();
        layers.toastLayer.addChild(toast);
        toast.alpha = 0;
        _toast = toast;
    }
    return _toast;
}
export const showToast = (msg: string) => {
    const toast = initToast().start(msg);
    egret.Tween.removeTweens(toast);
    const tw = egret.Tween.get(toast);
    tw.set({ y: -200, alpha: 1 }).to({ y: 400 }, 500, egret.Ease.quartOut)
        .wait(500)
        .to({ alpha: 0 }, 300)
}

// export const showToast2 = (msg: string) => {
//     const toast = initToast().start(msg);
//     egret.Tween.removeTweens(toast);
//     const tw = egret.Tween.get(toast, { loop: true });
//     tw.set({ y: 300, alpha: 0 }).to({ alpha: 1 }, 500).wait(2000)
//         .to({ alpha: 0 }, 500)
// }

// export const clearToast = () => {
//     const toast = initToast();
//     toast.alpha = 0;
//     egret.Tween.removeTweens(toast);
// }