import showLog from "../../new_tw/ctrls/showLog";
import { LotteryType } from "../../tw/enum/LotteryType";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import Panel from "./Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../tw/index";
import { newClickLog, newShowLog } from "../../../src/Main";
import { getPrizeInfo } from "../../../src/Net";
import Loading from "./Loading";
import { showToast } from "../ctrls/toastCtrl";
export default class PrizePanel extends Panel {

    public body: eui.Group;
    public closeBtn: eui.Button;
    public useBtn: eui.Button;
    // public img: eui.Image;

    start(data) {
        super.start()

        newShowLog(4);

        this.data = data;
        //判断显示哪张图片,用哪个待定prizeId
        var prizeId = data.prizeId;
        // var index = (window["prizeIds"] || []).indexOf(prizeId);
        // if (index >= 0 && index <= 2) this["prize" + (index + 1)].visible = true;

        Loading.instace.show();
        this["nameTxt"].visible = false;
        this["nameTxt"].y+=8;
        getPrizeInfo((s, res) => {
            Loading.instace.hide();
            if (s && res && res.data && res.data[0]) {
                this["nameTxt"].visible = true;
                this.data.image = res.data[0].icon;
                this.data.name = res.data[0].name;
            } else {
                showToast("奖品信息获取失败\n请在我的奖品中查看")
            }
        }, prizeId + "")
    }

    onTouchTap_closeBtn(): any {
        super.onTouchTap_closeBtn();

    }

    initEvents() {
        super.initEvents();
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);

    }

    onUse() {
        newClickLog(4)
        setTimeout(() => {
            window.location.href = this.data.url;
        }, 1000)
        // window.location.href = this.data.url;
    }


    get skinKey() { return 'Prize' }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}