import {GDispatcher} from "./../libs/tc/index";
export default class MovieClipManager {
   
    static _instance: MovieClipManager;
    public static get instance() {
        return MovieClipManager._instance || (MovieClipManager._instance = new MovieClipManager())
    }

    public movieClipPool:any[] = [];
    // 影片剪辑的配置属性
    public movieClipNamePool:any[] = [
        {name:'npc', 
        dataNames:[
            "npc1",
            "npc2",
            "npc3",
            "npc4",
            "npc5",
            "npc6",
            "npc7",
            "npc8",
        ], num:1},
        {name:'npcd', 
        dataNames:[
            "npcd1",
            "npcd2",
            "npcd3",
            "npcd4",
            "npcd5",
            "npcd6",
            "npcd7",
            "npcd8",
        ], num:1},
        {name:'spray', 
        dataNames:[
            "spray",
        ], num:1},
        {name:'boom', 
        dataNames:[
            "boom",
        ], num:1},
        {name:'bowlAn', 
        dataNames:[
            "bowlAn",
        ], num:1},
        
    ];

    // 初始化
    public init(){
       this.initMovieClip();
       this.count=0;
    }

    // 初始化影片剪辑
    private initMovieClip():void{
        for(let m = 0; m < this.movieClipNamePool.length; m++){
            this.ayncLoad2Mc(`${this.movieClipNamePool[m].name}_json`);   
        }
    }

    // 异步加载动画资源
    private ayncLoad2Mc(resname : string) : void{
        RES.getResAsync(resname,this.onLoad.bind(this),this);
    }

    private count=0;

    // 加载完的回调
    private onLoad(data: any,key: string){
        let scope = this;
        for(let m = 0; m < scope.movieClipNamePool.length; m++){
            if(key == `${scope.movieClipNamePool[m].name}_json`) {
                scope.ayncLoad2Mc(`${scope.movieClipNamePool[m].name}_png`);
            }else if(key == `${scope.movieClipNamePool[m].name}_png`){
                for(let i = 0; i < scope.movieClipNamePool[m].num; i++){
                    scope.movieClipNamePool[m].dataNames.forEach((dataName)=>{
                        let data2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_json`);
                        let texture2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_png`);
                        let mcFactory : egret.MovieClipDataFactory = new egret.MovieClipDataFactory(data2mc,texture2mc);
                        let mc:egret.MovieClip = new egret.MovieClip(mcFactory.generateMovieClipData(`${dataName}`));
                        mc.name = `${dataName}_${i}`;
                        // console.log(mc.name);
                        scope.movieClipPool.push(mc);;
                    })
                    // console.log("加载")
                    this.count++
                    if(this.count==this.movieClipNamePool.length){
                        // console.log("加载完成")
                        GDispatcher.dispatchEvent("loadClipSuccess")
                    }
                }
            }
        }

        // console.log(RES)
        
    }

    // 获取单个影片剪辑
    public getMovieClipByName(name:string):any{
        for(let mc = 0; mc < this.movieClipPool.length; mc++){
            if(this.movieClipPool[mc].name == name){
                return this.movieClipPool[mc];
            }
        }
    }

}