import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import { HtmlTextParser } from "../HtmlTextParser";
import Panel from "./Panel";

export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        super.start();
        this.addRule()
    }

    group: eui.Group;
    private addRule() {
        const text = window["rule"]||""//||testRule;
        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }

    get skinKey() { return 'Rule' }
}

const testRule = `结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。
结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。`;