import Panel from "./Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../tw/manager/DataManager";
import showAlertPanel from "../ctrls/showAlertPanel";
import { NetManager } from "../../tw/index";
import { Buried } from "../../tw/index";
export default class Box extends Panel {

    public resetBtn:eui.Button;
    public closeBtn:eui.Button;
    public body:eui.Button;

    start(data) {
       // this.data.btnTxt = btnTxt || '确定';
       this.doBuried()
       this.body.y=this.stage.stageHeight/2- this.body.height/2
    }

     get skinKey() { return 'Box' }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }

    private clearTime=[]

    initEvents(){
        super.initEvents();
        this.resetBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_openBtn, this);
        this["light"].play(0)
        this.clearTime["light"]=setInterval(()=>{
            this["light"].play(0)
        },4000)
    }

    exposure=[]
    public doBuried(){
        //初始化埋点数据
        Buried.init();
        var appId=DataManager.ins.gameCfgData.appInfo.appId;
        var oaId=DataManager.ins.gameCfgData.gameInfo.oaId;

        var dpmcloseBtn=appId+'.110.4.1';
        var dcmcloseBtn="202."+oaId+".0.0";
        this.exposure["closeBtn"] = Buried.createExposure(dpmcloseBtn, dcmcloseBtn);
        NetManager.ins.showLog(this.exposure["closeBtn"]);
   }

    //  exposure=[]
    public doloseGameBuried(){
        Buried.init();
        var appId=DataManager.ins.gameCfgData.appInfo.appId;
        var oaId=DataManager.ins.gameCfgData.gameInfo.oaId;
        var dpmcloseBtn=appId+'.110.6.1';
        var dcmcloseBtn="202."+oaId+".0.0";
        this.exposure["loseGame"] = Buried.createExposure(dpmcloseBtn, dcmcloseBtn);
        NetManager.ins.showLog(this.exposure["loseGame"]);
   }

    removeEvents(){
        super.removeEvents();
        this.clearTime.forEach((clear)=>{
            clearInterval(clear);
            clearTimeout(clear);
        })
    }

    onTouchTap_closeBtn(): any {
        super.onTouchTap_closeBtn();
        NetManager.ins.getInfo((success) => {
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
    }

    onTouchTap_openBtn(): any {
        super.onTouchTap_closeBtn();
        NetManager.ins.clickLog(this.exposure["closeBtn"]);
        localStorage.gameState="";
        setTimeout(()=>{
            if (DataManager.ins.gameGetSubmitResultData.lottery) {
                PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL)
            } else {
                this.doloseGameBuried()
                let panel = showAlertPanel("啊哦~\n您和奖品擦肩而过");
                panel.addEventListener('onDestroy', () => {
                    NetManager.ins.clickLog(this.exposure["loseGame"]);
                    NetManager.ins.getInfo((success) => {
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    })
                }, this)
            }
        },1000)
       // SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}