
/**
 * Object pooling utility.
 * @class Pool
 */
export class Pool {

	/**
	 * @property {Array} objects
	 * @type {Array}
	 */
	objects: any[];

	/**
	 * 
	 * @param options 
	 * @constructor
	 */
	constructor(options) {
		options = options || {};


		this.objects = [];

		if (options.size !== undefined) {
			this.resize(options.size);
		}
	}

	/**
	 * 由子类实现
	 */
	create() {

	}

	/**
	 * @method resize
	 * @param {number} size
	 * @return {Pool} Self, for chaining
	 */
	resize(size: number) {
		var objects = this.objects;

		while (objects.length > size) {
			objects.pop();
		}

		while (objects.length < size) {
			objects.push(this.create());
		}

		return this;
	};

	/**
	 * Get an object from the pool or create a new instance.
	 * @method get
	 * @return {Object}
	 */
	get() {
		var objects = this.objects;
		return objects.length ? objects.pop() : this.create();
	};

	/**
	 * Clean up and put the object back into the pool for later use.
	 * @method release
	 * @param {Object} object
	 * @return {Pool} Self for chaining
	 */
	release(object) {
		this.destroy(object);
		this.objects.push(object);
		return this;
	};
	/**
	 * 由子类实现
	 * @param object 
	 */
	destroy(object) {

	}
}
