
//这里都是一些常量
/**
 * 版本号
 * @static
 * @constant
 * @name VERSION
 * @type {string}
 */
export const VERSION = "1.0";

/**
 * 有问题
 */
//@ts-ignore
export const sysInfo = my.getSystemInfoSync();
/**
 * 有问题
 */
export const devicePixelRatio: number = sysInfo.pixelRatio //window.devicePixelRatio || 1;


/**
 * 获取设备号iOS  Android
 */
export const osType: "ios" | "android" = sysInfo.platform.toLowerCase()


let PI: number = Math.PI;
let HalfPI: number = PI >> 1;
let PacPI: number = PI + HalfPI;
/**
 * @method cos
 * @private
 * @param {number} angle,弧度制
 * @return {number}
 */
export function cos(angle: number): number {
    switch (angle) {
        case HalfPI:
        case -PacPI:
            return 0;
        case PI:
        case -PI:
            return -1;
        case PacPI:
        case -HalfPI:
            return 0;
        default:
            return Math.cos(angle);
    }
}

/**
 * @method sin
 * @param {number} angle,弧度制
 * @return {number}
 */
export function sin(angle: number): number {
    switch (angle) {
        case HalfPI:
        case -PacPI:
            return 1;
        case PI:
        case -PI:
            return 0;
        case PacPI:
        case -HalfPI:
            return -1;
        default:
            return Math.sin(angle);
    }
}
/**
 * Two Pi.
 *
 * @static
 * @constant
 * @type {number}
 */
export const PI_2: number = PI * 2;

/**
 * Conversion factor for converting radians to degrees.
 * 弧度转角度
 * @static
 * @constant
 * @type {number}
 */
export const RAD_TO_DEG: number = 180 / PI;

/**
 * Conversion factor for converting degrees to radians.
 * 角度转弧度
 * @static
 * @constant
 * @type {number}
 */
export const DEG_TO_RAD: number = PI / 180;

/**
 * 渲染方式记录
 * @static
 * @constant
 * @name RENDERER_TYPE
 * @type {object}
 * @property {number} UNKNOWN - Unknown render type.
 * @property {number} WEBGL - WebGL render type.
 * @property {number} CANVAS - Canvas render type.
 */
export enum RENDERER_TYPE {
    UNKNOWN = 0,
    WEBGL,
    CANVAS,
};

/**
 * 各种形状
 * @static
 * @constant
 * @name SHAPES
 * @type {object}
 * @property {number} POLY Polygon  多边形
 * @property {number} RECT Rectangle 矩形
 * @property {number} CIRC Circle 圆形
 * @property {number} ELIP Ellipse 椭圆
 * @property {number} RREC Rounded Rectangle 圆角矩形
 */
export enum SHAPES {
    POLY = 0,
    RECT,
    CIRC,
    ELIP,
    RREC,
};

/**
 * 着色器浮点精度
 * @static
 * @constant
 * @name PRECISION
 * @type {object}
 * @property {string} LOW='lowp'
 * @property {string} MEDIUM='mediump'
 * @property {string} HIGH='highp'
 */
export enum PRECISION {
    LOW = 'lowp',
    MEDIUM = 'mediump',
    HIGH = 'highp',
};

/**
 * 文本渐变方式，以后用
 * @static
 * @constant
 * @name TEXT_GRADIENT
 * @type {object}
 * @property {number} LINEAR_VERTICAL 水平渐变
 * @property {number} LINEAR_HORIZONTAL 垂直渐变
 */
export enum TEXT_GRADIENT {
    LINEAR_VERTICAL = 0,
    LINEAR_HORIZONTAL,
};

/**
 * 文本对齐方式  水平
 */
export enum TEXT_ALIGN {
    CENTER = "center",
    LEFT = "left",
    RIGHT = "right",
}

export enum VERTICAL_ALIGN {
    MIDDLE = "middle",
    UP = "up",
    DOWN = "down",
}

/**
 * 文本类型，单行或多行
 */
export enum TEXT_lINETYPE {
    SINGLE = "single",
    MULTI = "multi"
}

/**
 * 画线时的对齐方式
 */
export enum LINE_ALIGNMENT {
    middle = 0.5,
    outter = 1,
    inner = 0
}

/**
 * canvas线头
 */
export enum LINE_CAP {
    BUTT = "butt",
    ROUND = "round",
    SQUARE = "square",
}

/**
 * canvas线连接处
 */
export enum LINE_JOIN {
    MITER = "miter",
    ROUND = "round",
    BEVEL = "bevel"
}


/**
 * Various blend modes supported by 
 *
 * IMPORTANT - The WebGL renderer only supports the NORMAL, ADD, MULTIPLY and SCREEN blend modes.
 * Anything else will silently act like NORMAL.
 *
 * @static
 * @constant
 * @name BLEND_MODES
 * @type {object}
 * @property {number} NORMAL
 * @property {number} ADD
 * @property {number} MULTIPLY
 * @property {number} SCREEN
 * @property {number} OVERLAY
 * @property {number} DARKEN
 * @property {number} LIGHTEN
 * @property {number} COLOR_DODGE
 * @property {number} COLOR_BURN
 * @property {number} HARD_LIGHT
 * @property {number} SOFT_LIGHT
 * @property {number} DIFFERENCE
 * @property {number} EXCLUSION
 * @property {number} HUE
 * @property {number} SATURATION
 * @property {number} COLOR
 * @property {number} LUMINOSITY
 */
export enum BLEND_MODES {
    NORMAL = 0,
    ADD,
    MULTIPLY,
    SCREEN,
    OVERLAY,
    DARKEN,
    LIGHTEN,
    COLOR_DODGE,
    COLOR_BURN,
    HARD_LIGHT,
    SOFT_LIGHT,
    DIFFERENCE,
    EXCLUSION,
    HUE,
    SATURATION,
    COLOR,
    LUMINOSITY,
    NORMAL_NPM,
    ADD_NPM,
    SCREEN_NPM,

    NONE,

    SRC_OVER,

    SRC_IN,
    SRC_OUT,
    SRC_ATOP,
    DST_OVER,
    DST_IN,
    DST_OUT,
    DST_ATOP,
    ERASE,
    SUBTRACT,
};

/**
 * Various webgl draw modes. These can be used to specify which GL drawMode to use
 * under certain situations and renderers.
 *
 * @static
 * @constant
 * @name DRAW_MODES
 * @type {object}
 * @property {number} POINTS
 * @property {number} LINES
 * @property {number} LINE_LOOP
 * @property {number} LINE_STRIP
 * @property {number} TRIANGLES
 * @property {number} TRIANGLE_STRIP
 * @property {number} TRIANGLE_FAN
 */
export enum DRAW_MODES {
    POINTS = 0,
    LINES,
    LINE_LOOP,
    LINE_STRIP,
    TRIANGLES,
    TRIANGLE_STRIP,
    TRIANGLE_FAN,
};

/**
 * The scale modes that are supported by 
 *
 * The {@link settings.SCALE_MODE} scale mode affects the default scaling mode of future operations.
 * It can be re-assigned to either LINEAR or NEAREST, depending upon suitability.
 *
 * @static
 * @constant
 * @name SCALE_MODES
 * @type {object}
 * @property {number} LINEAR Smooth scaling
 * @property {number} NEAREST Pixelating scaling
 */
export enum SCALE_MODES {
    LINEAR = 0,
    NEAREST,
};

/**
 * The wrap modes that are supported by 
 *
 * The {@link settings.WRAP_MODE} wrap mode affects the default wrapping mode of future operations.
 * It can be re-assigned to either CLAMP or REPEAT, depending upon suitability.
 * If the texture is non power of two then clamp will be used regardless as webGL can
 * only use REPEAT if the texture is po2.
 *
 * This property only affects WebGL.
 *
 * @static
 * @constant
 * @name WRAP_MODES
 * @type {object}
 * @property {number} CLAMP - The textures uvs are clamped
 * @property {number} REPEAT - The texture uvs tile and repeat
 * @property {number} MIRRORED_REPEAT - The texture uvs tile and repeat with mirroring
 */
export enum WRAP_MODES {
    CLAMP = 33071,
    REPEAT = 10497,
    MIRRORED_REPEAT = 33648,
};

/**
 * The gc modes that are supported by 
 *
 * The {@link settings.GC_MODE} Garbage Collection mode for textures is AUTO
 * If set to GC_MODE, the renderer will occasionally check textures usage. If they are not
 * used for a specified period of time they will be removed from the GPU. They will of course
 * be uploaded again when they are required. This is a silent behind the scenes process that
 * should ensure that the GPU does not  get filled up.
 *
 * Handy for mobile devices!
 * This property only affects WebGL.
 *
 * @static
 * @constant
 * @name GC_MODES
 * @type {object}
 * @property {number} AUTO - Garbage collection will happen periodically automatically
 * @property {number} MANUAL - Garbage collection will need to be called manually
 */
export enum GC_MODES {
    AUTO = 0,
    MANUAL,
};


