import { earcut } from "./earcut"
import GraphicsData from "../GraphicsData";
import Graphics from "../Graphics";

/**
 * Builds a rectangle to draw
 *
 * Ignored from docs since it is not directly exposed.
 *
 * @ignore
 * @private
 * @param {WebGLGraphicsData} graphicsData - The graphics object containing all the necessary properties
 * @param {object} webGLData - an object containing all the WebGL-specific information to create this shape
 * @param {object} webGLDataNativeLines - an object containing all the WebGL-specific information to create nativeLines
 */
export default {

    //计算点points
    build(graphicsData:GraphicsData) {
        // --- //
        // need to convert points to a nice regular data
        //
        const rectData = graphicsData.shape;
        const x = rectData.x;
        const y = rectData.y;
        const width = rectData.width;
        const height = rectData.height;

        const points = graphicsData.points;

        points.length = 0;

        points.push(x, y,
            x + width, y,
            x + width, y + height,
            x, y + height);
    },

    //计算顶点和索引
    triangulate(graphicsData:GraphicsData, graphics: Graphics) {
        const points = graphicsData.points;

        //graphics之前可能已经有点
        const verts = graphics.verts;
        const vertPos = verts.length / 2;

        verts.push(points[0], points[1],
            points[2], points[3],
            points[6], points[7],
            points[4], points[5]);

        graphics.indices.push(vertPos, vertPos + 1, vertPos + 2,
            vertPos + 1, vertPos + 2, vertPos + 3);
    },
};
