

// let env: "tb" | "web" = "web";
// //如果是浏览器环境，声明个my为null，为了无声明不报错
// if (window) window["my"] = null;//在用webview的小程序环境内，只要在小程序的sdk前加js就无所谓，
// export function getEnv(): "tb" | "web" {
//     return env
// }
// /**
//  * 创建一个离屏的canvas
//  */
// export function createCanvas(): HTMLCanvasElement {
//     //@ts-ignore
//     return document && document.createElement("canvas") || my._createOffscreenCanvas();
// }

// let contentByCanvas: {
//     createImage: () => HTMLImageElement,
//     requestAnimationFrame: (fun: Function) => number,
//     cancelAnimationFrame: (id) => void,
// };
// /**
//  * 淘宝小程序项目，拿到canvas先执行这个,,,TODO为啥不直接记录canvas.也许有问题,暂时不改
//  * @param canvas 
//  */
// export function initedByCanvas(canvas) {
//     contentByCanvas = {
//         createImage: canvas.createImage.bind(canvas),
//         //必须加bind，函数内存在this指向
//         requestAnimationFrame: canvas.requestAnimationFrame.bind(canvas),
//         cancelAnimationFrame: canvas.cancelAnimationFrame.bind(canvas),
//     }
//     env = "tb";
// }
// export function destroyCanvasContent() {
//     if (contentByCanvas) {
//         contentByCanvas.createImage = null;
//         contentByCanvas.requestAnimationFrame = null;
//         contentByCanvas.cancelAnimationFrame = null;
//         contentByCanvas = null
//     }
// }

// export function createImage() {
//     return contentByCanvas && contentByCanvas.createImage() || new Image();
// }
// //下面两个尽量自己外层写循环，不用这里的，因为淘宝小程序不同page用了canvas，最好都用各自的requestAnimationFrame，不相互覆盖
// export function getRequestAnimationFrame() {
//     return contentByCanvas && contentByCanvas.requestAnimationFrame || window.requestAnimationFrame.bind(window)
// }
// export function getCancelAnimationFrame() {
//     return contentByCanvas && contentByCanvas.cancelAnimationFrame || window.cancelAnimationFrame.bind(window)
// }

//TODO上面所有的以后考虑这么些写,待测试
let env: "tb" | "web" = "web";
//如果是浏览器环境，声明个my为null，为了无声明不报错
if (window) window["my"] = null;//在用webview的小程序环境内，只要在小程序的sdk前加js就无所谓，
export function getEnv(): "tb" | "web" {
    return env
}
/**
 * 设置运行环境，一般不需要调用，预留
 * 方法initedByTbCanvas会自行设置env为tb
 * @param e 环境
 */
export function setEnv(e: "tb" | "web") {
    env = e;
}
/**
 * 创建一个离屏的canvas
 */
export function createCanvas(): HTMLCanvasElement {
    //@ts-ignore  先这么改把，以后再改TODO，Texture.WHITE有个自执行，所以在setEnv前就会执行web的链路，以后考虑兼容document
    return document && document.createElement("canvas") || my._createOffscreenCanvas();
    //web环境
    if (getEnv() == "web") return document.createElement("canvas");
    //@ts-ignore
    if (getEnv() == "tb") return my._createOffscreenCanvas();
    //提示下
    console.warn("未知环境，创建canvas失败")
}
/**
 * 临时记录的淘宝小程序的主canvas
 */
let tbCanvas;
/**
 * 淘宝小程序项目，拿到canvas先执行这个,修改当前环境
 * @param canvas 
 */
export function initedByTbCanvas(canvas) {
    tbCanvas = canvas;
    setEnv("tb");
}
//兼容老版本，TODO废弃
export function initedByCanvas(canvas) {
    console.warn("方法initedByCanvas即将废弃，请使用方法initedByTbCanvas代替")
    initedByTbCanvas(canvas)
}
/**
 * 销毁记录的tbCanvas，一般也没必要执行，
 * 尤其多页面的淘宝小程序，销毁的话，createImage会有问题
 */
export function destroyTbCanvas() {
    tbCanvas = null;
}
//兼容老版本，TODO废弃
export function destroyCanvasContent() {
    console.warn("方法destroyCanvasContent即将废弃，请使用方法destroyTbCanvas代替")
    destroyTbCanvas();
}

/**
 * 返回图片
 * @returns 
 */
export function createImage(): HTMLImageElement {
    if (getEnv() == "web") return new Image();
    if (getEnv() == "tb") {
        if (tbCanvas) return tbCanvas.createImage();
        console.warn("淘宝小程序初始化canvas不存在");
    }
    console.warn("未知环境，创建Image失败")
}
/**
 * 尽量外部自行调用循环，不用引擎给的，即将废弃
 * @param callback 
 * @returns 
 */
export function requestAnimationFrame(callback) {
    //直接用window的
    if (getEnv() == "web") return window.requestAnimationFrame(callback);
    //淘宝小程序环境
    if (getEnv() == "tb") {
        if (tbCanvas) return tbCanvas.requestAnimationFrame(callback);
        console.warn("淘宝小程序初始化canvas不存在");
    }
    console.warn("未知环境，requestAnimationFrame调用无效")
}
export function cancelAnimationFrame(id: number) {
    if (getEnv() == "web") {
        window.cancelAnimationFrame(id);
        return;
    }
    //淘宝小程序环境
    else if (getEnv() == "tb") {
        if (tbCanvas) {
            tbCanvas.cancelAnimationFrame(id);
            return;
        }
        console.warn("淘宝小程序初始化canvas不存在");
    }
    console.warn("未知环境，cancelAnimationFrame调用无效")
}

//老版本使用提示，TODO废弃
export function getRequestAnimationFrame() {
    console.error("requestAnimationFrame,cancelAnimationFrame统统外部自行调用，引擎内不给方法，淘宝小程序在canvas上，web环境在window上")
}