import Texture from "../../texture/Texture";
import { Matrix } from "../../math";

/**
 * 图形的填充形式
 * @class
 */
export default class FillStyle {
    /**
     * 十六进制颜色
     * 默认0xFFFFFF 白色
     */
    color: number;
    /**
     * 透明度0到1
     * 默认1
     */
    alpha: number;
    /**
     * 纹理，
     * 默认Texture.WHITE
     */
    texture: Texture;
    /**
     * 纹理应用的矩阵
     * 默认null
     */
    matrix: Matrix;
    /**
     * 是否绘制
     * 默认false
     */
    visible: boolean;
    /**
     * 用于设置alpha为0做点击触发用
     */
    alphaBlock: boolean;
    constructor() {
        this.reset();
    }

    clone(): FillStyle {
        const obj: FillStyle = new FillStyle();
        obj.color = this.color;
        obj.alpha = this.alpha;
        obj.texture = this.texture;
        obj.matrix = this.matrix;
        obj.visible = this.visible;
        obj.alphaBlock = this.alphaBlock;
        return obj;
    }

    /**
     * 重置
     */
    reset() {
        this.color = 0xFFFFFF;
        this.alpha = 1;
        this.texture = Texture.WHITE;
        this.matrix = null;
        this.visible = false;

        //
        this.alphaBlock = false;
    }

    /**
     * 销毁
     */
    destroy() {
        this.texture = null;
        this.matrix = null;
    }
}
