import { createCanvas } from "./tbminiAdapte";

let result: boolean = null;
/**
 * 创建带颜色的canvas
 * @ignore
 * @param {string} color - The color to make the canvas
 * @return {canvas} a small canvas element
 */
function createColoredCanvas(color: string): HTMLCanvasElement {
    const canvas = createCanvas()//document.createElement('canvas');
    canvas.width = 6;
    canvas.height = 1;
    const context = canvas.getContext('2d');
    context.fillStyle = color;
    context.fillRect(0, 0, 6, 1);
    return canvas;
}

/**
 * 检查当前浏览器的canvas是否可用blendMode
 * @return {boolean} 为true表示可用
 */
export function canUseNewCanvasBlendModes(): boolean {
    //检查过了
    if (result != null) return result;
    //document都没有
    if (typeof document === 'undefined') {
        result = false;
        return result;
    }

    const magenta = createColoredCanvas('#ff00ff');
    const yellow = createColoredCanvas('#ffff00');

    const canvas = createCanvas()//document.createElement('canvas');

    canvas.width = 6;
    canvas.height = 1;

    const context = canvas.getContext('2d');

    context.globalCompositeOperation = 'multiply';
    context.drawImage(magenta, 0, 0);
    context.drawImage(yellow, 2, 0);

    const imageData = context.getImageData(2, 0, 1, 1);

    if (!imageData) {
        result = false;
        return result;
    }

    const data = imageData.data;
    result = (data[0] === 255 && data[1] === 0 && data[2] === 0)
    return result;
}
