/**
 * ios还有问题，先别用
 */
export function createCanvas(): HTMLCanvasElement {
    //@ts-ignore
    return my && my._createOffscreenCanvas() || document.createElement("canvas")
}
//每次都要重置
let backupCanvasContext: CanvasRenderingContext2D
export function setBackupCanvasContext(bc) {
    backupCanvasContext = bc;
}
export function getBackupCanvasContext() {
    return backupCanvasContext
}
export function destroyBackupCanvasContext() {
    backupCanvasContext = null;
}
/**
 * 备用的canvas上下文，用于绘制文本,图片等等
 * 外面赋值
 */
// export let backupCanvasContext: CanvasRenderingContext2D

let contentByCanvas: {
    createImage: () => HTMLImageElement,
    requestAnimationFrame: (fun: Function) => number,
    cancelAnimationFrame: (id) => void,
};
export function initedByCanvas(canvas) {
    contentByCanvas = {
        createImage: canvas.createImage.bind(canvas),
        //必须加bind，函数内存在this指向
        requestAnimationFrame: canvas.requestAnimationFrame.bind(canvas),
        cancelAnimationFrame: canvas.cancelAnimationFrame.bind(canvas),
    }
}
export function destroyCanvasContent() {
    if (contentByCanvas) {
        contentByCanvas.createImage = null;
        contentByCanvas.requestAnimationFrame = null;
        contentByCanvas.cancelAnimationFrame = null;
        contentByCanvas = null
    }
}

export function getCreateImage() {
    return contentByCanvas && contentByCanvas.createImage || (() => { return new Image() })
}
export function getRequestAnimationFrame() {
    return contentByCanvas && contentByCanvas.requestAnimationFrame || window.requestAnimationFrame
}
export function getCancelAnimationFrame() {
    return contentByCanvas && contentByCanvas.cancelAnimationFrame || window.cancelAnimationFrame
}
