export interface IContainer {
    children: IContainer[]
    name: string
}
function _getElementsByName(name: RegExp | string, root: IContainer, isRecursive?: boolean): IContainer[] {
    if (!name || !root || !root.children || !root.children.length) return [];
    let list: IContainer[] = [];
    let rex: RegExp;
    if (typeof (name) == "string") {
        rex = new RegExp("^" + name + "$");
    } else {
        rex = name;
    }
    let child: IContainer;
    for (let i = 0; i < root.children.length; i++) {
        child = root.children[i];
        if (rex.test(child.name)) {
            list.push(child);
        }
        if (isRecursive) {
            list.push(..._getElementsByName(rex, child, isRecursive));
        }
    }
    return list;
}