import { Mesh3D } from "../core/Mesh3D";
import { Geometry3D } from "../core/Geometry3D";
import { BaseMaterial } from "../materials";
import { DataAttribute } from "../../2d/renderers/webgl/DataAttribute";


export class AxesHelper extends Mesh3D {
	constructor(size: number = 1) {
		var vertices = [
			0, 0, 0, size, 0, 0,
			0, 0, 0, 0, size, 0,
			0, 0, 0, 0, 0, size
		];
		var colors = [
			1, 0, 0, 1, 0.6, 0,
			0, 1, 0, 0.6, 1, 0,
			0, 0, 1, 0, 0.6, 1
		];

		var geometry = new Geometry3D()
			.addAttribute('aPosition', new DataAttribute(new Float32Array(vertices), 3))
			.addAttribute('aColor', new DataAttribute(new Float32Array(colors), 3));
		var material = new BaseMaterial({ wireframe: true, useVertexColor: true })

		super(geometry, material)
	}
}

