
import { Vector3 } from "../math/Vector3";
import { Vector2 } from "../math/Vector2";
import { Geometry3D } from "../core/Geometry3D";
import { DataAttribute } from "../../2d/renderers/webgl/DataAttribute";


export class CircleGeometry extends Geometry3D {
    constructor(
        radius: number = 1,
        segments: number = 8,
        thetaStart: number = 0,
        thetaLength: number = Math.PI * 2
    ) {
        super();
        segments = Math.max(3, segments);

        var indices = [];
        var vertices = [];
        var normals = [];
        var uvs = [];

        var i, s;
        var vertex = new Vector3();
        var uv = new Vector2();

        // center point

        vertices.push(0, 0, 0);
        normals.push(0, 0, 1);
        uvs.push(0.5, 0.5);

        for (s = 0, i = 3; s <= segments; s++, i += 3) {

            var segment = thetaStart + s / segments * thetaLength;

            // vertex

            vertex.x = radius * Math.cos(segment);
            vertex.y = radius * Math.sin(segment);

            vertices.push(vertex.x, vertex.y, vertex.z);

            // normal

            normals.push(0, 0, 1);

            // uvs

            uv.x = (vertices[i] / radius + 1) / 2;
            // uv.y = ( vertices[ i + 1 ] / radius + 1 ) / 2;
            uv.y = 1 - (vertices[i + 1] / radius + 1) / 2;

            uvs.push(uv.x, uv.y);

        }

        // indices

        for (i = 1; i <= segments; i++) {

            indices.push(i, i + 1, 0);

        }
        this.index = indices;
        this.addAttribute('aPosition', new DataAttribute(new Float32Array(vertices), 3))
            .addAttribute('aNormal', new DataAttribute(new Float32Array(normals), 3))
            .addAttribute('aTextureCoord', new DataAttribute(new Float32Array(uvs), 2));

    }
}