import { BaseTexture } from "../../texture";

//用weakmap和GlFramebuffer对应，还有个管理器，和renderTarget很像
export class Framebuffer {
    public width: number;
    public height: number;
    //标记，是否启用，是否只能用
    private _stencil: boolean = false;
    get stencil() {
        return this._stencil;
    }
    set stencil(v: boolean) {
        this.stencil = v;
        this._dirtyId++;
    }
    _dirtyId: number = 0;
    //基本是为了gltexture对应用，没有source
    private _depthTexture: BaseTexture;
    get depthTexture(): BaseTexture {
        return this._depthTexture
    };
    set depthTexture(v) {
        this._depthTexture = v;
        this._dirtyId++;
    };
    //需要绑定一个，为了取bastT的gltexture
    private _colorTexture: BaseTexture;
    get colorTexture(): BaseTexture {
        return this._colorTexture
    };
    set colorTexture(v) {
        this._colorTexture = v;
        this._dirtyId++;
    };
    /**
     * @param {number} width - 默认100
     * @param {number} height - 默认100
     */
    constructor(width?: number, height?: number) {
        this.width = Math.round(width || 100);
        this.height = Math.round(height || 100);
    }
    /**
     * Resize the frame buffer
     *
     * @param {number} width - Width of the frame buffer to resize to
     * @param {number} height - Height of the frame buffer to resize to
     */
    resize(width: number, height: number): void {
        width = Math.round(width);
        height = Math.round(height);

        if (width === this.width && height === this.height) return;

        this.width = width;
        this.height = height;

        this._dirtyId++;
        //
        if (this.colorTexture) {
            this.colorTexture["_setSize"](width, height)
        };

        if (this.depthTexture) {
            this.depthTexture["_setSize"](width, height)
        }
    }
}