
import Graphics from '../../graphics/Graphics';
import { WebglRenderer } from '../WebglRenderer';
import { SpriteMaskFilter } from '../../filter';
import { DisplayObject } from '../../display';

/**
 * 暂时只用滤镜和模版缓存的形式
 */
export default class MaskManager {
    private alphaMaskPool: any[] = [];
    private alphaMaskIndex: number = 0;
    constructor(public renderer: WebglRenderer) { }
    /**
     * 
     * @param {DisplayObject} target 被遮罩的对象
     * @param {Sprite|Graphics|Shape} maskData 遮罩数据
     */
    push<T extends DisplayObject>(target: T, maskData) {
        if (maskData.texture) {//这样判断不一定靠谱，最好判断isSprite
            this.pushSpriteMask(target, maskData);
        }
        else {
            this.pushStencilMask(maskData);
        }
    }

    /**
     * 
     * @param {DisplayObject} target 被遮罩的对象
     * @param {Sprite|Graphics|Shape} maskData 遮罩数据
     */
    pop<T extends DisplayObject>(target: T, maskData) {
        if (maskData.texture) {
            this.popSpriteMask();
        }
        else {
            this.popStencilMask();
        }
    }

    /**
     * 
     * @param {DisplayObject} target 被遮罩的对象
     * @param {Sprite} maskData 遮罩数据
     */
    private pushSpriteMask(target, maskData) {
        let alphaMaskFilter = this.alphaMaskPool[this.alphaMaskIndex];

        if (!alphaMaskFilter) {
            alphaMaskFilter = this.alphaMaskPool[this.alphaMaskIndex] = [new SpriteMaskFilter(maskData)];
        } else {
            alphaMaskFilter[0].resolution = 1;
            alphaMaskFilter[0].maskSprite = maskData;
        }

        //存下之前的滤镜区域
        const cacheFilterArea = target.filterArea;
        //取遮罩的范围
        target.filterArea = maskData.getBounds(true);

        this.renderer.filterManager.pushFilter(target, alphaMaskFilter);
        //恢复
        target.filterArea = cacheFilterArea;

        this.alphaMaskIndex++;
    }

    private popSpriteMask() {
        this.renderer.filterManager.popFilter();
        this.alphaMaskIndex--;
    }

    private pushStencilMask(maskData: Graphics) {
        this.renderer.batchManager.flush();
        this.renderer.stencilManager.push(maskData);
    }

    private popStencilMask() {
        this.renderer.stencilManager.pop();
    }

    destroy() {
        this.renderer = null;
        this.alphaMaskPool = null;
    }
}
