import { Object3D } from "../Object3D";
import { Matrix4 } from "../math/Matrix4";
import { Vector3 } from "../math/Vector3";



export class Camera extends Object3D {


	worldMatrixInverse: Matrix4;
	projectionMatrix: Matrix4;
	projectionMatrixInverse: Matrix4;

	constructor() {
		super();
		this._instanceType = 'Camera';

		this.worldMatrixInverse = new Matrix4();

		this.projectionMatrix = new Matrix4();
		this.projectionMatrixInverse = new Matrix4();
	}

	/**
	 * 重写
	 * @param recursive 
	 */
	clone() {
		return new Camera().copy(this);
	}

	copy(source, recursive?) {
		super.copy(source, recursive)
		// Object3D.prototype.copy.call(this, source, recursive);
		this.worldMatrixInverse.copy(source.matrixWorldInverse);
		this.projectionMatrix.copy(source.projectionMatrix);
		this.projectionMatrixInverse.copy(source.projectionMatrixInverse);
		return this;
	};

	getWorldDirection(target:Vector3) {

		this.updateWorldMatrix();

		var e = this._worldMatrix.elements;

		return target.set(- e[8], - e[9], - e[10]).normalize();

	}

	updateWorldMatrix() {
        super.updateWorldMatrix()
		
		this.worldMatrixInverse.setInverseOf(this._worldMatrix);
	}
}