
//默认下顶点着色器都用highp float精度，片元着色器用mediump float

export const defaultVert =
    "precision highp float;" +
    "attribute vec2 aVertexPosition;" +
    "attribute vec2 aTextureCoord;" +

    "uniform mat3 projectionMatrix;" +

    "varying vec2 vTextureCoord;" +

    "void main(void){" +
    "gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);" +
    "vTextureCoord = aTextureCoord;" +
    "}"

export const defaultFilterMatrix =
    "precision highp float;" +
    "attribute vec2 aVertexPosition;" +
    "attribute vec2 aTextureCoord;" +

    "uniform mat3 projectionMatrix;" +
    "uniform mat3 filterMatrix;" +

    "varying vec2 vTextureCoord;" +
    "varying vec2 vFilterCoord;" +

    "void main(void){" +
    "gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);" +
    "vFilterCoord = ( filterMatrix * vec3( aTextureCoord, 1.0)  ).xy;" +
    "vTextureCoord = aTextureCoord;" +
    "}"