import { Camera } from "./Camera";



export class OrthographicCamera extends Camera {
	zoom: number;
	constructor(
		private left: number = -1,
		private right: number = 1,
		private top: number = 1,
		private bottom: number = -1,
		private near: number = 0.1,
		private far: number = 2000,
	) {
		super();
		this._instanceType = 'OrthographicCamera';
		this.zoom = 1;

		this.updateProjectionMatrix();
	}
	set(
		left: number,
		right: number,
		top: number,
		bottom: number,
		near: number = 0.1,
		far: number = 2000,
	) {
		this.zoom = 1;
		this.left = left;
		this.right = right;
		this.top = top;
		this.bottom = bottom;
		this.near = near;
		this.far = far;

		this.updateProjectionMatrix();
	}
	copy(source: OrthographicCamera, recursive: boolean = true) {

		super.copy(source, recursive)

		this.left = source.left;
		this.right = source.right;
		this.top = source.top;
		this.bottom = source.bottom;
		this.near = source.near;
		this.far = source.far;

		this.zoom = source.zoom;

		this.updateProjectionMatrix();

		return this;

	}
	clone() {
		return new OrthographicCamera().copy(this)
	}
	updateProjectionMatrix() {
		var dx = (this.right - this.left) / (2 * this.zoom);
		var dy = (this.top - this.bottom) / (2 * this.zoom);
		var cx = (this.right + this.left) / 2;
		var cy = (this.top + this.bottom) / 2;

		var left = cx - dx;
		var right = cx + dx;
		var top = cy + dy;
		var bottom = cy - dy;

		this.projectionMatrix.setOrtho(left, right, top, bottom, this.near, this.far);

		this.projectionMatrixInverse.setInverseOf(this.projectionMatrix);
	}
}

