import { DisplayObject } from "../../display/DisplayObject";
import { WebglRenderer } from "../WebglRenderer";

/**
 * Base for a common object renderer that can be used as a system renderer plugin.
 * 基础渲染插件基类
 */
export default class ObjectRenderer {
    /**
     * The renderer this manager works for.
     *
     * @member {Renderer}
     */
    renderer: WebglRenderer
    constructor(renderer: WebglRenderer) {
        this.renderer = renderer;

        //监听
        this.renderer.addEventListener('onContextChange', this.onContextChange, this);
    }


    /**
     * Generic method called when there is a WebGL context change.
     *
     * @param {WebGLRenderingContext} gl new webgl context
     */
    onContextChange() {
        // do some codes init!
    }
    /**
     * Starts the renderer and sets the shader
     *
     */
    start() {
        // set the shader..
    }

    /**
     * Stops the renderer
     *
     */
    stop() {
        this.flush();
    }

    /**
     * Stub method for rendering content and emptying the current batch.
     *
     */
    flush() {
        // flush!
    }

    /**
     * Renders an object
     *
     */
    render(object: any) {
        // render the object
    }
    /**
     * Generic destroy methods to be overridden by the subclass
     */
    destroy() {
        this.renderer.removeEventListener('onContextChange', this.onContextChange, this);
        this.renderer = null;
    }
}
