var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var FYGE = window.FYGE;
(function (FYGE) {
    var EditableText = /** @class */ (function (_super) {
        __extends(EditableText, _super);
        function EditableText() {
            var _this = _super.call(this) || this;
            _this._prompt = "请输入";
            _this._promptColor = "#eeeeee";
            _this._textColor = "#000000";
            /**
             * 输入的内容
             */
            _this._inputValue = "";
            _this._instanceType = "EditableText";
            var s = _this;
            s.onKeyboardComplete = s.onKeyboardComplete.bind(s);
            s.onKeyboardInput = s.onKeyboardInput.bind(s);
            s.addEventListener(FYGE.MouseEvent.CLICK, function () {
                var info = {
                    defaultValue: s._inputValue,
                    maxLength: 9999,
                    multiple: s.lineType == FYGE.TEXT_lINETYPE.MULTI,
                    confirmHold: true,
                    confirmType: 'done',
                    fail: function (res) {
                        console.log(res.errMsg);
                    }
                };
                wx.showKeyboard(info);
                wx.onKeyboardConfirm(s.onKeyboardComplete);
                wx.onKeyboardComplete(s.onKeyboardComplete);
                wx.onKeyboardInput(s.onKeyboardInput);
                s.dispatchEvent(FYGE.Event.FOCUS);
                //
                s.text = s._inputValue || s.prompt;
                s.fillColor = s._inputValue ? s.textColor : s.promptColor;
                //待测试能否手动调用
                s.stage.once(FYGE.MouseEvent.MOUSE_UP, function () {
                    s.onKeyboardComplete({ value: s._inputValue });
                });
            });
            return _this;
        }
        Object.defineProperty(EditableText.prototype, "prompt", {
            /**
             * 未输入文本时显示的文字
             */
            get: function () {
                return this._prompt;
            },
            set: function (value) {
                if (this._prompt != value) {
                    this._prompt = value;
                    this["dirty"] = true;
                    //如果无输入文本直接修改
                    if (!this._inputValue) {
                        this.text = this._prompt;
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EditableText.prototype, "promptColor", {
            /**
             * 未输入文本时显示文字的颜色
             */
            get: function () {
                return this._promptColor;
            },
            set: function (value) {
                if (this._promptColor != value) {
                    this._promptColor = value;
                    this["dirty"] = true;
                    //如果无输入文本直接修改
                    if (!this._inputValue) {
                        this.fillColor = this._promptColor;
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EditableText.prototype, "textColor", {
            /**
             * 文本颜色，不用fillColor为了和父类区分
             * 输入文本时的颜色
             */
            get: function () {
                return this._textColor;
            },
            set: function (value) {
                if (this._textColor != value) {
                    this._textColor = value;
                    this["dirty"] = true;
                    //如果又文本直接修改
                    if (this._inputValue) {
                        this.fillColor = this._textColor;
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EditableText.prototype, "inputValue", {
            /**
             * 获取输入框内容
             */
            get: function () {
                return this._inputValue;
            },
            set: function (v) {
                v = v || "";
                //如果v不存在就用默认文案
                this.text = v ? v : this._prompt;
                //如果v不存在就用默认颜色
                this.fillColor = v ? this.textColor : this._promptColor;
                //记录一下，这个是准确的
                this._inputValue = v;
            },
            enumerable: true,
            configurable: true
        });
        EditableText.prototype.onKeyboardInput = function (data) {
            this.setText(data.value);
            this.dispatchEvent(FYGE.Event.INPUT, data);
        };
        EditableText.prototype.onKeyboardComplete = function (res) {
            var s = this;
            s.setText(res.value);
            wx.offKeyboardComplete();
            wx.offKeyboardConfirm();
            wx.offKeyboardInput();
            wx.hideKeyboard({});
            s.dispatchEvent(FYGE.Event.BLUR, res);
        };
        EditableText.prototype.setText = function (text) {
            var s = this;
            s.text = text ? text : s._prompt;
            s.fillColor = text ? s.textColor : s._promptColor;
            //记录一下需要
            s._inputValue = text;
        };
        return EditableText;
    }(FYGE.TextField));
    FYGE.EditableText = EditableText;
})(FYGE || (FYGE = {}));
