import { Event } from "./Event";
import { DisplayObject } from "../display/DisplayObject";
/**
 * 鼠标事件类
 * @class MouseEvent
 * @extends Event
 * @public
 * @since 1.0.0
 */
export class MouseEvent extends Event {
    /**
     * 鼠标按下事件
     * @property MOUSE_DOWN
     * @static
     * @public
     * @since 1.0.0
     * @type {string}
     */
    public static MOUSE_DOWN: string = "onMouseDown";
    /**
     * 鼠标抬起事件
     * @property MOUSE_UP
     * @static
     * @public
     * @since 1.0.0
     * @type {string}
     */
    public static MOUSE_UP: string = "onMouseUp";
    /**
     * 鼠标点击事件
     * @property CLICK
     * @static
     * @public
     * @since 1.0.0
     * @type {string}
     */
    public static CLICK: string = "onMouseClick";
    /**
     * 鼠标移动事件
     * @property MOUSE_MOVE
     * @static
     * @public
     * @since 1.0.0
     * @type {string}
     */
    public static MOUSE_MOVE: string = "onMouseMove";
    /**
     * 鼠标移入到显示对象上里触发的事件
     * @property MOUSE_OVER
     * @static
     * @public
     * @since 1.0.0
     * @type {string}
     */
    public static MOUSE_OVER: string = "onMouseOver";
    /**
     * 鼠标移出显示对象边界触发的事件
     * @property MOUSE_OUT
     * @static
     * @public
     * @since 1.0.0
     * @type {string}
     */
    public static MOUSE_OUT: string = "onMouseOut";
    /**
     * 鼠标事件时canvas实际尺寸坐标x点
     * @property clientX
     * @public
     * @since 1.0.0
     * @type {number}
     */
    public clientX: number = 0;
    /**
     * 鼠标事件时canvas实际尺寸坐标y点
     * @property clientY
     * @public
     * @since 1.0.0
     * @type {number}
     */
    public clientY: number = 0;
    /**
     * 鼠标事件时stage上坐标x点
     * @property stageX
     * @public
     * @since 1.0.0
     * @type {number}
     */
    public stageX: number = 0;
    /**
     * 鼠标事件时stage上坐标y点
     * @property stageY
     * @public
     * @since 1.0.0
     * @type {number}
     */
    public stageY: number = 0;
    /**
     * 鼠标事件时显示对象本地坐标x点
     * @property localX
     * @public
     * @since 1.0.0
     * @type {number}
     */
    public localX: number = 0;
    /**
     * 鼠标事件时显示对象本地坐标y点
     * @property localY
     * @public
     * @since 1.0.0
     * @type {number}
     */
    public localY: number = 0;
    /**
     * 鼠标事件的终点对象，注意区分target
     * @property currentTarget
     * @public
     * @since 1.0.0
     * @type{DisplayObject}
     * @default null
     */
    public currentTarget: DisplayObject = null;
    /**
     * 鼠标事件的手指唯一标识
     * @property identifier
     * @type {number}
     * @since 1.1.2
     * @public
     */
    public identifier: any = 0;
    /**
     * @method MouseEvent
     * @public
     * @since 1.0.0
     * @param {string} type
     */
    public constructor(type: string) {
        super(type);
        this._instanceType = "MouseEvent";
    }
    /**
     * 销毁
     */
    public destroy(): void {
        //清除相应的数据引用
        let s = this;
        s.currentTarget = null;
        super.destroy();
    }
}