declare const wx;
namespace FYGE {
    export class EditableText extends FYGE.TextField {
        private _prompt: string = "请输入";
        /**
         * 未输入文本时显示的文字
         */
        get prompt() {
            return this._prompt
        }
        set prompt(value: string) {
            if (this._prompt != value) {
                this._prompt = value;
                this["dirty"] = true;
                //如果无输入文本直接修改
                if (!this._inputValue) {
                    this.text = this._prompt;
                }
            }
        }
        private _promptColor: string = "#eeeeee";
        /**
         * 未输入文本时显示文字的颜色
         */
        get promptColor() {
            return this._promptColor
        }
        set promptColor(value: string) {
            if (this._promptColor != value) {
                this._promptColor = value;
                this["dirty"] = true;
                //如果无输入文本直接修改
                if (!this._inputValue) {
                    this.fillColor = this._promptColor;
                }
            }
        }

        private _textColor: string = "#000000";
        /**
         * 文本颜色，不用fillColor为了和父类区分
         * 输入文本时的颜色
         */
        get textColor() {
            return this._textColor
        }
        set textColor(value: string) {
            if (this._textColor != value) {
                this._textColor = value;
                this["dirty"] = true;
                //如果又文本直接修改
                if (this._inputValue) {
                    this.fillColor = this._textColor;
                }
            }
        }
        /**
         * 输入的内容
         */
        private _inputValue: string = ""
        /**
         * 获取输入框内容
         */
        get inputValue(): string {
            return this._inputValue;
        }
        set inputValue(v: string) {
            v = v || "";
            //如果v不存在就用默认文案
            this.text = v ? v : this._prompt;
            //如果v不存在就用默认颜色
            this.fillColor = v ? this.textColor : this._promptColor;
            //记录一下，这个是准确的
            this._inputValue = v;
        }

        public constructor() {
            super();
            this._instanceType = "EditableText";
            var s: this = this;
            s.onKeyboardComplete = s.onKeyboardComplete.bind(s);
            s.onKeyboardInput = s.onKeyboardInput.bind(s);
            s.addEventListener(FYGE.MouseEvent.CLICK, function () {
                var info = {
                    defaultValue: s._inputValue,
                    maxLength: 9999,//暂时不管
                    multiple: s.lineType == FYGE.TEXT_lINETYPE.MULTI,
                    confirmHold: true,
                    confirmType: 'done',
                    fail: function (res) {
                        console.log(res.errMsg);
                    }
                };
                wx.showKeyboard(info);
                wx.onKeyboardConfirm(s.onKeyboardComplete);
                wx.onKeyboardComplete(s.onKeyboardComplete);
                wx.onKeyboardInput(s.onKeyboardInput);
                s.dispatchEvent(FYGE.Event.FOCUS);

                //
                s.text = s._inputValue || s.prompt;
                s.fillColor = s._inputValue ? s.textColor : s.promptColor;
                //待测试能否手动调用
                s.stage.once(FYGE.MouseEvent.MOUSE_UP, () => {
                    s.onKeyboardComplete({ value: s._inputValue })
                });
            });

        }
        private onKeyboardInput(data) {
            this.setText(data.value)
            this.dispatchEvent(FYGE.Event.INPUT, data);
        }
        private onKeyboardComplete(res) {
            var s = this;
            s.setText(res.value)

            wx.offKeyboardComplete();
            wx.offKeyboardConfirm();
            wx.offKeyboardInput();
            wx.hideKeyboard({});
            s.dispatchEvent(FYGE.Event.BLUR, res);
        }
        private setText(text: string) {
            var s = this;
            s.text = text ? text : s._prompt;
            s.fillColor = text ? s.textColor : s._promptColor;
            //记录一下需要
            s._inputValue = text;
        }
    }
}